package jp.co.cybec.laxide.model.base;

import jp.co.cybec.laxide.util.LetsAjaxUtil;

import org.eclipse.ui.views.properties.ComboBoxPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.jdom.Element;

/**
 * C[Wt@C̃fNX
 * 
 * @author tokumaru
 */
public class LetsAjaxImageModel extends BaseModel {
	/** t@C */
	private String file = "file";

	/** alt */
	private String alt = "alt";

	public static final String P_EVENT = "_event";

	public static final String P_DATASOURCE_ID = "_dataSourceId";

	public static final String P_FILE = "_file";

	public static final String P_ALT = "_alt";

	private String componentWidth = "60";

	private String componentHeight = "50";

	private String dataSourceId = "dataSourceId";

	private int eventId = 1;

	private String events[] = { "", "onClick", "onDblClick ", "onMouseDown",
			"onKeyDown", "onKeyPress", "onKeyUp", "onMouseDown", "onMouseUp",
			"onMouseOver", "onMouseOut", "onMouseMove", "onChange", "onSelect" };

	/*
	 * (non-Javadoc)
	 * 
	 * @see jp.co.cybec.laxide.model.base.BaseModel#getBodyComponentXml()
	 */
	@Override
	public String getBodyComponentXml() {
		String html = "";
		html = html + getFileForXml() + getAltForXml();
		html = html + getEventForXml() + getDataSourceIdForXml();
		html = html + getComponetWidthForXml() + getComponetHeightForXml();
		html = html + getCssClassNameForXml();

		return html;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see jp.co.cybec.laxide.model.base.AbstractModel#setAttribute(org.jdom.Element)
	 */
	@Override
	public void setAttribute(Element element) {

		super.setAttribute(element);
		super.setType(LetsAjaxLayoutConstant.LETSAJAX_BODY_IMAGE);
		this
				.setFile(element
						.getAttributeValue(LetsAjaxLayoutConstant.LETSAJAX_ATTRIBUTE_FILE));
		this
				.setAlt(element
						.getAttributeValue(LetsAjaxLayoutConstant.LETSAJAX_ATTRIBUTE_ALT));
		String event = element
				.getAttributeValue(LetsAjaxLayoutConstant.LETSAJAX_ATTRIBUTE_EVENT);
		String dataSourceId = element
				.getAttributeValue(LetsAjaxLayoutConstant.LETSAJAX_ATTRIBUTE_DATASOURCEID);
		String cssClass = element
				.getAttributeValue(LetsAjaxLayoutConstant.LETSAJAX_ATTRIBUTE_CLASSNAME);

		String height = element
				.getAttributeValue(LetsAjaxLayoutConstant.LETSAJAX_ATTRIBUTE_COMPONENT_HEIGHT);
		if (height != null && !height.equals("")) {
			componentHeight = height;
		}

		String width = element
				.getAttributeValue(LetsAjaxLayoutConstant.LETSAJAX_ATTRIBUTE_COMPONENT_WIDTH);
		if (width != null && !width.equals("")) {
			componentWidth = width;
		}

		setDataSourceId(dataSourceId);
		super.setCssClassName(cssClass);

		setEventId(1);
		for (int i = 0; i < events.length; i++) {
			if (event != null && event.equals(events[i])) {
				setEventId(i + 1);
				break;
			}
		}
	}

	/**
	 * t@Cݒ肵܂
	 * 
	 * @param value
	 *            t@C
	 */
	public void setFile(String value) {
		this.file = LetsAjaxUtil.checkNull(value);
		firePropertyChange(P_FILE, null, this.file);
	}

	/**
	 * t@C擾܂
	 * 
	 * @return t@C
	 */
	public String getFile() {
		return this.file;
	}

	/**
	 * փeLXgݒ肵܂
	 * 
	 * @param value
	 *            փeLXg
	 */
	public void setAlt(String value) {
		this.alt = LetsAjaxUtil.checkNull(value);
		firePropertyChange(P_ALT, null, this.alt);
	}

	/**
	 * փeLXgԂ܂
	 * 
	 * @return փeLXg
	 */
	public String getAlt() {
		return this.alt;
	}

	/**
	 * .laxɐݒ肷邽߂̃t@CԂ܂
	 * 
	 * @return .laxɐݒ肷邽߂̃t@C
	 */
	private String getFileForXml() {
		if (this.file == null || (this.file != null && this.file.equals(""))) {
			return "";
		}

		return " file=\"" + this.file + "\" ";
	}

	/**
	 * .laxɐݒ肷邽߂̑փeLXgԂ܂
	 * 
	 * @return .laxɐݒ肷邽߂̑փeLXg
	 */
	private String getAltForXml() {
		if (this.alt == null || (this.alt != null && this.alt.equals(""))) {
			return "";
		}
		return " alt=\"" + this.alt + "\" ";
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see jp.co.cybec.laxide.model.base.AbstractModel#getPropertyDescriptors()
	 */
	public IPropertyDescriptor[] getPropertyDescriptors() {
		IPropertyDescriptor[] descriptors = new IPropertyDescriptor[] {
				new TextPropertyDescriptor(P_ID, "ID"),
				new TextPropertyDescriptor(P_FILE, "C[Wt@C"),
				new TextPropertyDescriptor(P_ALT, "փeLXg"),
				new ComboBoxPropertyDescriptor(P_EVENT, "Cxg", events),
				new TextPropertyDescriptor(P_CLASS_NAME, "CSSNX"),
				new TextPropertyDescriptor(P_DATASOURCE_ID, "DATASOURCEID") };
		return descriptors;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see jp.co.cybec.laxide.model.base.AbstractModel#getPropertyValue(java.lang.Object)
	 */
	public Object getPropertyValue(Object id) {
		if (id.equals(P_ID)) {
			return super.id;
		} else if (id.equals(P_FILE)) {
			return this.file;
		} else if (id.equals(P_ALT)) {
			return this.alt;
		} else if (id.equals(P_EVENT)) {
			return new Integer(this.eventId - 1);
		} else if (id.equals(P_DATASOURCE_ID)) {
			return dataSourceId;
		} else if (id.equals(P_CLASS_NAME)) {
			return getCssClassName();
		}

		return null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see jp.co.cybec.laxide.model.base.AbstractModel#isPropertySet(java.lang.Object)
	 */
	public boolean isPropertySet(Object id) {
		if (id.equals(P_FILE) || id.equals(P_EVENT) || id.equals(P_ALT)
				|| id.equals(P_DATASOURCE_ID) || id.equals(P_CLASS_NAME)) {
			return true;
		} else {
			return false;
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see jp.co.cybec.laxide.model.base.AbstractModel#setPropertyValue(java.lang.Object,
	 *      java.lang.Object)
	 */
	public void setPropertyValue(Object id, Object value) {
		if (id.equals(P_FILE)) {
			setFile((String) value);
		} else if (id.equals(P_EVENT)) {
			setEventId(((Integer) value).intValue() + 1);
		} else if (id.equals(P_DATASOURCE_ID)) {
			setDataSourceId((String) value);
		} else if (id.equals(P_ALT)) {
			setAlt((String) value);
		} else if (id.equals(P_CLASS_NAME)) {
			setCssClassName((String) value);
		}
	}

	/**
	 * i̕Ԃ܂
	 * 
	 * @return i̕
	 */
	public String getComponentWidth() {
		return this.componentWidth;
	}

	/**
	 * i̕ݒ肵܂
	 * 
	 * @param width
	 *            i̕
	 */
	public void setComponentWidth(String width) {
		this.componentWidth = width;
	}

	/**
	 * .laxt@Cɐݒ肷邽߂̕i̕Ԃ܂
	 * 
	 * @return .laxt@Cɐݒ肷邽߂̕i̕
	 */
	private String getComponetWidthForXml() {
		if (componentWidth == null
				|| (componentWidth != null && componentWidth.equals(""))) {
			return " componentWidth=\"60\"";
		}
		return " componentWidth=\"" + this.componentWidth + "\" ";
	}

	/**
	 * i̍Ԃ܂
	 * 
	 * @return i̍
	 */
	public String getComponetHeight() {
		return this.componentHeight;
	}

	/**
	 * i̍ݒ肵܂
	 * 
	 * @param componentHeight
	 *            i̍
	 */
	public void setComponentHeight(String componentHeight) {
		this.componentHeight = componentHeight;
	}

	/**
	 * .laxt@Cɐݒ肷邽߂̕i̍Ԃ܂
	 * 
	 * @return .laxt@Cɐݒ肷邽߂̕i̍
	 */
	private String getComponetHeightForXml() {
		if (componentHeight == null
				|| (componentHeight != null && componentHeight.equals(""))) {
			return " componentHeight=\"50\"";
		}
		return " componentHeight=\"" + this.componentHeight + "\" ";
	}

	/**
	 * f[^\[XIDԂ܂
	 * 
	 * @return dataSourceId f[^\[XID
	 */
	public String getDataSourceId() {
		return dataSourceId;
	}

	/**
	 * f[^\[XIDݒ肵܂
	 * 
	 * @param dataSourceId
	 *            f[^\[XID
	 */
	public void setDataSourceId(String dataSourceId) {
		this.dataSourceId = LetsAjaxUtil.checkNull(dataSourceId);
		firePropertyChange(P_DATASOURCE_ID, null, this.dataSourceId);
	}

	/**
	 * .laxt@Cɐݒ肷邽߂̃f[^\[XID擾܂
	 * 
	 * @return .laxt@Cɐݒ肷邽߂̃f[^\[XID
	 */
	private String getDataSourceIdForXml() {
		if (this.dataSourceId == null
				|| (this.dataSourceId != null && this.dataSourceId.equals(""))) {
			return "";
		}
		return " dataSourceId=\"" + this.dataSourceId + "\" ";
	}

	/**
	 * CxgID擾܂
	 * 
	 * @return event CxgID
	 */
	public int getEventId() {
		return eventId;
	}

	/**
	 * CxgIDݒ肵܂
	 * 
	 * @param event
	 *            CxgID
	 */
	public void setEventId(Integer eventId) {
		this.eventId = LetsAjaxUtil.checkNull(eventId);
		firePropertyChange(P_EVENT, null, this.eventId);
	}

	/**
	 * .laxɐݒ肷邽߂̃CxgIDԂ܂
	 * 
	 * @return CxgID
	 */
	private String getEventForXml() {
		return " event=\"" + events[eventId - 1] + "\"";
	}
}
