package jp.co.cybec.laxide.model.base;

import jp.co.cybec.laxide.layout.AbstractLayoutPoints;
import jp.co.cybec.laxide.layout.LetsAjaxLayoutPointFactory;

import org.eclipse.draw2d.geometry.Point;
import org.jdom.Element;

/**
 * vCCAEg̃fNX
 * 
 * @author tokumaru
 */
public class LetsAjaxPlainLayoutModel extends BaseModel implements
		I_LetsAjaxLayoutModel {
	
	/* (non-Javadoc)
	 * @see jp.co.cybec.laxide.model.base.BaseModel#getLayoutXML()
	 */
	@Override
    public String getLayoutXML() {
		String html = "<" + super.getType() + this.getId() + getBodyComponentXml() + ">\n";
		html = html + "        " + getAreaElement();
    	html = html + "    </" + super.getType() + ">\n";
		return html;
	}
	
	/* (non-Javadoc)
	 * @see jp.co.cybec.laxide.model.base.BaseModel#getBodyComponentXml()
	 */
	@Override
	public String getBodyComponentXml() {
		return " templateClass=\"LetsAjaxPlainLayout\"";
	}

	/* (non-Javadoc)
	 * @see jp.co.cybec.laxide.model.base.AbstractModel#setAttribute(org.jdom.Element)
	 */
	@Override
	public void setAttribute(Element element) {
		super.setAttribute(element);
		super.setType(LetsAjaxLayoutConstant.LETSAJAX_BODY_PLAIN_LAYOUT);
	}
    
	/**
	 * CAEgGÃ|Cg^OԂ܂
	 * 
	 * @return
	 */
	private String getAreaElement() {
		// LbVĂW{bNX̘g̍W擾
		AbstractLayoutPoints points = LetsAjaxLayoutPointFactory.getInstance().getLayoutPoints();
		
		Point contentsStartPoint = points.getContentsStartPoint();
		Point contentsEndPoint = points.getContentsEndPoint();
		
		return "<area name=\"contents\" startX=\"" + contentsStartPoint.x
		                           + "\" startY=\"" + contentsStartPoint.y
		                           + "\" endX=\"" + contentsEndPoint.x
		                           + "\" endY=\"" + contentsEndPoint.y + "\"/>\n";
	}

	/* (non-Javadoc)
	 * @see jp.co.cybec.laxide.model.base.AbstractModel#setPropertyValue(java.lang.Object, java.lang.Object)
	 */
	public void setPropertyValue(Object id, Object value) {
	}

}
