package jp.co.cybec.laxide.model.extension;

import jp.co.cybec.laxide.model.base.BaseModel;
import jp.co.cybec.laxide.model.base.LetsAjaxLayoutConstant;

import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.jdom.Element;

/**
 * f[^e[upfNX t@CFLetsAjaxDataTableModel.java
 * 
 * @author nakamura 쐬F15:29:23
 * 
 */
public class LetsAjaxDataTableModel extends BaseModel {
	public static final String P_ID = "_id";

	public static final String P_NAME = "_name";

	public static final String P_DATASOURCE_ID = "_dataSourceId";
	
	public static final String P_BORDER_SIZE = "_borderSize";

	private String name = "DataTABLE";

	private String dataSource = "dataSource";

	private String width = "100%";

	private String height = "100%";

	private String borderSize = "0";

	public String getName() {
		return this.name;
	}

	private String getNameForXml() {
		if (name == null || (name != null && name.equals(""))) {
			return "";
		}
		return " name=\"" + this.name + "\" ";
	}

	public void setName(String name) {
		this.name = name;
		firePropertyChange(P_NAME, null, name);
	}

	public IPropertyDescriptor[] getPropertyDescriptors() {
		IPropertyDescriptor[] descriptors = new IPropertyDescriptor[] {
				new TextPropertyDescriptor(P_ID,
						LetsAjaxLayoutConstant.LETSAJAX_LANG_COMPONENTID),
				new TextPropertyDescriptor(P_BORDER_SIZE,
						LetsAjaxLayoutConstant.LETSAJAX_LANG_TABLE_BORDER_WIDTH),
				new TextPropertyDescriptor(P_NAME,
						LetsAjaxLayoutConstant.LETSAJAX_LANG_TABLE_NAME),
				new TextPropertyDescriptor(P_DATASOURCE_ID,
						LetsAjaxLayoutConstant.LETSAJAX_LANG_DATASOURCEID) };
		return descriptors;

	}

	public Object getPropertyValue(Object propertyValue) {
		if (propertyValue.equals(P_ID)) {
			return super.getComponentId();
		} else if (propertyValue.equals(P_NAME)) {
			return name;
		} else if (propertyValue.equals(P_DATASOURCE_ID)) {
			return dataSource;
		} else if (propertyValue.equals(P_BORDER_SIZE)) {
			return borderSize;
		}
		return null;
	}

	public boolean isPropertySet(Object id) {
		if (id.equals(P_NAME) || id.equals(P_DATASOURCE_ID)
				|| id.equals(P_BORDER_SIZE) || id.equals(P_ID)) {
			return true;
		} else {
			return false;
		}
	}

	public void setPropertyValue(Object id, Object value) {
		if (id.equals(P_ID)) {
			super.setId((String) value);
		} else if (id.equals(P_NAME)) {
			setName((String) value);
		} else if (id.equals(P_DATASOURCE_ID)) {
			setDataSource((String) value);
		} else if (id.equals(P_BORDER_SIZE)) {
			setBorderSize((String) value);
		}
	}

	/**
	 * @see jp.co.cybec.laxide.model.base.AbstractModel#getBodyComponentXml()
	 */
	@Override
	public String getBodyComponentXml() {
		return this.getNameForXml() + getDataSourceForXml() + getWidthForXml()
				+ getHeighthForXml() + getBorderSizeForXml();
	}

	private String getDataSourceForXml() {
		if (this.dataSource == null
				|| (this.dataSource != null && this.dataSource.equals(""))) {
			return "";
		}
		return " dataSourceId=\"" + this.dataSource + "\" ";
	}

	/**
	 * @return columnCount
	 */
	public String getDataSource() {
		return dataSource;
	}

	/**
	 * @param columnCount
	 *            columnCount ݒB
	 */
	public void setDataSource(String dataSource) {
		this.dataSource = dataSource;
		firePropertyChange(P_DATASOURCE_ID, null, dataSource);
	}

	private String getBorderSizeForXml() {
		if (this.borderSize == null
				|| (this.borderSize != null && this.borderSize.equals(""))) {
			this.borderSize = "0";
		}
		return " tableBorder=\"" + this.borderSize + "\" ";
	}

	/**
	 * @return borderSize
	 */
	public String getBorderSize() {
		return borderSize;
	}

	/**
	 * @param borderSize
	 *            borderSize ݒB
	 */
	public void setBorderSize(String borderSize) {
		this.borderSize = borderSize;
		firePropertyChange(P_BORDER_SIZE, null, borderSize);
	}

	private String getHeighthForXml() {
		if (this.height == null
				|| (this.height != null && this.height.equals(""))) {
			this.height = "100%";
		}
		return " tableHeight=\"" + this.height + "\" ";
	}

	/**
	 * @return height
	 */
	public String getHeight() {
		return height;
	}

	// /**
	// * @param height
	// * height ݒB
	// */
	// public void setHeight(String height) {
	// this.height = height;
	// firePropertyChange(P_HEIGHT, null, height);
	// }

	private String getWidthForXml() {
		if (this.width == null || (this.width != null && this.width.equals(""))) {
			this.width = "100%";
		}
		return " tableWidth=\"" + this.width + "\" ";
	}

	/**
	 * @return width
	 */
	public String getWidth() {
		return width;
	}

	// /**
	// * @param width
	// * width ݒB
	// */
	// public void setWidth(String width) {
	// this.width = width;
	// firePropertyChange(P_WIDTH, null, width);
	// }

	/**
	 * @see jp.co.cybec.laxide.model.base.AbstractModel#setAttribute(org.jdom.Element)
	 */
	@Override
	public void setAttribute(Element element) {
		super.setAttribute(element);
		String name = element
				.getAttributeValue(LetsAjaxLayoutConstant.LETSAJAX_ATTRIBUTE_NAME);
		String dataSource = element
				.getAttributeValue(LetsAjaxLayoutConstant.LETSAJAX_ATTRIBUTE_DATASOURCEID);
		if (dataSource == null || (dataSource != null && dataSource.equals(""))) {
			dataSource = "dataSource";
		}

		String tableBorderSize = element
				.getAttributeValue(LetsAjaxLayoutConstant.LETSAJAX_ATTRIBUTE_TABLE_BORDER);

		setType(LetsAjaxLayoutConstant.LETSAJAX_BODY_DATATABLE);
		setName(name);
		setDataSource(dataSource);
		setBorderSize(tableBorderSize);
		setConstraint(new Rectangle(Integer.parseInt(getX()), Integer
				.parseInt(getY()), 80, 70));
	}
}
