/**
 * vWFNg laxIde
 * NX LetsAjaxDataTableJSModel.java
 * 쐬: 2007/06/07
 * 
 */
package jp.co.cybec.laxide.model.js;

import jp.co.cybec.laxide.model.base.LetsAjaxLayoutConstant;

import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.jdom.Element;

/**
 * f[^e[uɊ֘AJavaScriptɑ郂f t@CFLetsAjaxDataTableJSModel.java
 * 
 * @author nakamura 쐬F10:21:59
 * 
 */
public class LetsAjaxDataTableJSModel extends JSBaseModel {
	public static final String P_JSTYPE = "_jsType";

	public static final String P_DATASOURCE_ID = "_dataSourceId";

	public static final String P_TARGET_ID = "_targetId";

	private String jsType = "DWR";

	private String dataSourceId = "";

	private String targetId = "targetId";

	public String getJsType() {
		return this.jsType;
	}

	private String getJsNameForXml() {
		if (jsType == null || (jsType != null && jsType.equals(""))) {
			return "";
		}
		return " jsType=\"" + this.jsType + "\" ";
	}

	public void setJsType(String text) {
		this.jsType = text;
		firePropertyChange(P_JSTYPE, null, text);
	}

	public IPropertyDescriptor[] getPropertyDescriptors() {
		IPropertyDescriptor[] descriptors = new IPropertyDescriptor[] {
				new TextPropertyDescriptor(P_DATASOURCE_ID,
						LetsAjaxLayoutConstant.LETSAJAX_LANG_DATASOURCEID),
				new TextPropertyDescriptor(P_TARGET_ID,
						LetsAjaxLayoutConstant.LETSAJAX_LANG_TARGETID),
				new TextPropertyDescriptor(P_JSTYPE,
						LetsAjaxLayoutConstant.LETSAJAX_LANG_SERVICE_TYPE) };
		return descriptors;

	}

	public Object getPropertyValue(Object id) {
		if (id.equals(P_JSTYPE)) {
			return jsType;
		} else if (id.equals(P_DATASOURCE_ID)) {
			return this.dataSourceId;
		} else if (id.equals(P_TARGET_ID)) {
			return this.targetId;
		}
		return null;
	}

	public boolean isPropertySet(Object id) {
		if (id.equals(P_JSTYPE) || id.equals(P_DATASOURCE_ID)
				|| id.equals(P_TARGET_ID))
			return true;
		else
			return false;
	}

	public void setPropertyValue(Object id, Object value) {
		if (id.equals(P_JSTYPE)) {
			setJsType((String) value);
		} else if (id.equals(P_DATASOURCE_ID)) {
			setDataSourceId((String) value);
		} else if (id.equals(P_TARGET_ID)) {
			setTargetId((String) value);
		}
	}

	/**
	 * @see jp.co.cybec.laxide.model.base.AbstractModel#getBodyComponentXml()
	 */
	@Override
	public String getBodyComponentXml() {
		return getJsNameForXml() + getDataSourceForXml() + getTargetForXml();
	}

	/**
	 * @see jp.co.cybec.laxide.model.base.AbstractModel#setAttribute(org.jdom.Element)
	 */
	@Override
	public void setAttribute(Element element) {
		super.setAttribute(element);
	}

	/**
	 * @return datasourceId
	 */
	public String getDataSourceId() {
		return dataSourceId;
	}

	/**
	 * @param datasourceId
	 *            datasourceId ݒB
	 */
	public void setDataSourceId(String datasourceId) {
		this.dataSourceId = datasourceId;
		firePropertyChange(P_DATASOURCE_ID, null, datasourceId);
	}

	private String getDataSourceForXml() {
		if (dataSourceId == null
				|| (dataSourceId != null && dataSourceId.equals(""))) {
			return "";
		}
		return " dataSourceId=\"" + this.dataSourceId + "\" ";
	}

	private String getTargetForXml() {
		if (targetId == null || (targetId != null && targetId.equals(""))) {
			return "";
		}
		return " targetId=\"" + this.targetId + "\" ";
	}

	/**
	 * @return targetId
	 */
	public String getTargetId() {
		return targetId;
	}

	/**
	 * @param targetId
	 *            targetId ݒB
	 */
	public void setTargetId(String targetId) {
		this.targetId = targetId;
		firePropertyChange(P_TARGET_ID, null, targetId);
	}
}
