<?php
/* 
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of Request_Engine
 *
 * @author Administrator
 */
class Request_Engine extends Engine{

    public $form_name = null;
    public $error = null;
    public $form = null;
    public $system = null;
    public $is_request_get = false;
    public $is_request_post = false;

    /**
     * コンストラクタ
     * 
     * @param type $name
     */
    public function  __construct($name) {
	parent::__construct();
	$this->is_request = true;
	$this->form_name = $name;
	foreach($_GET as $key => $val){
	    self::get($key);
	}
	foreach($_POST as $key => $val){
	    self::get($key);
	}
    }

    /**
     * リクエストをエスケープして取得
     * 
     * @param type $name
     * @return type 
     */
    public function get($name){
	if($_GET) $this->is_request_get = true;
	if($_POST) $this->is_request_post = true;

	if($this->is_request_get || $this->is_request_post){
	    $yaml = $this->yaml(BASE . "config/{$this->form_name}.yml");
	    if(!$yaml[$name]) return false;
	    foreach($yaml[$name] as $key => $val){
		if(is_file(VALIDATE_PLUGIN . "{$key}.php")){
		    require_once(VALIDATE_PLUGIN . "{$key}.php");
		    $validate = new $key($yaml, $name);
		    $error = $this->error;
		    $form = $this->form;
		    if($validate->error) {
			$this->error = is_array($error) ? $validate->error + $error : $validate->error ;
		    }
		    if($validate->form) {
			$this->form = is_array($form) ? $validate->form + $form : $validate->form ;
		    }
		}
	    }
	    if($this->error){
		return false;
	    }
	}
	if($_POST[$name]){
	    return preg_replace("/\/x00|\/00/", "", htmlspecialchars(trim($_POST[$name]), ENT_QUOTES));
	}
	if($_GET[$name]){
	    return preg_replace("/\/x00|\/00/", "", htmlspecialchars(trim($_GET[$name]), ENT_QUOTES));
	}
    }

    /**
     * リクエストをエスケープせずに取得
     * 
     * @param type $name
     * @return type 
     */
    public function getUnescape($name){
	if(!$_GET || !$_POST) return false;
	$yaml = $this->system->yaml(BASE . "config/{$this->form_name}.yml");
	$yaml['escape'] = false;
	if(!$yaml[$name]) return false;
	foreach($yaml[$name] as $key => $val){
	    if(is_file(VALIDATE_PLUGIN . "{$key}.php")){
		require_once(VALIDATE_PLUGIN . "{$key}.php");
		$validate = new $key($yaml, $name);
		$error = $this->error;
		$form = $this->form;
		if($validate->error) {
		    $this->error = is_array($error) ? $validate->error + $error : $validate->error ;
		}
		if($validate->form) {
		    $this->form = is_array($form) ? $validate->form + $form : $validate->form ;
		}
	    }
	}
	if($_POST[$key]){
	    return preg_replace("/\/x00|\/00/", "", trim($_POST[$name]));
	}
	if($_GET[$key]){
	    return preg_replace("/\/x00|\/00/", "", trim($_POST[$name]));
	}
    }
}
?>