/****************************************************************************/
/* The developnent of this program is partly supported by IPA.              */
/* (Infomation-Technology Promotion Agency, Japan).                         */
/****************************************************************************/

/****************************************************************************/
/*  cloop_optimizer.h                                                       */
/*  Copyright : Copyright (C) 2006 ALPHA SYSTEMS INC.                       */
/*  Authors   : TAN Hideyuki (tanh@alpha.co.jp)                             */
/*              ALPHA SYSTEMS INC. knoppix team (knoppix@alpha.co.jp)       */
/*                                                                          */
/*  This is free software; you can redistribute it and/or modify            */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 2 of the License, or       */
/*  (at your option) any later version.                                     */
/*                                                                          */
/*  This software is distributed in the hope that it will be useful,        */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License       */
/*  along with this software; if not, write to the Free Software            */
/*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,  */
/*  USA.                                                                    */
/****************************************************************************/

#ifndef _CLOOP_OPTIMIZER_H
#define _CLOOP_OPTIMIZER_H

extern int cloop_optimizer(const char *clp_org_file, const char *clp_opt_file,
			   const char *blklist_file1, const char *blklist_file2,
			   void (*progress)(void *), void *progress_args);

extern char* get_optimizer_message(int msgid);

extern float opt_progress;
extern int do_optimize;

extern int verbose;

#define CLOOP_OPT_OK              0
#define CLOOP_OPT_FOPENERR       -1
#define CLOOP_OPT_FWRITEERR      -2
#define CLOOP_OPT_FREADERR       -3
#define CLOOP_OPT_FSEEKERR       -4
#define CLOOP_OPT_MEMERR         -5
#define CLOOP_OPT_CLOOP_VERERR   -6
#define CLOOP_OPT_ABORT          -7

#define CLOOP_OPT_MSG_OK "OK."
#define CLOOP_OPT_MSG_ABORT "abon."

#define CLOOP_OPT_PREAMBLE "#!/bin/sh\n" "#V2.0 OPT Format\n" \
"insmod cloop.o file=$0 && mount -r -t iso9660 /dev/cloop $1\n" "exit $?\n"

#define CLOOP_OPT_MSG_SIZE 4096

static __inline __uint64_t
__bswap64(__uint64_t _x)
{

  return ((_x >> 56) | ((_x >> 40) & 0xff00) | ((_x >> 24) & 0xff0000) |
	  ((_x >> 8) & 0xff000000) | ((_x << 8) & ((__uint64_t)0xff << 32)) |
	  ((_x << 24) & ((__uint64_t)0xff << 40)) |
	  ((_x << 40) & ((__uint64_t)0xff << 48)) | ((_x << 56)));
}
#define be64toh(x)      __bswap64(x)
#define be64_to_cpu be64toh
#define htobe64(x)	__bswap64(x)
#define cpu_to_be64 htobe64

#endif /* _CLOOP_OPTIMIZER_H */

