/*
$Id: lcdttmakerdlg.cpp,v 1.2 2003/08/05 13:21:19 mac Exp $

LcdTTMaker : LCD TrueType Font쐬xLbg
Copyright (C) 2003 mac@research.co.jp

̃vO̓t[\tgEFAłBȂ͂At[\tgEF
AcɂĔsꂽ GNU ʌOp_(o[W2A
]ɂĂ͂ȍ~̃o[Ŵǂꂩ)̒߂̉ōĔЕz
܂͉ς邱Ƃł܂B

̃vO͗Lpł邱ƂĔЕz܂A*S̖ۏ* 
łBƉ\̕ۏ؂̖ړIւ̓ḰAOɎꂽ̂
ߑS݂܂BڂGNU ʌOp_񏑂B
 
Ȃ͂̃vOƋɁAGNU ʌOp_񏑂̕ꕔ
󂯎͂łB󂯎ĂȂ΁At[\tgEFAc
ŐĂ( the Free Software Foundation, Inc., 59
Temple Place, Suite 330, Boston, MA 02111-1307 USA)
*/

// LcdTTMakerDlg.cpp : Cve[V	t@C
//
#include <stdio.h>
#include <conio.h>
#include <direct.h>
#include <stdlib.h>

#include <mbstring.h>

#include "stdafx.h"
#include "LcdTTMaker.h"
#include "LcdTTMakerDlg.h"
#include "ttedit.h"
#include "ttedittype.h"

#ifdef _DEBUG
#define	new	DEBUG_NEW
#undef THIS_FILE
static char	THIS_FILE[]	= __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// AvP[Ṽo[WŎgĂ CAboutDlg	_CAO

class CAboutDlg	: public CDialog
{
public:
	CAboutDlg();
	
	// _CAO f[^
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA
	
	// ClassWizard ͉z֐̃I[o[Ch𐶐܂
	//{{AFX_VIRTUAL(CAboutDlg)
protected:
	virtual	void DoDataExchange(CDataExchange* pDX);	// DDX/DDV ̃T|[g
	//}}AFX_VIRTUAL
	
	// Cve[V
protected:
	//{{AFX_MSG(CAboutDlg)
	afx_msg	void OnOnLine();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
//{{AFX_MSG_MAP(CAboutDlg)
ON_BN_CLICKED(IDC_OnLine, OnOnLine)
//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CLcdTTMakerDlg _CAO

CLcdTTMakerDlg::CLcdTTMakerDlg(CWnd* pParent /*=NULL*/)
: CDialog(CLcdTTMakerDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CLcdTTMakerDlg)
	// :	̈ʒu ClassWizard ɂăȍǉ܂B
	//}}AFX_DATA_INIT
	// :	LoadIcon 	Win32  DestroyIcon ̃TuV[PXv܂B
	m_hIcon	= AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CLcdTTMakerDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CLcdTTMakerDlg)
	DDX_Control(pDX, IDC_EditTmp, m_EditTmp);
	DDX_Control(pDX, IDC_EditCodeMap, m_EditCodeMap);
	DDX_Control(pDX, IDC_EditBitMap, m_EditBitMap);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CLcdTTMakerDlg, CDialog)
//{{AFX_MSG_MAP(CLcdTTMakerDlg)
ON_WM_SYSCOMMAND()
ON_WM_PAINT()
ON_WM_QUERYDRAGICON()
ON_BN_CLICKED(IDC_DoIt,	OnDoIt)
ON_BN_CLICKED(IDC_About, OnAbout)
ON_BN_CLICKED(IDC_TemplateRef, OnTemplateRef)
ON_BN_CLICKED(IDC_CodeMapRef, OnCodeMapRef)
ON_BN_CLICKED(IDC_BitMapRef, OnBitMapRef)
ON_BN_CLICKED(IDC_Default, OnDefault)
	ON_BN_CLICKED(IDC_WABUN, OnWabun)
	ON_BN_CLICKED(IDC_OUBUN, OnOubun)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CLcdTTMakerDlg bZ[W	nh

BOOL CLcdTTMakerDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	
	// "o[W..." j[ڂVXe j[֒ǉ܂B
	
	// IDM_ABOUTBOX	̓R}h j[͈̔͂łȂ΂Ȃ܂B
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX	< 0xF000);
	
	CMenu* pSysMenu	= GetSystemMenu(FALSE);
	if (pSysMenu !=	NULL)
	{
		CString	strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING,	IDM_ABOUTBOX, strAboutMenu);
		}
	}
	
	// ̃_CAOp̃ACRݒ肵܂Bt[[N̓AvP[ṼC
	// EBhE_CAOłȂ͎Iɐݒ肵܂B
	SetIcon(m_hIcon, TRUE);			// 傫ACRݒ
	SetIcon(m_hIcon, FALSE);		// ACRݒ
	
	// TODO: ʂȏs͂̏ꏊɒǉĂB
	
	m_spec = wabun;
	CButton *kind = (CButton*) GetDlgItem(IDC_WABUN);
	kind->SetCheck(1);

	char progpath[_MAX_PATH];
	char drive[_MAX_DRIVE];
	char dir[_MAX_DIR];
	char fname[_MAX_FNAME];
	char ext[_MAX_EXT];
	
	_splitpath(progpath, drive,	dir, fname,	ext	);
	m_dir.Empty();
	
	if (GetModuleFileName(NULL,	progpath, _MAX_PATH) !=	0) {
		_splitpath(	progpath, drive, dir, fname, ext );
		m_dir =	drive;
		m_dir += dir;
	}
	OnDefault();
	
	return TRUE;  // TRUE ԂƃRg[ɐݒ肵tH[JX͎܂B
}

void CLcdTTMakerDlg::OnSysCommand(UINT nID,	LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// _CAO{bNXɍŏ{^ǉȂ΁AACR`悷
// R[hȉɋLqKv܂BMFC AvP[V	document/view
// fgĂ̂ŁȀ̓t[[Nɂ莩Iɏ܂B

void CLcdTTMakerDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // `p̃foCX ReLXg
		
		SendMessage(WM_ICONERASEBKGND, (WPARAM)	dc.GetSafeHdc(), 0);
		
		// NCAg̋`̈̒
		int	cxIcon = GetSystemMetrics(SM_CXICON);
		int	cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int	x =	(rect.Width() -	cxIcon + 1)	/ 2;
		int	y =	(rect.Height() - cyIcon	+ 1) / 2;
		
		// ACR`悵܂B
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// VXéA[U[ŏEBhEhbOĂԁA
// J[\\邽߂ɂĂяo܂B
HCURSOR	CLcdTTMakerDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

/////////////////////////////////////////////////////////////////////////////
static	ITTEditApp tteditApp;
static	ITTEditDoc tteditDoc;

void CLcdTTMakerDlg::OnDoIt() 
{	
	TRY
	{
		if (!tteditApp.CreateDispatch("TTEdit.Application"))
		{
			AfxMessageBox("TTEditNł܂");
			return;
		}
		LPDISPATCH pDispatch = tteditApp.NewFile(m_spec, proportional);
		
		tteditDoc.AttachDispatch(pDispatch);
		tteditDoc.SetCode(sjis,	0x0020,	horizontal);
		
		CString	templ;
		
		m_EditTmp.GetWindowText(templ);
		tteditDoc.ImportBMPFile(templ);
		
		m_TempFile = m_dir+"tmp.csv";
		tteditDoc.ExportCSVFile(m_TempFile,	nosaveWidth);
		m_width	= tteditDoc.GetWidth();
		
		tteditDoc.SelectAll();
		tteditDoc.Delete();
		
		if (!ReadBitMap()) {
			return;
		}
		
		if (!ReadVector()) {
			return;
		}
		
		if (!CodeMap())	{
			return;
		}
		AfxMessageBox("슮");
		tteditDoc.Save();
	}
	CATCH(COleDispatchException	, e)
	{
		CString	ss;
		ss.Format("G[:%d\n%s",
			e->m_wCode,	e->m_strDescription);
		AfxMessageBox(ss);
	}
	END_CATCH
		
}

void CLcdTTMakerDlg::OnAbout() 
{
	CAboutDlg dlgAbout;
	dlgAbout.DoModal();	
}

void CAboutDlg::OnOnLine() 
{
	ShellExecute(m_hWnd, "open",
		"http://www.research.jp/LcdTTMaker", NULL, NULL, SW_SHOW);
}

void CLcdTTMakerDlg::OnTemplateRef() 
{
	CommonFileDlg("bmp", &m_EditTmp);	
}

void CLcdTTMakerDlg::OnCodeMapRef()	
{
	CommonFileDlg("csv", &m_EditCodeMap);	
}

void CLcdTTMakerDlg::OnBitMapRef() 
{
	CommonFileDlg("ftb", &m_EditBitMap);
}

CString	CLcdTTMakerDlg::CommonFileDlg(const	char *ext, CEdit *edit)
{
	CString	ss,	extbuf;
	
	edit->GetWindowText(ss);
	
	extbuf = "*.";
	extbuf += ext;
	
	CFileDialog	comDlg(true, ext, ss, 
		OFN_HIDEREADONLY,
		extbuf+	"|"	+ "|" +extbuf +"All	(*.*)|*.*||");
	if (comDlg.DoModal() ==	IDOK) {
		ss = comDlg.GetPathName();
		edit->SetWindowText(ss);
	}
	return (ss);
}

void CLcdTTMakerDlg::OnDefault(void) 
{
	m_EditTmp.SetWindowText(m_dir +	"default.bmp");
	m_EditCodeMap.SetWindowText(m_dir +	"default.csv");
	m_EditBitMap.SetWindowText(m_dir + "default.ftb");
}

bool
CLcdTTMakerDlg::CodeMap(void)
{
	CString	fname;
	CStdioFile fin,	fout;
	unsigned char *field[6];
	int i;
	unsigned char *p;
		
	unsigned int lcdcode;
	unsigned int	c, j, k;
	
	m_EditCodeMap.GetWindowText(fname);
	
	if (!fin.Open(fname, CFile::modeRead)) {
		AfxMessageBox(fname	+ "J܂");
		return false;
	}
	
	for (i = 0; i < 5; i++) {
		field[i] = NULL;
	}
	
	CString	ss;
	fin.ReadString(ss);	// skip	head 1 line

	
	while (fin.ReadString(ss)) {
		int	qty;
		qty	= csvsplit(ss, field, 5);
		
		if (qty	< 2) {
			continue;
		}
		else {
			if ((sscanf((char *) field[0], "%x", &lcdcode) <= 0)	|| lcdcode < 0 || lcdcode >	255) {
				continue;
			}
			else if (!fout.Open(m_TempFile,
				CFile::modeWrite|CFile::modeCreate)) {
				AfxMessageBox(fname+"܂");
				return false;
			}
			
			fout.WriteString("\"\",\"X\",\"Y\"\n");
			
			for(j =	0; j < 5; j++) {
				c =	data[lcdcode][j];
				for	(k = 0;	k <	8; k++)	{
					if (c &	1) {
						fout.WriteString(font[j+k*5]);
					}												
					c >>= 1;
				}
			}
		}
		fout.Close();

		unsigned short int mb;

		for (i = 1; i < qty; i++) {
			p = field[i];
			c = *p;
			mb = (p[0] << 8) | (p[1] & 0xff);

			if((m_spec == wabun) && _ismbblead(c) && _ismbclegal(mb)) {
				mb = _mbcjmstojis(mb);
				tteditDoc.SetCode(jis, mb, horizontal);
			}
			else if (_ismbcprint(c)) {				
				tteditDoc.SetCode(jis, c, horizontal);
				mb = c;
			}
			else {
				continue;
			}
			tteditDoc.ImportCSVFile(m_TempFile);
			if (mb < 0x3020) {
				tteditDoc.SetWidth(m_width);
			}
		}
	}
	return true;
}

bool
CLcdTTMakerDlg::ReadBitMap()
{	
	CStdioFile fin;
	int	n;
	CString	ss,	sss, cr;
	int	kind;
	
	if (!fin.Open(m_TempFile,
		CFile::modeRead|CFile::typeText)) {
		AfxMessageBox("t@CJ܂");
		return false;
	}
	
	fin.ReadString(ss);	// skip	header
	
	n =	0;
	cr = "\n";
	char *q;
	
	while (fin.ReadString(ss)){
		if(ss.IsEmpty()) {
			continue;
		}
		kind = atoi(ss);
		if (kind ==	1) {
			if (n > 0)	{
				if ((q = (char *)malloc(sss.GetLength()+1)) == 0) {
					AfxMessageBox("[܂",0);
					exit (0);
				}
				strcpy(q, (LPCTSTR)	sss);
				font[n-1] =	q;
			}
			if (++n	> 255) {
				AfxMessageBox("ev[gt@C܂");
				fin.Close();
				return false;
			}
			else {
				sss	= ss + cr;
			}
		}
		else {			
			sss	+= ss + cr;
		}
	} 
	if ((q = (char *)malloc(sss.GetLength()+1)) == 0) {
		AfxMessageBox("[܂",0);
		exit (0);
				}
				strcpy(q, (LPCTSTR)	sss);
				font[n-1] =	q;
				
				fin.Close();
				return true;
}

bool
CLcdTTMakerDlg::ReadVector(void)
{
	int	i, d1, d2, d3, d4, d5;
	CStdioFile fin;
	CString	ss,	fname;
	
	m_EditBitMap.GetWindowText(fname);
	
	if (!fin.Open(fname, CFile::modeRead, NULL)) {
		AfxMessageBox(fname	+ "J܂");
		return false;
	}
	
	while (fin.ReadString(ss)) {
		sscanf(ss,"%d,%x,%x,%x,%x,%x",
			&i,&d1,&d2,&d3,&d4,&d5);
		if (i >=0 && i < 256) {
			
			data[i][0] = d1	& 0xff;
			data[i][1] = d2	& 0xff;
			data[i][2] = d3	& 0xff;
			data[i][3] = d4	& 0xff;
			data[i][4] = d5	& 0xff;
		}
	}
	fin.Close();
	
	return true;	
}

int	CLcdTTMakerDlg::csvsplit(CString ss, unsigned char *field[],	int	n)
{
	int	i, j;
	CString	sss, s;
	unsigned char *p;
	
	sss	= ss;
	j = 0;
	for	(i = 0;	i <	n; i++)	{
		if (sss.IsEmpty()) {
			s.Empty();
			j++;
		}
		else if (sss.Left(4) == "\"\"\"\"") {
			s = "\"";
			j += 4;
		}
		else if (sss[0] == '"') {
			s =	",";
			j += 3;
		}
		else if ((j = sss.Find(",")) > 0) {
			s =	sss.Left(j);
		}
		else {
			s = sss;
		}
		
		if ((p = field[i]) != NULL) {
			delete p;
		}
		p =	new	unsigned char[s.GetLength()+1];
		strcpy((char *)p, (LPCTSTR)	s);
		field[i] = p;
		if ((j > 0) && (sss.GetLength() < (j + 1))) {
			return i;
		}
		else{
			sss	= sss.Mid(j+1);
		}
	}
	
	return i;
}


void CLcdTTMakerDlg::OnWabun() 
{
	m_spec = wabun;	
}

void CLcdTTMakerDlg::OnOubun() 
{
	m_spec = oubun;	
}
