/*
 * Decompiled with CFR 0.152.
 */
package org.ldr4j.api;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.util.EntityUtils;
import org.ldr4j.LDRException;
import org.ldr4j.api.LDRHttpResponse;

abstract class AbstractLDRHttpClient {
    private HttpClient httpClient;

    protected AbstractLDRHttpClient() {
        BasicHttpParams params = new BasicHttpParams();
        HttpProtocolParams.setVersion((HttpParams)params, (ProtocolVersion)HttpVersion.HTTP_1_1);
        HttpProtocolParams.setContentCharset((HttpParams)params, (String)"UTF-8");
        HttpProtocolParams.setUserAgent((HttpParams)params, (String)"LDR4J/1.0");
        this.httpClient = new DefaultHttpClient((HttpParams)params);
    }

    protected AbstractLDRHttpClient(String proxyHost, int proxyPort) {
        this();
        HttpHost proxy = new HttpHost(proxyHost, proxyPort);
        this.httpClient.getParams().setParameter("http.route.default-proxy", (Object)proxy);
    }

    protected LDRHttpResponse doPost(String url) throws LDRException {
        return this.doPost(url, Collections.<String, String>emptyMap());
    }

    protected LDRHttpResponse doPost(String url, Map<String, String> requestParams) throws LDRException {
        HttpPost post = null;
        try {
            post = new HttpPost(url);
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            for (Map.Entry<String, String> entry : requestParams.entrySet()) {
                params.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
            }
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
            HttpResponse response = this.httpClient.execute((HttpUriRequest)post);
            LDRHttpResponse ldrResponse = new LDRHttpResponse();
            ldrResponse.setStatusCode(response.getStatusLine().getStatusCode());
            ldrResponse.setHeader(response.getAllHeaders());
            ldrResponse.setBody(EntityUtils.toString((HttpEntity)response.getEntity()));
            ldrResponse.setCookieHeader(response.getHeaders("Set-Cookie"));
            LDRHttpResponse lDRHttpResponse = ldrResponse;
            return lDRHttpResponse;
        }
        catch (UnsupportedEncodingException e) {
            throw new LDRException(e);
        }
        catch (ClientProtocolException e) {
            throw new LDRException(e);
        }
        catch (IOException e) {
            throw new LDRException(e);
        }
        finally {
            if (post != null) {
                post.abort();
            }
        }
    }

    protected LDRHttpResponse doGet(String url) throws LDRException {
        return this.doGet(url, Collections.<String, String>emptyMap());
    }

    protected LDRHttpResponse doGet(String url, Map<String, String> requestParams) throws LDRException {
        HttpGet get = null;
        try {
            StringBuilder builder = new StringBuilder(url);
            builder.append("?");
            for (Map.Entry<String, String> entry : requestParams.entrySet()) {
                builder.append(entry.getKey());
                builder.append("=");
                builder.append(entry.getValue());
                builder.append("&");
            }
            String tmpUrl = builder.toString();
            tmpUrl = tmpUrl.substring(0, tmpUrl.length() - 1);
            get = new HttpGet(tmpUrl);
            HttpResponse response = this.httpClient.execute((HttpUriRequest)get);
            LDRHttpResponse ldrResponse = new LDRHttpResponse();
            ldrResponse.setStatusCode(response.getStatusLine().getStatusCode());
            ldrResponse.setHeader(response.getAllHeaders());
            ldrResponse.setBody(EntityUtils.toString((HttpEntity)response.getEntity()));
            ldrResponse.setCookieHeader(response.getHeaders("Set-Cookie"));
            LDRHttpResponse lDRHttpResponse = ldrResponse;
            return lDRHttpResponse;
        }
        catch (UnsupportedEncodingException e) {
            throw new LDRException(e);
        }
        catch (ClientProtocolException e) {
            throw new LDRException(e);
        }
        catch (IOException e) {
            throw new LDRException(e);
        }
        finally {
            if (get != null) {
                get.abort();
            }
        }
    }

    public void shutdown() {
        this.httpClient.getConnectionManager().shutdown();
    }
}

