#! /bin/sh
PROGNAME=`basename $0`;

case "$1" in
help|Help|HELP)
    echo "Usage: ${PROGNAME} [-print]" >&2;
    exit 1; ;;
esac

HOSTNAME=`hostname`;
DD=`date +%Y%m%d`;
TT=`date +%T`;

## RELEASE
##
if [ -f /etc/miraclelinux-release ]; then
    RELEASE=`cat /etc/miraclelinux-release`;
    case ${RELEASE} in
    "MIRACLE LINUX V4.0 (Trinity)") REL="ML4.0"; ;;
    "MIRACLE LINUX V3.0 (koumei)")  REL="ML3.0"; ;;
    "MIRACLE LINUX V3.0 (mars)")  REL="ML3.0"; ;;
    *) REL="ML_UK";
    esac
elif [ -f /etc/redhat-release ]; then
    RELEASE=`cat /etc/redhat-release`;
    case ${RELEASE} in
    "Fedora Core release 2 (Tettnang)") REL="FC2"; ;;
    *) REL="FC_UK";
    esac
else 
    REL="UNKNOWN";
fi

## KERNEL_VERSION
##
KERNEL_VERSION=`uname -r`;

## ARCH
##
__arch=`file /bin/ls | awk 'BEGIN{FS=", ";}{ print $2; }'`
case ${__arch} in
"Intel 80386")  ARCH=x86; ;;
"AMD x86-64")   ARCH=x86_64; ;;
*)            ARCH=ARCH_UK; ;;
esac

### IP address/Gateway
##
IPV4ADDR=`/sbin/ifconfig eth0 | grep "inet addr:" | awk '{ print $2;}' | sed -e s/addr://`

### HDD Device
HDDDEV=`df /boot | sed -e '2 { p }' -e d | awk '{ print $1;}' | sed -e 's/[0-9]*$//'`

### WorkDIR
WORKDIR=/tmp/HWKENSYO/${HOSTNAME}/${REL}/${ARCH}/${KERNEL_VERSION}

if [ "x$1" = "x-print" ]; then
    echo HOSTNAME=${HOSTNAME}
    echo RELEASE=${RELEASE}
    echo REL=${REL}
    echo ARCH=${ARCH}
    echo KERNEL_VERSION=${KERNEL_VERSION}
    echo IPV4ADDR=${IPV4ADDR}
#    echo WORKDIR=${WORKDIR}
#    echo HDDDEV=${HDDDEV}
fi

