#!/bin/sh

cmddir=`dirname $0`
softwaredir="$cmddir/$1"
codeset=$2
if [ $# -eq 3 ]; then
  native_codeset=$3
else
  native_codeset=$codeset
fi

codeset_short=`echo $codeset | tr -d '-' | tr [:upper:] [:lower:]`

case "$codeset" in
iso-2022-jp*|cp5022*)
  if [ ! -d "$softwaredir/diff/$codeset" ]; then
    mkdir "$softwaredir/diff/$codeset"
  fi

  for cs in us-ascii jisx0201-latin jisx0201-kana jisx0201-kana-sosi \
            jisx0208-1978 jisx0208-1983
  do
    if [ ! -e $cmddir/../ucm/${codeset_short}-common/${cs}.ucm ]; then
      continue
    fi
    echo -n "checking $codeset/$cs ... "
    $cmddir/../tools/ucmcomp.sh \
        $cmddir/../ucm/${codeset_short}-common/${cs}.ucm \
        $softwaredir/ucm/$native_codeset/${cs}.ucm \
        > $softwaredir/diff/$native_codeset/${cs}.diff 2> /dev/null
    grep '^-' $softwaredir/diff/$codeset/${cs}.diff > /dev/null 2>&1
    if [ ! $? = 0 ]; then
        echo "OK"
    else
        echo "NG: See $softwaredir/diff/$native_codeset/${cs}.diff"
    fi
  done
  ;;
*)
  echo -n "checking $codeset ... "
  $cmddir/../tools/ucmcomp.sh \
      $cmddir/../ucm/${codeset_short}-common.ucm \
      $softwaredir/ucm/${native_codeset}.ucm \
      > $softwaredir/diff/${native_codeset}.diff 2> /dev/null
  grep '^-' $softwaredir/diff/${native_codeset}.diff > /dev/null 2>&1
  if [ ! $? = 0 ]; then
      echo "OK"
  else
      echo "NG: See $softwaredir/diff/${native_codeset}.diff"
  fi
  ;;
esac
