#!/bin/sh

cmddir=`dirname $0`
software=$1
softwaredir="$cmddir/$software"
codeset=$2
codeset_short=`echo $codeset | tr -d '-' | tr [:upper:] [:lower:]`

if [ -d "$softwaredir" ]; then
  if [ ! -d "$softwaredir/raw-table" ]; then
    mkdir "$softwaredir/raw-table"
  fi
  if [ ! -d "$softwaredir/ucm" ]; then
    mkdir "$softwaredir/ucm"
  fi
  if [ ! -d "$softwaredir/diff" ]; then
    mkdir "$softwaredir/diff"
  fi
fi

case "$codeset" in
iso-2022-jp*|cp5022*)
  if [ ! -d "$softwaredir/ucm/${codeset}" ]; then
    mkdir "$softwaredir/ucm/${codeset}"
  fi
  for cs in us-ascii jisx0201-latin jisx0201-kana jisx0201-kana-sosi \
            jisx0208-1978 jisx0208-1983 ;
  do
    if [ ! -e $cmddir/../ucm/${codeset_short}-common/${cs}.ucm ]; then
      continue
    fi
    case "$cs" in
      us-ascii)            esc='ESC(B'  ;;
      jisx0201-latin)      esc='ESC(J'  ;;
      jisx0201-kana)       esc='ESC(I'  ;;
      jisx0201-kana-sosi)  esc='SOSI'   ;;
      jisx0208-1978)       esc='ESC$@'  ;;
      jisx0208-1983)       esc='ESC$B'  ;;
    esac

    echo "generating ${codeset}/$cs.ucm"
    $softwaredir/src/ucs2mb_iso2022 $codeset $esc \
        1> $softwaredir/raw-table/ucs_to_${codeset_short}-${cs}.txt \
        2> $softwaredir/raw-table/ucs_to_${codeset_short}-${cs}.err
    $softwaredir/src/mb2ucs_iso2022 $codeset $esc \
        1> $softwaredir/raw-table/${codeset_short}-${cs}_to_ucs.txt \
        2> $softwaredir/raw-table/${codeset_short}-${cs}_to_ucs.err

    cat $softwaredir/raw-table/ucs_to_${codeset_short}-${cs}.txt \
        $softwaredir/raw-table/${codeset_short}-${cs}_to_ucs.txt \
    | $cmddir/../tools/map2ucm.pl > $softwaredir/ucm/$codeset/${cs}.ucm
  done
  ;;
*)
  echo "generating ${codeset}.ucm"
  $softwaredir/src/ucs2mb $codeset \
      1> $softwaredir/raw-table/ucs_to_${codeset_short}.txt \
      2> $softwaredir/raw-table/ucs_to_${codeset_short}.err
  $softwaredir/src/mb2ucs $codeset \
      1> $softwaredir/raw-table/${codeset_short}_to_ucs.txt \
      2> $softwaredir/raw-table/${codeset_short}_to_ucs.err

  cat $softwaredir/raw-table/ucs_to_${codeset_short}.txt \
      $softwaredir/raw-table/${codeset_short}_to_ucs.txt \
  | $cmddir/../tools/map2ucm.pl > $softwaredir/ucm/${codeset}.ucm
  ;;
esac
