<?php
    function unichr($val)
    {
        if ($val >= 0 && $val <= 0x7F) {
            $utf8 = pack('C',    $val);
        } elseif ($val >= 0x80 && $val <= 0x7FF) {
            $utf8 = pack('CC',   0xC0 | ($val >> 6),
                                 0x80 | $val & 0x3F);
        } elseif ($val >= 0x800 && $val <= 0xFFFF) {
            $utf8 = pack('CCC',  0xE0 | ($val >> 12),
                                 0x80 | (($val >> 6) & 0x3F),
                                 0x80 | $val & 0x3F);
        } elseif ($val >= 0x10000 && $val <= 0x10FFFF) {
            $utf8 = pack('CCCC', 0xF0 | ($val >> 18),
                                 0x80 | (($val >> 12) & 0x3F),
                                 0x80 | (($val >> 6) & 0x3F),
                                 0x80 | $val & 0x3F);
        }
        return $utf8;
    }

    function uniord($utf8)
    {
        for ($i = 0; $i < strlen($utf8); $i++) {
            if (ord($utf8[$i]) < 0x80) {
                return ord($utf8[$i]);
            } elseif ((ord($utf8[$i]) & 0xE0) == 0xC0) {
                if ($i + 1 < strlen($utf8)) {
                    $u1 = ord($utf8[$i++]);
                    $u2 = ord($utf8[$i]);
                    $u = ($u1 & 0x01F) << 6 | ($u2 & 0x3F);
                    if ($u >= 0x80 && $u <= 0x7FF) {
                        return $u;
                    }
                }
            } elseif ((ord($utf8[$i]) & 0xF0) == 0xE0) {
                if ($i + 2 < strlen($utf8)) {
                    $u1 = ord($utf8[$i++]);
                    $u2 = ord($utf8[$i++]);
                    $u3 = ord($utf8[$i]);
                    $u = ($u1 & 0x0F) << 12
                         | ($u2 & 0x3F) << 6
                         | ($u3 & 0x3F);
                    if ($u >= 0x800 && $u <= 0xFFFF) {
                        return $u;
                    }
                }
            } elseif ((ord($utf8[$i]) & 0xF8) == 0xF0) {
                if ($i + 3 < strlen($utf8)) {
                    $u1 = ord($utf8[$i++]);
                    $u2 = ord($utf8[$i++]);
                    $u3 = ord($utf8[$i++]);
                    $u4 = ord($utf8[$i]);
                    $u = ($u1 & 0x07) << 18
                         | ($u2 & 0x3F) << 12
                         | ($u3 & 0x3F) << 6
                         | ($u4 & 0x3F);
                    if ($u >= 0x10000 && $u <= 0x10FFFF) {
                        return $u;
                    }
                }
            }
        }
        return 0xFFFD;
    }
?>
