#!/bin/sh
set -u

wd=`pwd`
software=`basename $wd`

targets="cp932 cp51932 eucjp-ms";
if [ $# -ne 0 ]; then
    targets=$@;
fi

for codeset in $targets;
do
    case "$codeset" in
    cp932)
        pg_codeset=sjis
        ;;
    cp51932)
        pg_codeset=win51932
        ;;
    eucjp-ms)
        pg_codeset=euc_jp
        ;;
    esac

    ../make_maptbl.sh $software $pg_codeset
    ../compare.sh $software $codeset $pg_codeset
done
