#!/usr/bin/perl

use strict;

print <<END;
SET CLIENT_ENCODING TO 'EUC_JP';
CREATE TABLE charlist (codepoint varchar(16), character varchar(8));
COPY charlist (codepoint, "character") FROM stdin;
END

foreach my $c1 (0x00..0x7F) {
    printf("\\\\x%02X\t\\%o\n", $c1, $c1);
}

foreach my $c1 (0x8E, 0xA1..0xFE) {
  foreach my $c2 (0xA1..0xFE) {
    printf("\\\\x%02X\\\\x%02X\t%c%c\n", $c1, $c2, $c1, $c2);
  }
}

foreach my $c1 (0xA1..0xFE) {
  foreach my $c2 (0xA1..0xFE) {
    printf("\\\\x8F\\\\x%02X\\\\x%02X\t%c%c%c\n", $c1, $c2, 0x8F, $c1, $c2);
  }
}

print "\\.\n";
