#!/usr/bin/perl
# generate cp51932 mapping table
# Copyright (C) 2006  MIRACLE LINUX CORPORATION.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

use File::Basename;

$MAPDIR = dirname($0);

# ftp://ftp.unicode.org/Public/MAPPINGS/VENDORS/MICSFT/WINDOWS/CP932.TXT
$CP932TXT = "CP932.TXT";

($EUC, $UNI, $COM, $FB) = (0 .. 3);

sub sjis2euc {
	$sjis = shift;
	($s1, $s2) = ($sjis >> 8 & 0xFF, $sjis & 0xFF);
	if ($s1 == 0) {
		if ($s2 > 0x80) {
			return 0x8e00 + $s2;
		} else {
			return $s2;
		}
	}
	if ($s1 > 0xDF) {
		$s1 -= 0x40;
	}
	if ($s2 > 0x7E) {
		$s2--;
	}
	$c = ($s1 - 0x81) * 188 + $s2 - 0x40;
	$e1 = int($c / 94) + 0xa1;
	$e2 = $c % 94 + 0xa1;
	return $e1 * 256 + $e2;
}

if ($#ARGV > -1) {
	open(F, $ARGV[0]) or die;
} else {
	open(F, "$MAPDIR/$CP932TXT") or die;
}

while (<F>) {
	if ($_ =~ /^#/) { next; }
	($sjis, $uni, $com) = split(/\t+/, $_);
	if ($uni =~ /^ +/) { next; }

	$uni = hex(substr($uni, 2, 4));
	$sjis = hex(substr($sjis, 2));
	next if ($sjis >= 0xF040);

	chomp($com);
	push(@tbl, [&sjis2euc($sjis), $uni, $com, 0]);

	if ($sjis >= 0x00 && $sjis <= 0xFF
	    || $sjis >= 0x8140 && $sjis <= 0x84FC
	    || $sjis >= 0x889F && $sjis <= 0xEAFC) {
		$u2e{$uni} = &sjis2euc($sjis);
	} elsif (!defined($u2e{$uni})
	    && ($sjis >= 0x8740 && $sjis <= 0x879E
	        ||  $sjis >= 0xED40 && $sjis <= 0xEEFC)) {
		$u2e{$uni} = &sjis2euc($sjis);
	} else {
		$tbl[$#tbl][$FB] = 3;
	}
}
close(F);

@tbl = sort
{
	if ($a->[$UNI] == $b->[$UNI]) {
		if ($u2e{$a->[$UNI]} == $a->[$EUC]) {
			-1;
		} else {
			1;
		}
	} elsif ($a->[$UNI] > $b->[$UNI]) {
		1;
	} else {
		-1;
	}
} @tbl;

print <<'END';
<code_set_name> "cp51932"
<code_set_alias> "windows-51932"
<mb_cur_min> 1
<mb_cur_max> 2
<subchar> \x3F
CHARMAP
END

for ($i = 0; $i <= $#tbl; $i++) {
	$u   = $tbl[$i][$UNI];
	$c1  = ($tbl[$i][$EUC] >> 8) & 0xFF;
	$c2  = $tbl[$i][$EUC] & 0xFF;
	$fb  = $tbl[$i][$FB];
	$com = substr($tbl[$i][$COM], 1);

	if ($tbl[$i][$EUC] <= 0xFF) {
		printf("<U%04X> \\x%02X |%d # %s\n", $u, $c2, $fb, $com);
	} else {
		printf("<U%04X> \\x%02X\\x%02X |%d # %s\n", $u, $c1, $c2, $fb, $com);
	}
}
print "END CHARMAP\n";

