#!/usr/bin/perl
# generate eucJP-ms mapping table
# Copyright (C) 2006  MIRACLE LINUX CORPORATION.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

use File::Basename;

$MAPDIR = dirname($0);

$EUCJP0201ATXT = "eucJP-0201A.txt";
$EUCJP0208MTXT = "eucJP-0208M.txt";
$EUCJP0212MTXT = "eucJP-0212M.txt.970820";
$EUCJP13THTXT  = "eucJP-13th.txt";
$EUCJPIBMEXTTXT= "eucJP-ibmext.txt";
$EUCJPUDCTXT   = "eucJP-udc.txt";

($EUC, $UNI, $COM, $FB) = (0 .. 3);

sub read_mapfile {
	$filename = shift;
	$i = 0;

	open(F, $filename) or die;
	while (<F>) {
		if ($_ =~ /^#/) { next; }
		($euc, $uni, $com) = split(/\t+/, $_);
		if ($uni =~ /^ +/) { next; }

		$uni = hex(substr($uni, 2, 4));
		$euc = hex(substr($euc, 2));
		chomp($com);

		if ($euc == 0x8FA2B7) {
			$uni = 0xFF5E;
		}
		push(@tbl, [$euc, $uni, $com, 0]);

		if ($euc >= 0x00 && $euc <= 0x7F
		    || $euc >= 0x8EA1 && $euc <= 0x8EDF
		    || $euc >= 0xA1A1 && $euc <= 0xA8FE
		    || $euc >= 0xB0A1 && $euc <= 0xF4FE
		    || $euc >= 0x8FB0A1 && $euc <= 0x8FEDFE) {
			$u2e{$uni} = $euc;
		} elsif (!defined($u2e{$uni})
		        && ($euc >= 0xADA1 && $euc <= 0xADFE
		            || $euc >= 0x8FF3A1 && $euc <= 0x8FF4FE
		            || $euc >= 0x8FA1A1 && $euc <= 0x8FAFFE
		            || $euc >= 0xF5A1 && $euc <= 0xFEFE
		            || $euc >= 0x8FF5A1 && $euc <= 0x8FFEFE)) {
			$u2e{$uni} = $euc;
		} else {
			$tbl[$#tbl][$FB] = 3;
		}
		$i++;
	}
	close(F);
	return $i;
}

#foreach $c (0x00..0x1F, 0x7F, 0x80..0x9F) {
foreach $c (0x00..0x1F, 0x7F) {
	next if ($c == 0x8E || $c == 0x8F);
	push(@tbl, [$c, $c, "", 0]); 
}
	
foreach $mapfile ($EUCJP0201ATXT,
                  $EUCJP0208MTXT, $EUCJP13THTXT,
                  $EUCJP0212MTXT, $EUCJPIBMEXTTXT,
                  $EUCJPUDCTXT)
{
	if (defined($mapfile)) {
		&read_mapfile("$MAPDIR/$mapfile");
	}
}

@tbl = sort
{
	if ($a->[$UNI] == $b->[$UNI]) {
		if ($u2e{$a->[$UNI]} == $a->[$EUC]) {
			-1;
		} else {
			1;
		}
	} elsif ($a->[$UNI] > $b->[$UNI]) {
		1;
	} else {
		-1;
	}
} @tbl;

print <<'END';
<code_set_name> "eucJP-ms"
<code_set_alias> "euc-jp-ms"
<code_set_alias> "eucjpms"
<code_set_alias> "eucJP-win"
<mb_cur_min> 1
<mb_cur_max> 3 
<subchar> \x3F
CHARMAP
END

for ($i = 0; $i <= $#tbl; $i++) {
	$u   = $tbl[$i][$UNI];
	$c1  = ($tbl[$i][$EUC] >> 16) & 0xFF;
	$c2  = ($tbl[$i][$EUC] >> 8) & 0xFF;
	$c3  = $tbl[$i][$EUC] & 0xFF;
	$fb  = $tbl[$i][$FB];
	$com = substr($tbl[$i][$COM], 1);

	if ($tbl[$i][$EUC] <= 0xFF) {
		printf("<U%04X> \\x%02X         |%d\n", $u, $c3, $fb);
	} elsif ($tbl[$i][$EUC] <= 0xFFFF) {
		printf("<U%04X> \\x%02X\\x%02X     |%d\n", $u, $c2, $c3, $fb);
	} else {
		printf("<U%04X> \\x%02X\\x%02X\\x%02X |%d\n", $u, $c1, $c2, $c3, $fb);
	}
	$before = $u;
}
print "END CHARMAP\n";

