/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.lepidolite.dao;

import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import jp.sourceforge.lepidolite.dao.DaoException;
import jp.sourceforge.lepidolite.dao.DaoSettings;
import jp.sourceforge.lepidolite.dao.DaoTransaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DataSourceDaoTransaction
implements DaoTransaction {
    private Log log = LogFactory.getLog(this.getClass());
    private Connection conn;
    private String owner;

    DataSourceDaoTransaction() {
        try {
            InitialContext ic = new InitialContext();
            Context env = (Context)ic.lookup("java:comp/env");
            DataSource ds = (DataSource)env.lookup(DaoSettings.DATASOURCE_NAME);
            this.conn = ds.getConnection();
            this.conn.setAutoCommit(false);
        }
        catch (NamingException ne) {
            throw new DaoException("\u30c7\u30fc\u30bf\u30bd\u30fc\u30b9\u306e\u53d6\u5f97\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", ne);
        }
        catch (SQLException sqle) {
            throw new DaoException("\u63a5\u7d9a\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u3092\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093\u3002", sqle);
        }
    }

    public Connection getConnection() {
        return this.conn;
    }

    public void commit() {
        try {
            this.conn.commit();
        }
        catch (SQLException sqle) {
            throw new DaoException("\u30b3\u30df\u30c3\u30c8\u306f\u5931\u6557\u3057\u307e\u3057\u305f\u3002", sqle);
        }
    }

    public void rollback() {
        try {
            this.conn.rollback();
        }
        catch (SQLException sqle) {
            throw new DaoException("\u30ed\u30fc\u30eb\u30d0\u30c3\u30af\u306f\u5931\u6557\u3057\u307e\u3057\u305f\u3002", sqle);
        }
    }

    public void close() {
        try {
            try {
                this.conn.close();
            }
            catch (SQLException sqle) {
                this.log.warn((Object)"\u30c8\u30e9\u30f3\u30b6\u30af\u30b7\u30e7\u30f3\u306e\u30af\u30ed\u30fc\u30ba\u306f\u5931\u6557\u3057\u307e\u3057\u305f\u3002", (Throwable)sqle);
                this.conn = null;
            }
        }
        finally {
            this.conn = null;
        }
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getOwner() {
        return this.owner;
    }
}

