package jp.sourceforge.lepidolite.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.LazyDynaBean;

/**
 * DAO̒ۃNXB
 *
 */
public abstract class BaseDao {
	
	/**
	 * gUNVIuWFNgB
	 */
	protected DaoTransaction trans;
	
	
	/**
	 * RXgN^B
	 * @param trans gUNVIuWFNgB
	 */
	protected BaseDao(DaoTransaction trans) {
		this.trans = trans;
	}
	
	
	/**
	 * SQLƃp[^Ƀf[^x[XAʂԂB
	 * 
	 * 擪̃R[h񖼂L[ɂĒlZbgB
	 * 
	 * @param sql SQLB
	 * @param args SQL̃v[Xz_ɐݒ肷p[^B
	 * @return ʁB݂Ȃꍇ<code>null</code>B
	 */
	protected DynaBean getById(String sql, Object[] args) {
		DynaBean result = null;
		try {
			Connection conn = trans.getConnection();
			PreparedStatement stmt = conn.prepareStatement(sql);
			
			if (args != null) {
				for (int i=0; i<args.length; i++) {
					stmt.setObject(i+1, args[i]);
				}
			}
			
			ResultSet rs = stmt.executeQuery();
			ResultSetMetaData rsmd = rs.getMetaData();
			int columns = rsmd.getColumnCount();
			
			// J̎w肪ꍇSQL̎sʂ擾
			String[] names = new String[columns];
			for (int i=0; i<columns; i++) {
				names[i] = rsmd.getColumnLabel(i+1);
			}
			
			if (rs.next()) {
				result = new LazyDynaBean();
				for (int i=0; i<columns; i++) {
					Object o = rs.getObject(i+1);
					if (o != null) {
						result.set(names[i], rs.getObject(i+1));
					}
				}
			}
		} catch (SQLException sqle) {
			throw new DaoException("f[^̎擾Ɏs܂B", sqle);
		}
		
		return result;
	}
	
	
	/**
	 * SQLƃp[^Ƀf[^x[XAʂXgŕԂB
	 * 
	 * 1R[hƂ<code>DynaBean</code>ɗ񖼂L[ɂĒlZbgB
	 * 
	 * @param sql SQLB
	 * @param args SQL̃v[Xz_ɐݒ肷p[^B
	 * @return ʂ̃XgB
	 */
	protected List<DynaBean> findByCriteria(String sql, Object[] args) {
		ArrayList<DynaBean> result = new ArrayList<DynaBean>();
		try {
			Connection conn = trans.getConnection();
			PreparedStatement stmt = conn.prepareStatement(sql);
			
			if (args != null) {
				for (int i=0; i<args.length; i++) {
					stmt.setObject(i+1, args[i]);
				}
			}
			
			ResultSet rs = stmt.executeQuery();
			ResultSetMetaData rsmd = rs.getMetaData();
			int columns = rsmd.getColumnCount();
			
			// JSQL̎sʂ擾
			String[] names = new String[columns];
			for (int i=0; i<columns; i++) {
				names[i] = rsmd.getColumnLabel(i+1);
			}
			
			while (rs.next()) {
				LazyDynaBean bean = new LazyDynaBean();
				for (int i=0; i<columns; i++) {
					Object o = rs.getObject(i+1);
					if (o != null) {
						bean.set(names[i], o);
					}
				}
				result.add(bean);
			}
		} catch (SQLException sqle) {
			throw new DaoException("ꗗ̎擾Ɏs܂B", sqle);
		}
		
		return result;
	}
	
}
