/**
 * SQL genereted by Jiemamy
 * Create: 2008/07/06 22:48:11
 */

-- >>>> begin-script of DB
DROP SEQUENCE IF EXISTS roles_id_seq;
CREATE SEQUENCE roles_id_seq START 500;

-- <<<< end
-- define: users
CREATE TABLE users (
  user_id VARCHAR(20) NOT NULL PRIMARY KEY,
  user_name VARCHAR(32) NOT NULL,
  passwd VARCHAR(40) NOT NULL,
  email VARCHAR(128),
  last_changed TIMESTAMP,
  user_state SMALLINT NOT NULL,
  created_by VARCHAR(20) NOT NULL,
  created_at TIMESTAMP NOT NULL,
  updated_by VARCHAR(20) NOT NULL,
  updated_at TIMESTAMP NOT NULL
);

INSERT INTO users (user_id, user_name, email, user_state, passwd, last_changed, created_by, updated_by, created_at, updated_at)
  VALUES ('linus', 'Linus Santana', 'linus@example.com', 2, 'cbc1253eaf430d3aa7230ace93399297b7780f96', NULL, 'linus', 'linus', '2007-01-01 00:00:00', '2007-01-01 00:00:00');


-- define: groups
CREATE TABLE groups (
  party_id VARCHAR(20) NOT NULL PRIMARY KEY,
  party_name VARCHAR(32) NOT NULL,
  party_type SMALLINT NOT NULL,
  lft INTEGER NOT NULL UNIQUE,
  rgt INTEGER NOT NULL UNIQUE,
  created_by VARCHAR(20) NOT NULL,
  created_at TIMESTAMP NOT NULL,
  updated_by VARCHAR(20) NOT NULL,
  updated_at TIMESTAMP NOT NULL
);
CREATE INDEX sidx_groups_lft ON groups (lft);

INSERT INTO groups (party_id, party_name, party_type, lft, rgt, created_by, created_at, updated_by, updated_at)
  VALUES ('users', 'ʃ[U', 1, 1, 6, 'linus', '2007-01-01 00:00:00', 'linus', '2007-01-01 00:00:00');
INSERT INTO groups (party_id, party_name, party_type, lft, rgt, created_by, created_at, updated_by, updated_at)
  VALUES ('administrators', 'VXeǗ', 1, 2, 5, 'linus', '2007-01-01 00:00:00', 'linus', '2007-01-01 00:00:00');
INSERT INTO groups (party_id, party_name, party_type, lft, rgt, created_by, updated_by, created_at, updated_at)
  VALUES ('linus', 'Linus Santana', 0, 3, 4, 'linus', 'linus', '2007-01-01 00:00:00', '2007-01-01 00:00:00');


-- define: roles
CREATE TABLE roles (
  role_id INTEGER NOT NULL PRIMARY KEY,
  role_name VARCHAR(32) NOT NULL,
  party_id VARCHAR(20) NOT NULL,
  created_by VARCHAR(20) NOT NULL,
  created_at TIMESTAMP NOT NULL,
  updated_by VARCHAR(20) NOT NULL,
  updated_at TIMESTAMP NOT NULL,
  CONSTRAINT fkey_roles_groups FOREIGN KEY (party_id)
    REFERENCES groups (party_id)
);

INSERT INTO roles (role_id, role_name, party_id, created_by, created_at, updated_at, updated_by)
  VALUES (1, 'user', 'users', 'linus', '2007-01-01 00:00:00', '2007-01-01 00:00:00', 'linus');
INSERT INTO roles (created_at, updated_at, created_by, updated_by, role_id, role_name, party_id)
  VALUES ('2007-01-01 00:00:00', '2007-01-01 00:00:00', 'linus', 'linus', 2, 'administrator', 'administrators');


-- define: accounts
CREATE VIEW accounts AS SELECT g.party_id as user_id, r.role_name
 FROM groups g
 INNER JOIN groups p ON p.lft<g.lft AND g.rgt<p.rgt
 INNER JOIN roles r ON r.party_id=p.party_id
 WHERE g.party_type=0
;

