/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.lepidolite.dao;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DaoSettings {
    private static Logger logger = LoggerFactory.getLogger(DaoSettings.class);
    private static final String PROPERTY_FILENAME = "/lepidolite.properties";
    public static final String DAO_TRANSACTION_FACTORY = "dao.transaction.factory";
    public static final String DATASOURCE_NAME = "dao.datasource";
    public static final String JDBC_DRIVER = "dao.jdbc.driver";
    public static final String JDBC_URL = "dao.jdbc.url";
    public static final String JDBC_USERNAME = "dao.jdbc.username";
    public static final String JDBC_PASSWORD = "dao.jdbc.password";
    public static final Properties prop = new Properties();

    static {
        DaoSettings.load();
    }

    private DaoSettings() {
    }

    public static void load() {
        prop.clear();
        InputStream in = DaoSettings.class.getResourceAsStream(PROPERTY_FILENAME);
        if (in != null) {
            try {
                prop.load(in);
            }
            catch (IOException ioe) {
                logger.warn("\u30d7\u30ed\u30d1\u30c6\u30a3\u30d5\u30a1\u30a4\u30eb\u3092\u8aad\u307f\u8fbc\u3081\u307e\u305b\u3093", (Throwable)ioe);
            }
        }
    }

    private static String getProperty(Properties prop, String key) {
        return System.getProperty(key, prop.getProperty(key));
    }

    public static String getDaoTransactionFactory() {
        return DaoSettings.getProperty(prop, DAO_TRANSACTION_FACTORY);
    }

    public static String getDatasourceName() {
        return DaoSettings.getProperty(prop, DATASOURCE_NAME);
    }

    public static String getJdbcDriver() {
        return DaoSettings.getProperty(prop, JDBC_DRIVER);
    }

    public static String getJdbcUrl() {
        return DaoSettings.getProperty(prop, JDBC_URL);
    }

    public static String getJdbcUsername() {
        return DaoSettings.getProperty(prop, JDBC_USERNAME);
    }

    public static String getJdbcPassword() {
        return DaoSettings.getProperty(prop, JDBC_PASSWORD);
    }
}

