class Admin::UsersController < ApplicationController
  model :user
  paginate :users, :order_by => 'login', :per_page => 20
  
  layout "admin"
  before_filter :login_required
  
  def index
    @user = User.new
  end
  
  def create
    @user = User.new(params[:user])
    if @user.save
      flash[:notice] = "User was successfully created."
      @user = User.new
    end
  end
  
  def list
  end
  
  def edit
    @user = User.find(params[:id])
  end
end
