class EzViewController < ApplicationController
  before_filter :set_charset_sjis
  after_filter :sjis_conv
  #caches_action :index  # If you use caches, after_filter is not applied

  def index
    tiddlers = Tiddler.find(:all, :order => "length(title) desc, title")

    if @params['title']
      @tiddler =
        Tiddler.find(:first, :conditions => [ "title = ?", @params['title'] ])
    else
      @tiddler =
        Tiddler.find(:first, :conditions => [ "title = ?" "StartHere" ])
    end
    unless @tiddler
      @tiddler = Tiddler.new
      if @params['title']
        @tiddler.title = @params['title']
      else
        @tiddler.title = "StartHere"
      end
      @tiddler.content = "This tiddler doesn't yet exist."
    end
    @tiddler.render!(EzViewLinkManager.instance, tiddlers)

    @menu = Tiddler.find(:first, :conditions => "title = 'MainMenu'")
    unless @menu
      @menu = Tiddler.new
      @menu.title = "MainMenu"
    end
    @menu.render!(EzViewLinkManager.instance, tiddlers)
  end
end
