require 'thread'

# WikiStorage is used only by WEBrick.
# A mutex is not required because WEBrick let only one request through at the time
class WikiStorage
  #@@mutex = Mutex.new

  attr_reader :tiddlers, :color_tiddlers, :aliases, :all_tags
  
  def self.instance
    @system ||= self.new
    @system
  end
  
  def initialize
  end
  
  def get_all
    result = nil
    #@@mutex.synchronize do
      result = [@tiddlers, @color_tiddlers, @aliases, @all_tags]
    #end
    result
  end
  
  def set_all(tiddlers, color_tiddlers, aliases, all_tags)
    #@@mutex.synchronize do
      @tiddlers = tiddlers
      @color_tiddlers = color_tiddlers
      @aliases = aliases
      @all_tags = all_tags
    #end
  end
  
  def tiddlers=(tiddlers)
    #@@mutex.synchronize do
      @tiddlers = tiddlers
    #end
  end
  
  def color_tiddlers=(color_tiddlers)
    #@@mutex.synchronize do
      @color_tiddlers = color_tiddlers
    #end
  end
  
  def aliases=(aliases)
    #@@mutex.synchronize do
      @aliases = aliases
    #end
  end
  
  def all_tags=(all_tags)
    #@@mutex.synchronize do
      @all_tags = all_tags
    #end
  end
end
