#!/bin/sh

if [ "$1" = "" ]; then
    echo "Usage: $0 <version>"
    exit 1
fi

ver=$1
tag="VER_`echo ${ver} | sed 's|\.|_|g'`"

cvs ex -r ${tag} -d lesserwiki-${ver} lesserwiki
for i in `/bin/ls lib | grep -v 'CVS'`; do
    cp -r lib/$i lesserwiki-${ver}/lib
done
for i in `/bin/ls vendor | grep -v 'CVS'`; do
    cp -r vendor/$i lesserwiki-${ver}/vendor
done
cd lesserwiki-${ver}
find . -name ".cvsignore" | xargs rm -f
mv config.in config
mkdir cache
chmod 777 cache
chmod 777 db
chmod 777 log
touch log/apache.log
touch log/development.log
touch log/production.log
touch log/server.log
touch log/test.log
chmod 666 log/*.log
cd ..

zip -r lesserwiki-${ver}.zip lesserwiki-${ver}
