function clearUserForm() {
  $("user_form").reset();
}

function openUserForm() {
  //new Effect.BlindDown("user_div", { duration: 0.5 });
  new Effect.Appear("user_div", { duration: 0.5 });
}

function closeUserForm() {
  clearUserForm();
  //new Effect.BlindUp("user_div", { duration: 0.5 });
  new Effect.Fade("user_div", { duration: 0.5 });
  $("error_message").innerHTML = "";
  if ($("flash"))
    Element.hide("flash");
}

function onClickCreateUser() {
  if ($("user_div").style.display == "none")
    openUserForm();
  else
    closeUserForm();
}

function onClickCancelUser() {
  if ($("user_div").style.display != "none")
    closeUserForm();
}

function onBeforeUserCreate() {
  $("user_login").disabled = true;
  $("user_name").disabled = true;
  $("user_password").disabled = true;
  $("user_password_confirmation").disabled = true;
  $("user_email").disabled = true;
  $("user_administrator").disabled = true;
  $("submit").disabled = true;
  $("cancel").disabled = true;
  showSpinner();
}

function onCompleteUserCreate(url) {
  $("user_login").disabled = false;
  $("user_name").disabled = false;
  $("user_password").disabled = false;
  $("user_password_confirmation").disabled = false;
  $("user_email").disabled = false;
  $("user_administrator").disabled = false;
  $("submit").disabled = false;
  $("cancel").disabled = false;
  hideSpinner();
  clearUserForm();
  
  // Reload user list
  new Ajax.Updater("user_list", url,
    {
      asynchronous: true,
      onComplete: function() { new Effect.Highlight("user_list"); }
    });
}

function showSpinner() {
  Element.show("spinner");
}

function hideSpinner() {
  Element.hide("spinner");
}
