$:.unshift(File.dirname(__FILE__) + '/..')
require 'message_resources'
require 'test/unit'

class TestMessageResources < Test::Unit::TestCase
  def setup
    I18n::MessageResources.basename = File.dirname(__FILE__) + '/messages' 
  end
  
  def test_message
    mr = I18n::MessageResources.instance
    assert_equal("xyz", mr.message("m"))
  end
  
  def test_message_default
    mr = I18n::MessageResources.instance
    # no value is found so key itself is returned
    assert_equal("x", mr.message("x"))
  end
  
  def test_message_return_key_when_not_found_false
    mr = I18n::MessageResources.instance
    assert_nil(mr.message("zzz", nil, nil,false))
  end
  
  def test_message_with_args
    mr = I18n::MessageResources.instance
    assert_equal("not in range 1 to 10", mr.message("mwa", nil, ["1", "10"]))
  end
  
  def test_message_with_args_multiple
    mr = I18n::MessageResources.instance
    assert_equal("not in range 1 to 10. Lowest is 1", mr.message("mwam", nil, ["1", "10"]))
  end
  
  def test_message_with_locale
    mr = I18n::MessageResources.instance
    assert_equal("fxyz", mr.message("m", "fr-fr"))
  end
  
  def test_message_default_with_locale
    mr = I18n::MessageResources.instance
    # no value is found so key itself is returned
    assert_equal("x", mr.message("x", "fr-fr"))
  end
  
  def test_message_with_args_with_locale
    mr = I18n::MessageResources.instance
    assert_equal("é in range 1 to 10", mr.message("mwa", "fr-fr", ["1", "10"]))
  end
  
  def test_message_with_args_multiple_with_locale
    mr = I18n::MessageResources.instance
    assert_equal("ê in range 1 to 10. Lowest is 1", mr.message("mwam", "fr-fr", ["1", "10"]))
  end 
  
  def test_message_with_locale_fallback_to_default
    mr = I18n::MessageResources.instance
    #locale file for 'de-de' is not there
    assert_equal("xyz", mr.message("m", "de-de"))
  end

end