module WikiHelper
  # Output a tiddler input form
  def tiddler_form(tiddler)
    if @tiddler.id and @tiddler.id > 0
      form_remote_tag :url => { :controller => "wiki", :action => "update", :id => tiddler.id },
                      :html => { :id => tiddler.form_id }
    else
      form_remote_tag :url => { :controller => "wiki", :action => "update" },
                      :html => { :id => tiddler.form_id }
    end
  end
  
  def end_tiddler_form
    end_form_tag
  end
  
  def login_form
    form_remote_tag :url => { :controller => "wiki", :action => "login" },
                    :complete => "closeAllTiddlers()",
                    :html => { :id => "login_form" }
  end
  
  def end_login_form
    end_form_tag
  end
  
  def logout_link(str)
    link_to_remote str, :url => { :controller => "wiki", :action => "logout" },
                        :complete => "closeAllTiddlers()"
  end
  
  def command_panel_handler
    %Q[
      <script type="text/javascript" charset="utf-8">
        // <![CDATA[
        command_panel_handler = new CommandPanelHandler('#{url_for :controller => "wiki", :action => "view_search"}');
        // ]]>
      </script>
    ]
  end
  
  def tiddler_event_listener(tiddler)
    if !tiddler.id or tiddler.id > 0
      %Q[
        <script type="text/javascript" charset="utf-8">
          // <![CDATA[
          #{tiddler.listener_id} = new TiddlerEventListener('#{permalink_url :title => tiddler.title}', '#{url_for :action => "delete", :id => tiddler.id}', "#{html_escape(_("delete_confirm", tiddler.title))}", '#{tiddler.html_elements.to_json}'.parseJSON());
          // ]]>
        </script>
      ]
    else
      %Q[
        <script type="text/javascript" charset="utf-8">
          // <![CDATA[
          #{tiddler.listener_id} = new NewTiddlerEventListener('#{tiddler.html_elements.to_json}'.parseJSON());
          // ]]>
        </script>
      ]
    end
  end
  
  def tag_toolbar_handler(tag)
    %Q[
      <script type="text/javascript" charset="utf-8">
        // <![CDATA[
        #{tag.handler_id} = new TagToolbar('#{tag_permalink_url :name => tag.name}', '#{tag.html_elements.to_json}'.parseJSON());
        // ]]>
      </script>
    ]
  end
  
  def search_toolbar_handler(search)
    %Q[
      <script type="text/javascript" charset="utf-8">
        // <![CDATA[
        #{search.handler_id} = new TagToolbar('#{search_permalink_url :search => search.search}', '#{search.html_elements.to_json}'.parseJSON());
        // ]]>
      </script>
    ]
  end
  
  def sidebar_tabs_handler
    %Q[
      <script type="text/javascript" charset="utf-8">
        // <![CDATA[
        new SidebarTabsHandler();
        // ]]>
      </script>
    ]
  end
  
  def color_tabs_handler(colors)
    %Q[
      <script type="text/javascript" charset="utf-8">
        // <![CDATA[
        new ColorTabsHandler([ #{colors.map {|c| '"' + c + '"' }.join(",") } ], '/color_page/');
        // ]]>
      </script>
    ]
  end
  
  def sidebar_tab_page(paginate, action)
    str = %[<div class="sidebar_page">]
    unless paginate.current.first?
      str << link_to_remote("&laquo; " + _("previous_page"),
               { :url => { :action => action,
                           :page => paginate.current.previous.number } },
               { :href => "javascript:;", :class => "page_left" })
      end
    unless paginate.current.last?
      str << link_to_remote(_("next_page") + " &raquo;",
               { :url => { :action => action,
                           :page => paginate.current.next.number } },
               { :href => "javascript:;", :class => "page_right" })
    end
    str << %[</div><div class="page_end"></div>]
  end
  
  def tiddler_title_class(tiddler)
    "title color_#{tiddler.color_name}"
  end
  
  def tiddler_title(tiddler)
    tiddler.title.empty? ? "NewTiddler" : tiddler.title
  end
  
  def tiddler_date(tiddler)
    return "not created yet" unless tiddler.updated_at
    
    date = local_date(tiddler.updated_at)
    
    if @tiddler.created_at
      date << " ("
      date << _('created_at') + " "
      date << local_date(@tiddler.created_at)
      date << ")"
    end
    
    date
  end
  
  def textarea_rows(tiddler)
    rows = 10
    if tiddler
      rows = tiddler.content.split(/\n/).length + 1
      if rows < 10
        rows = 10
      elsif rows > 30
        rows = 30
      end
    end
    rows
  end
  
  def colorbox_class(tiddler)
    if Tiddler.colors.include?(tiddler.color)
      "colorbox colorbg_#{tiddler.color}"
    else
      "colorbox colorbg_none"
    end
  end
  
  def color_options_for_select(selected = nil)
    selected ||= "none"
    color_options = ""

    colors = Tiddler.colors_with_none
    convert_colors = lambda { |list| list.map { |l| [ _("color_#{l}"), l ] } }

    color_options += options_for_select(convert_colors[colors], selected)
    color_options
  end
end

# Implement JavaScriptHelper.remote_function_with_loading().
module ActionView
  module Helpers
    module JavaScriptHelper
      # - If options[:element] is set and the specified element has been 
      #   displayed, Ajax request is not issued and execute options[:complete].
      def remote_function_with_loading(options)
        javascript_options = options_for_ajax(options)
        
        update = ''
        if options[:update] and options[:update].is_a? Hash
          update = []
          update << "success:'#{options[:update][:success]}'" if options[:update][:success]
          update << "failure:'#{options[:update][:failure]}'" if options[:update][:failure]
          update = '{' + update.join(',') + '}'
        elsif options[:update]
          update << "'#{options[:update]}'"
        end
        
        function = "new Ajax.LoadingUpdater("
        function << "'#{options[:template]}', '#{options[:values]}', "
        function << "#{update}, "
        function << "'#{options[:element]}', "
        
        function << "function(request){#{options[:loading_effect]};}, "
        
        function << "'#{url_for(options[:url])}'"
        function << ", #{javascript_options})"
        
        function = "#{options[:before]}; #{function}" if options[:before]
        function = "#{function}; #{options[:after]}"  if options[:after]
        function = "if (#{options[:condition]}) { #{function}; }" if options[:condition]
        function = "if (confirm('#{escape_javascript(options[:confirm])}')) { #{function}; }" if options[:confirm]
        
        if options[:complete]
          function = "if (!$('#{options[:element]}')) { #{function}; } else { #{options[:complete]}; }"
        else
          function = "if (!$('#{options[:element]}')) { #{function}; }"
        end
        
        function
      end
      
      def link_to_remote_with_loading(name, options = {}, html_options = {})  
        link_to_function(name, remote_function_with_loading(options), html_options)
      end
    end
  end
end

# Implement JavaScriptGenerator.insert_html_if_nonexist
# 
# If element_id has been displayed, HTML is not inserted.
module ActionView
  module Helpers
    module JavaScriptHelper
      class JavaScriptGenerator
        def insert_html_if_nonexist(element_id, position, id, *options_for_render)
          record "if (!$('#{element_id}')) {"
          insert_html(position, id, *options_for_render)
          record "}"
        end
      end
    end
  end
end
