require_dependency 'content_diff'

class ApplicationController < ActionController::Base
  include ERB::Util  # html_escape
  
  model :setting
  
  # echo -n "lessserwiki" | sha1sum
  @@salt = "5458b6ab4cde235a4598d4b53a04f83c044f8932"
  cattr_accessor :salt
  
  Localization.lang = config_values[:locale]
  
  #ENV['TZ'] = config_values[:time_zone]
  
  before_filter :set_charset
  before_filter :reload_settings
  
  cattr_reader :permission_levels, :permissions
  
  @@permission_levels = {
    :login_required_none => 1,
    :login_required_edit => 2,
    :login_required_all => 3
  }
  
  @@permissions = @@permission_levels.invert
  
  protected
  
  def set_charset
    @headers["Content-Type"] = "text/html; charset=UTF-8"
  end
  
  def reload_settings
    unless @request.instance_variable_get(:@config_reloaded)
      @request.instance_variable_set(:@config_reloaded, true)
      config_values.reload
    end
  end
  
  def authenticate?(login, pass)
    if config_values[:owner_login] == login and
      config_values[:owner_password] == sha1(pass)
      true
    else
      false
    end
  end
  
  def sha1(str)
    Digest::SHA1.hexdigest("#{salt}--#{str}--")
  end
  
  def diff_between_contents(last_content, current_content, diff_style = :line, digest_on = false)
    docdiff = ContentDiff.new
    
    last_doc = Document.new(html_escape(last_content), 'UTF-8', 'LF')
    current_doc = Document.new(html_escape(current_content), 'UTF-8', 'LF')
    
    docdiff_config = {
      :resolution    => diff_style == :line ? "line" : "word",
      :encoding      => "auto",
      :eol           => "auto",
      :format        => "user",
      :cache         => true,
      :digest        => digest_on,
      :verbose       => false,
      
      #:tag_common_start  => '<span class="docdiff_common">',
      #:tag_common_end    => '</span>',
      :tag_del_start     => '<span class="docdiff_del"><del>',
      :tag_del_end       => '</del></span>',
      :tag_add_start     => '<span class="docdiff_add"><ins>',
      :tag_add_end       => '</ins></span>',
      :tag_change_before_start => '<span class="docdiff_before_change"><del>',
      :tag_change_before_end => '</del></span>',
      :tag_change_after_start => '<span class="docdiff_after_change"><ins>',
      :tag_change_after_end => '</ins></span>',
      :tag_position_start => '<!-- ',
      :tag_position_end => ' -->'
    }
    docdiff.config.update(docdiff_config)
    docdiff.run(last_doc, current_doc, docdiff.config[:resolution],
                docdiff.config[:format], docdiff.config[:digest])    
  end
end
