require 'find'

class String
  def enclose_with_brackets
    self =~ /.\s./ ? "[[#{self}]]" : self
  end
  
  def enclose_with_quotes
    self =~ /.\s./ ? %{"#{self}"} : self
  end
  
  def split_by_space_and_brackets
    items = []
    remains = self.gsub(/\[\[(.*)\]\]/) do |match|
      str = $1.strip
      items << str if str.length > 0
      ""
    end
    items |= remains.gsub(/[\[\]]/, "").strip.split(/\s+/)
    items.uniq
  end
end

class Array
  def join_with_brackets
    self.map {|i| i.enclose_with_brackets }.join(" ")
  end
  
  def join_with_quotes
    self.map {|i| i.enclose_with_quotes }.join(" ")
  end
end
