class TiddlersAsTaggable < ActiveRecord::Migration
  def self.up
    rename_column "tags_tiddlers", "tiddler_id", "taggable_id" # XXX SQLite error
    add_column "tags_tiddlers", "taggable_type", :string
    rename_table "tags_tiddlers", "taggings"
    add_index "taggings", ["taggable_id", "taggable_type", "tag_id"], :name => "taggings_index"
    
    # MySQL
    execute "ALTER TABLE taggings ADD id int(11) NOT NULL auto_increment PRIMARY KEY" rescue nil
    # PostgreSQL
    execute "ALTER TABLE taggings ADD id serial PRIMARY KEY" rescue nil
    # XXX SQLite
    
    execute "UPDATE taggings SET taggable_type = 'Tiddler'"
    
    remove_column "tags", "color"
    
    add_index "tags", "name", :unique => true, :name => "tags_unique"
  end

  def self.down
    remove_index "tags", :name => "tags_unique"
    
    add_column "tags", "color", :string
    
    remove_column "taggings", "id"
    
    remove_index "taggings", :name => "taggings_index"
    rename_table "taggings", "tags_tiddlers"
    remove_column "tags_tiddlers", "taggable_type"
    rename_column "tags_tiddlers", "taggable_id", "tiddler_id"
  end
end
