Localization.define('default') do |l|
  l.store 'go_to_top', 'Go to top page'
  l.store 'javascript_warning', 'This page requires JavaScript to function properly'
  l.store 'loading', 'Loading...'
  l.store 'anonymous', '(anonymous)'
  l.store 'created_at', 'created'

  l.store 'date_format', '%%d %%b %%Y'
  l.store 'datetime_format', '%%a %%b %%d %%H:%%M:%%S %%Y'

  l.store 'site_login_required_none', 'Anyone can edit this wiki'
  l.store 'site_login_required_edit', 'Only the owner can edit this wiki'
  l.store 'site_login_required_all', 'This is a private wiki'

  l.store 'command_new', 'new'
  l.store 'command_close_all', 'close all'
  l.store 'command_search', 'search'
  l.store 'command_login', 'login'
  l.store 'login_title', 'owner login'
  l.store 'owner_login_label', 'owner'
  l.store 'owner_password_label', 'password'
  l.store 'owner_flag', 'owner'
  l.store 'logout_link', 'logout'
  l.store 'login_failed', 'Login failed'

  l.store 'tab_timeline', 'Timeline'
  l.store 'tab_colors', 'Colors'
  l.store 'tab_tags', 'Tags'

  l.store 'previous_page', 'prev'
  l.store 'next_page', 'next'

  l.store 'can_not_delete', 'You can not delete \'%s\''
  l.store 'login_required', 'Login required'
  l.store 'not_found', '*not found*'
  l.store 'not_found_title', '*\'%s\' not found*'
  l.store 'message_close', 'close'

  l.store 'external_link', 'External link to %s'
  l.store 'non_existing', 'The tiddler \'%s\' doesn\'t yet exist'

  l.store 'tags_title', 'tags'
  l.store 'no_tags', 'no tags'
  l.store 'tagging_title', 'tagging'
  l.store 'search_result_title', 'search result'

  l.store 'aliases_label', 'aliases'
  l.store 'tags_label', 'tags'
  l.store 'autolink_label', 'autolink'
  l.store 'editor_footer', 'Type aliases and tags separated with spaces, [[use double square brackets]] if necessary'

  l.store 'toolbar_close', 'close'
  l.store 'toolbar_close_others', 'close others'
  l.store 'toolbar_edit', 'edit'
  l.store 'toolbar_source', 'source'
  l.store 'toolbar_permalink', 'permalink'
  l.store 'toolbar_jump', 'jump'
  l.store 'toolbar_done', 'done'
  l.store 'toolbar_cancel', 'cancel'
  l.store 'toolbar_delete', 'delete'
  l.store 'delete_confirm', 'Are you sure you want to delete \'%s\'?'

  l.store 'signup_title', 'Owner Signup'
  l.store 'login_name_label', 'Login name'
  l.store 'choose_password_label', 'Choose password'
  l.store 'confirm_password_label', 'Confirm password'
  l.store 'signup_submit', 'Signup'

  l.store 'login_title', 'Owner Login'
  l.store 'password_label', 'Password'
  l.store 'login_submit', 'Login'

  l.store 'attribute_title', 'title'
  l.store 'attribute_content', 'content'

  l.store 'color_none', 'none'
  l.store 'color_red', 'red'
  l.store 'color_orange', 'orange'
  l.store 'color_yellow', 'yellow'
  l.store 'color_green', 'green'
  l.store 'color_blue', 'blue'
  l.store 'color_purple', 'purple'
  l.store 'color_gray', 'gray'

  # Active Record error messages
  #
  # when the error message requires arguments
  #   %%s   => will be evaluated by Active Record
  #   %%%%s => will be converted to the attribute name
  # when the error message does not require arguments
  #   %%s   => will be converted to the attribute name
  l.store 'error_inclusion', '%%s is not included in the list'
  l.store 'error_exclusion', '%%s is reserved'
  l.store 'error_invalid', '%%s is invalid'
  l.store 'error_confirmation', '%%s doesn\'t match confirmation'
  l.store 'error_accepted', '%%s must be accepted'
  l.store 'error_empty', '%%s can\'t be empty'
  l.store 'error_blank', '%%s can\'t be blank'
  l.store 'error_too_long', '%%%%s is too long (max is %%d characters)'
  l.store 'error_too_short', '%%%%s is too short (min is %%d characters)'
  l.store 'error_wrong_length', '%%%%s is the wrong length (should be %%d characters)'
  l.store 'error_taken', 'The same %%s has already been used'
  l.store 'error_not_a_number', '%%s is not a number'

  l.store 'error_conflict', 'Conflict detected. Check the differences and save again.'

  l.store 'settings_title', 'Settings'
  l.store 'setting_results_title', 'Setting Result'
  l.store 'wiki_title_label', 'Wiki title'
  l.store 'wiki_description_label', 'Wiki description'
  l.store 'base_url_label', 'Base URL'
  l.store 'language_label', 'Language'
  l.store 'locale_label', 'Localize'
  l.store 'time_zone_label', 'Time zone'
  l.store 'markup_engine_label', 'Markup engine'
  l.store 'permission', 'Permission'
  l.store 'login_required_all', 'Login required for all operations'
  l.store 'login_required_edit', 'Login required to edit'
  l.store 'login_required_none', 'Login not required'
  l.store 'setting_submit', 'Save'
  l.store 'setting_back', 'Back'
  l.store 'goto_wiki', 'Go to wiki'
end
