require 'fileutils'
require 'digest/sha1'

class AdminController < ApplicationController
  def index
    unless @session[:admin]
      redirect_to :action => "login"
      return
    end
    
    if @request.post?
      validator = SettingValidator.new(params[:setting])
      validator.validate(:wiki_title, :wiki_description)
      unless validator.errors.empty?
        @errors = validator.errors.full_messages
        return
      end
      
      Setting.transaction do
        for field, value in params[:setting]
          setting = find_or_create(field)
          setting.value = value
          setting.save
        end
      end
      
      config_reload
      Localization.lang = config_values[:locale]
      
      FileUtils.rm_rf(Dir.glob(File.join(RAILS_ROOT, "tmp", "cache", "*")))
      
      redirect_to :controller => "admin", :action => "updated"
      return
    end
  end
  
  def updated
    
  end
  
  def signup
    if Setting.find_by_name("owner_login")
      # owner already registerd
      redirect_to :action => "login"
      return
    end
    
    if @request.post?
      validator = SettingValidator.new(params[:setting])
      validator.validate(:owner_login, :owner_password)
      unless validator.errors.empty?
        @errors = validator.errors.full_messages
        return
      end
      
      Setting.transaction do
        for field, value in params[:setting]
          next if field =~ /_confirmation$/
          setting = find_or_create(field)
          if field =~ /_password$/
            setting.value = sha1(value)
          else
            setting.value = value
          end
          setting.save
        end
      end
      
      @session[:admin] = 1
      redirect_to :controller => "admin", :action => "index"
      return
    end
  end
  
  def login
    unless Setting.find_by_name("owner_login")
      # owner has not been registerd
      redirect_to :action => "signup"
      return
    end
    
    if @request.post?
      if authenticate?(params[:login][:owner_login], params[:login][:owner_password])
        @session[:admin] = true
        redirect_to :action => "index"
      else
        @error = "Login failed"
        @login = params[:login]
      end
    end
  end
  
  def logout
    @session[:admin] = nil
    redirect_to :action => "login"
  end
  
  protected
  
  def find_or_create(name)
    unless setting = Setting.find_by_name(name)
      setting = Setting.new("name" => name)
    end
    setting
  end
end

class SettingValidator < ActiveRecord::Validations::Validator
  validates :owner_login, :length => 3..15
  validates :owner_password, :length => 6..10, :confirm => true
  validates :wiki_title, :length => 1..30
  validates :wiki_description, :length => 0..100
end
