class Array
  def strip_newline
    self.delete("\n")
  end
end

# simplify the nested helpers (clear away the 'capture')
# http://ruby.cycnus.de/articles/06/jan/markaby/
class Markaby::Builder
  alias out <<
  
  def h(str)
    out ERB::Util.html_escape(str)
  end
  
  alias old_initialize initialize
  
  def initialize *args, &block
    old_initialize *args, &block
    @output_helpers = false
  end
end unless Markaby::Builder.instance_methods.include? 'out'

module ApplicationHelper
  def adjust_time(time)
    zone = TimeZone[config_values[:time_zone]] || TimeZone["London"]
    zone.adjust(time)
  end
  
  # Convert GMT time to local-time of user's browser
  def local_time(unixt, fmt = "%d %b %Y at %I:%M:%S %p")
    adjust_time(unixt).strftime(fmt).to_s
  end
  
  def local_date(unixt)
    local_time(unixt, _("date_format"))
  end
  
  # Returns config value with html-escape.
  def config_value(name)
    capture { h(capture { config_values[name] }) }
  end
  
  def has_write_permission
    case config_value(:permission).to_i
    when 1
      true
    when 2
      @session[:login] ? true : false
    when 3
      @session[:login] ? true : false
    else
      false
    end
  end
end
