$: << File.dirname(__FILE__) + "../../lib"

require 'chunks/chunk'

# The markup engines are Chunks that call the one of RedCloth
# or RDoc to convert text. This markup occurs when the chunk is required
# to mask itself.
module Engines
  class AbstractEngine < Chunk::Abstract

    # Create a new chunk for the whole content and replace it with its mask.
    def self.apply_to(content, tiddlers, aliases)
      new_chunk = self.new(content)
      content.replace(new_chunk.mask.gsub(/<a\s+href="([^"]*)"([^>]*)>/,
        %{<a class="external_link" target="_blank" href="\\1" \\2>}))
      
      #html = new_chunk.mask
      #if html.index("<")
      #  tokenizer = HTML::Tokenizer.new(new_chunk.mask)
      #  new_text = ""
      #  while token = tokenizer.next
      #    node = HTML::Node.parse(nil, 0, 0, token, false)
      #    if node.match(:tag => "a")
      #      text = node.children.inject("") {|r, c| r << c.to_s }
      #      new_text << %{<a href="#{node.attributes["href"]}">#{text}</a>}
      #    else
      #      new_text << node.to_s
      #    end
      #  end
      #  html = new_text
      #end
      #content.replace(html)
    end

    private 

    # Never create engines by constructor - use apply_to instead
    def initialize(content)
      @content = content
    end

  end

  class Textile < AbstractEngine
    def mask
      # Convert double-space to newline (Markdown like feature)
      redcloth = RedCloth.new(@content.gsub(/  [\r\n]/, "<br />"), @content.options[:engine_opts])
      
      # Don't use hard-breaks because it causes a multi-line-header bug
      redcloth.hard_breaks = false
      redcloth.filter_html = false
      redcloth.no_span_caps = true
      redcloth.to_html(:textile)
    end
  end
  
  class Markdown < AbstractEngine
    def mask
      content = nil
      if defined? BlueCloth
        # Use BlueCloth to render Markdown format
        begin
          content = BlueCloth.new(@content, @content.options[:engine_opts]).to_html
        rescue
          # BlueCloth causes an error when '`' is not closed.
          bluecloth = BlueCloth.new(@content.gsub(/`/, "<backquote />"), @content.options[:engine_opts])
          content = bluecloth.to_html.gsub(/<backquote \/>/, '`')
        end
      else  # BlueCloth is not installed
        # Use RedCloth to render Markdown format
        # Convert double-space to newline (Markdown like feature)
        redcloth = RedCloth.new(@content.gsub(/  [\r\n]/, "<br />"), @content.options[:engine_opts])
        
        # Don't use hard-breaks because it causes a multi-line-header bug
        redcloth.hard_breaks = false
        redcloth.filter_html = false
        redcloth.no_span_caps = true
        content = redcloth.to_html(:markdown)
      end
      RubyPants.new(content).to_html
    end
  end
  
  # Use RedCloth to render Markdown format
  #class Markdown < AbstractEngine
  #  def mask
  #    # Convert double-space to newline (Markdown like feature)
  #    redcloth = RedCloth.new(@content.gsub(/  [\r\n]/, "<br />"), @content.options[:engine_opts])
  #    
  #    # Don't use hard-breaks because it causes a multi-line-header bug
  #    redcloth.hard_breaks = false
  #    redcloth.filter_html = false
  #    redcloth.no_span_caps = true
  #    RubyPants.new(redcloth.to_html(:markdown)).to_html
  #  end
  #end

  class Mixed < AbstractEngine
    def mask
      # Convert double-space to newline (Markdown like feature)
      redcloth = RedCloth.new(@content.gsub(/  [\r\n]/, "<br />"), @content.options[:engine_opts])
      
      # Don't use hard-breaks because it causes a multi-line-header bug
      redcloth.hard_breaks = false
      redcloth.filter_html = false
      redcloth.no_span_caps = true
      RubyPants.new(redcloth.to_html).to_html
    end
  end

  MAP = {
    :textile => Textile,
    :markdown => Markdown,
    :mixed => Mixed
  }
  MAP.default = Textile
end
