module ActionView
  module Helpers
    module CacheHelper
      # Override cache() to call cache_markaby_fragment() instead of
      # calling cache_erb_fragment().
      def cache(name = {}, &block)
        @controller.cache_markaby_fragment(block, name)
      end
      
      # If the given condition is true call cache(), otherwise evaluate
      # the block directly.
      def cache_if(cond, name = {}, &block)
        if cond
          cache(name, &block)
        else
          block.call
        end
      end
    end
  end
end
