# This file was developed based on ActiveHeart's implementation
#
# How to localize Active Record error messages:
#
#   set_field_name :source => 'Source'
#
# ActiveHeart is released under MIT license.
#
# MIT License
# gorou <hotchpotch@gmail.com>
#
ActiveRecord::Base.class_eval do
  class << self
    def field_name(key, name)
      @field_names ||= HashWithIndifferentAccess.new
      @field_names.update({ key => name })
    end

    alias_method :_human_attribute_name, :human_attribute_name
    def human_attribute_name(attribute_key_name)
      if @field_names && @field_names[attribute_key_name]
        @field_names[attribute_key_name]
      else
        _human_attribute_name(attribute_key_name)
      end
    end
  end
end

ActiveRecord::Errors.class_eval do
  alias_method :_full_messages, :full_messages
  def full_messages
    full_messages = []

    @errors.each_key do |attr|
      @errors[attr].each do |msg|
        next if msg.nil?

        if attr == "base"
          full_messages << msg
        else
          hmsg = sprintf(msg, @base.class.human_attribute_name(attr))
          hmsg.capitalize if hmsg =~ /^[a-z]/
          full_messages << hmsg
        end
      end
    end

    full_messages
  end
end
