module ActionController
  module Macros
    module Validator
      def self.append_features(base)
        super
        base.extend(ClassMethods)
      end

      module ClassMethods
        def remote_validate_for(field, options)
          define_method("remote_validate_for_#{field}") do
            v = (options[:validator] || Object.const_get(self.class.to_s.sub('Controller', 'Validator').to_sym)).new(params)
            v.validate(options[:attribute] ? {field => options[:attribute]} : field)
            if message = v.errors.on(field)
              response = {
                'result' => 'false',
                'message' => message
              }
            else
               response = {
                'result' => 'true'
              }
            end
            render_text(response.collect { |k, v| "#{CGI::escape(k)}=#{CGI::escape(v)}"}.join('&'))
          end
        end
      end
    end
  end
end