/**
 * IP å󥸥饤֥(Unix)
 * źեե륯饹
 */
 
#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "IpMessenger.h"
#include "ipmsg.h"
using namespace std;

static int file_id = 0;

/**
 * źեեեѥǸ
 * @param fullParh оݤΥեѥ
 * @retval դäAttachFileΥƥ졼դʤend();
 */
vector<AttachFile>::iterator
AttachFileList::FindByFullPath( string fullPath )
{
	for( vector<AttachFile>::iterator i = begin(); i != end(); i++ ) {
		if ( i->FullPath() == fullPath ) {
			return i;
		}
	}
	return end();
}

/**
 * źեե륪֥ȤʬȰפ뤫֤
 * @param item źեե
 * @retval źեե륪֥ȤؤΥƥ졼
 */
vector<AttachFile>::iterator
AttachFileList::FindByFileId( int file_id )
{
	for( vector<AttachFile>::iterator ixfile = begin(); ixfile != end(); ixfile++ ) {
		printf( "file_id  %d\n", file_id );
		printf( "ixfile->FileId %d\n", ixfile->FileId() );
		printf( "ixfile->FileName %s\n", ixfile->FileName().c_str() );
		fflush( stdout );
		if ( file_id == ixfile->FileId() ) {
			return ixfile;
		}
	}
	return end();
}

/**
 * źեե륳󥹥ȥ饯
 * file_id+1ǥեid
 */
AttachFile::AttachFile()
{
	printf("file_id before     == %d\n", file_id );
	_FileId = file_id++;
	printf("AttachFile::FileId == %d\n", FileId() );
	printf("file_id after      == %d\n", file_id );
}

/**
 * źեե
 */
void
AttachFile::GetLocalFileInfo()
{
	struct stat st;
	unsigned int loc = FullPath().find_last_of( '/' );
	string filename, location;
	if ( loc == string::npos ) {
		filename = FullPath();
	} else {
		location = FullPath().substr( 0, loc );
		filename = FullPath().substr( loc + 1 );
	}
	setFileName( filename );
	setLocation( location );
	stat( FullPath().c_str(), &st );
	setAttr( 0 );
	if ( S_ISDIR( st.st_mode ) ) {
		setAttr( IPMSG_FILE_DIR );
		st.st_size = 0;
	} else {
		setAttr( IPMSG_FILE_REGULAR );
	}
	setMTime( st.st_mtime );
	setIsDownloaded( false );
	setIsDownloading( false );
	setFileSize( st.st_size );
}

/**
 * źեե뤬̥ե뤫ɤȽꡣ
 * @retval ̥ե:true̥եǤʤ:false
 */
bool
AttachFile::IsRegularFile()
{
	return GET_FILETYPE( Attr() ) == IPMSG_FILE_REGULAR;
}

/**
 * źեե뤬ǥ쥯ȥ꤫ɤȽꡣ
 * @retval ǥ쥯ȥ:trueǥ쥯ȥǤʤ:false
 */
bool
AttachFile::IsDirectory()
{
	return GET_FILETYPE( Attr() ) == IPMSG_FILE_DIR;
}

/**
 * ǥ쥯ȥꥹåեѥ롣
 * @param dirstack ǥ쥯ȥꥹå
 * @retval եѥ
 */
string
AttachFile::CreateDirFullPath( vector<string> dirstack )
{
	string retdir = "";
	for( vector<string>::iterator d = dirstack.begin(); d != dirstack.end(); d++ ){
		if ( *d != "" ) {
			retdir += *d + ( d->at(d->size() - 1) == '/' ? "" : "/" );
			printf("retdir = %s\n", retdir.c_str());
		}
	}
	return retdir;
}

/**
 * ǥ쥯ȥ׵ʸαǥ쥯ȥ깽¤إåϤźեե륪֥Ȥ롣
 * @param buf Хåե
 * @param conv ե̾С
 * @retval źեե륪֥
 */
AttachFile
AttachFile::AnalyzeHeader( char *buf, FileNameConverter *conv )
{
	char tmpbuf[100];
	int len = strlen( buf );
	int j = 0;
	int pos = 0;
	AttachFile f;
	for( int i=0; i < len; i++ ) {
		if ( buf[i] == ':' ) {
			if ( buf[i+1] != ':' ) {
				tmpbuf[j] = 0;
				pos = ++i;
				f.setFileName( conv->ConvertNetworkToLocal( tmpbuf ) );
				break;
			} else {
				i++;
			}
		}
		tmpbuf[j] = buf[i];
		j++;
	}
	char *dmyptr;
	string size = "";
	j = 0;
	for( int i=pos; i < len; i++ ){
		if ( buf[i] == ':' ) {
			tmpbuf[j] = 0;
			size = tmpbuf;
			pos = ++i;
			break;
		}
		tmpbuf[j] = buf[i];
		j++;
	}
	f.setFileSize( strtoull( size.c_str(), &dmyptr, 16 ) );

	string fattr = "";
	j = 0;
	for( int i=pos; i < len; i++ ){
		if ( buf[i] == ':' ) {
			tmpbuf[j] = 0;
			fattr = tmpbuf;
			pos = ++i;
			break;
		}
		tmpbuf[j] = buf[i];
		j++;
	}
	f.setAttr( strtoull( fattr.c_str(), &dmyptr, 16 ) );

	while( buf[pos] != '\0' ) {
		j = 0;
		string fextattr = "";
		for( int i=pos; i < len; i++ ){
			if ( buf[i] == ':' ) {
				tmpbuf[j] = 0;
				fextattr = tmpbuf;
				int eqpos = -1;
				for( int k = 0; tmpbuf[k] != '\0'; k++ ){ 
					if ( tmpbuf[k] == '=' ) {
						tmpbuf[k] = '\0';
						eqpos = k + 1;
						break;
					}
				}
				if ( eqpos >= 0 ) {
					dmyptr = tmpbuf;
					char *topchar = dmyptr;
					while( *dmyptr != '\0' ) {
						f.addExtAttrs( tmpbuf, strtoul( topchar, &dmyptr, 16 ) );
						topchar = ++dmyptr;
					}
					pos = ++i;
					break;
				}
			}
			tmpbuf[j] = buf[i];
			j++;
		}
	}

	return f;
}
