/**
 * IP å󥸥饤֥(Unix)
 * źեե륯饹
 */
 
#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "IpMessenger.h"
#include "IpMessengerImpl.h"
#include "ipmsg.h"
using namespace std;

static int file_id = 0;

/**
 * 󥹥ȥ饯
 * <ul>
 * <li>եꥹȤå뤿Υߥ塼ƥå</li>
 * </ul>
 */
AttachFileList::AttachFileList()
{
	IpMsgMutexInit( "AttachFileList::AttachFileList()", &filesMutex, NULL );
}

/**
 * ԡ󥹥ȥ饯
 * <ul>
 * <li>եꥹȤå뤿Υߥ塼ƥå</li>
 * </ul>
 * @param other ԡΥ֥
 */
AttachFileList::AttachFileList( const AttachFileList& other )
{
	IpMsgMutexInit( "AttachFileList::AttachFileList(AttachFileList&)", &filesMutex, NULL );
	other.Lock( "AttachFileList::AttachFileList(AttachFileList&)" );
	CopyFrom( other );
	other.Unlock( "AttachFileList::AttachFileList(AttachFileList&)" );
}

/**
 * 黻ҡ
 * <ul>
 * <li>եꥹȤå뤿Υߥ塼ƥå</li>
 * </ul>
 * @param other ԡΥ֥
 * @retval ֥ȤΥ󥹥
 */
AttachFileList&
AttachFileList::operator=( const AttachFileList& other )
{
	IpMsgMutexInit( "AttachFileList::operator=(AttachFileList&)", &filesMutex, NULL );
	other.Lock( "AttachFileList::operator=(AttachFileList&)" );
	CopyFrom( other );
	other.Unlock( "AttachFileList::operator=(AttachFileList&)" );
	return *this;
}

/**
 * ԡ᥽åɡ
 * @param other ԡΥ֥
 */
void
AttachFileList::CopyFrom( const AttachFileList& other )
{
	files = other.files;
}

/**
 * ǥȥ饯
 * <ul>
 * <li>եꥹȤå뤿Υߥ塼ƥå˴</li>
 * </ul>
 */
AttachFileList::~AttachFileList()
{
	IpMsgMutexDestroy( "AttachFileList::~AttachFileList()", &filesMutex );
}

/**
 * եꥹȤå
 * @param pos åƤ֤򼨤ʸ
 */
void
AttachFileList::Lock( const char *pos ) const
{
	IpMsgMutexLock( pos, const_cast< pthread_mutex_t* >( &filesMutex ) );
}

/**
 * եꥹȤ򥢥å
 * @param pos åƤ֤򼨤ʸ
 */
void
AttachFileList::Unlock( const char *pos ) const
{
	IpMsgMutexUnlock( pos, const_cast< pthread_mutex_t * >( &filesMutex ) );
}

/**
 * եɲäޤ
 * @param file ɲäźեե륪֥
 */
void
AttachFileList::AddFile( const AttachFile& file )
{
	Lock( "AttachFileList::AddFile()" );
	files.push_back( file );
	Unlock( "AttachFileList::AddFile()" );
}

/**
 * եƬؤƥ졼֤ޤ
 */
vector<AttachFile>::iterator
AttachFileList::begin()
{
	return files.begin();
}

/**
 * եνüΰĸؤƥ졼֤ޤ
 */
vector<AttachFile>::iterator
AttachFileList::end()
{
	return files.end();
}

/**
 * ե¸ߤźեեθĿ֤ޤ
 * @retval źեե륪֥ȤθĿ
 */
int
AttachFileList::size() const
{
	Lock( "AttachFileList::size()" );
	int ret = files.size();
	Unlock( "AttachFileList::size()" );
	return ret;
}

/**
 * ե򥯥ꥢޤ
 */
void
AttachFileList::clear()
{
	Lock( "AttachFileList::clear()" );
	files.clear();
	Unlock( "AttachFileList::clear()" );
}

/**
 * եźեեޤ
 * @param item źեե륪֥
 */
vector<AttachFile>::iterator
AttachFileList::erase( vector<AttachFile>::iterator item )
{
	Lock( "AttachFileList::erase(vector<AttachFile>::iterator)" );
	vector<AttachFile>::iterator ret = files.erase( item );
	Unlock( "AttachFileList::erase(vector<AttachFile>::iterator)" );
	return ret;
}

/**
 * եźեեޤ
 * @param item źեե륪֥
 */
vector<AttachFile>::iterator
AttachFileList::erase( const AttachFile& item )
{
	vector<AttachFile>::iterator it = FindByFileId( item.FileId() );
	Lock( "AttachFileList::erase(AttachFile&)" );
	vector<AttachFile>::iterator ret = files.erase( it );
	Unlock( "AttachFileList::erase(AttachFile&)" );
	return ret;
}

/**
 * źեեեѥǸ
 * @param fullPath оݤΥեѥ
 * @retval դäAttachFileΥƥ졼
 * @retval դʤend()
 */
vector<AttachFile>::iterator
AttachFileList::FindByFullPath( const string& fullPath )
{
	Lock( "AttachFileList::FindByFullPath()" );
	vector<AttachFile>::iterator ret = end();
	for( vector<AttachFile>::iterator i = begin(); i != end(); i++ ) {
		if ( i->FullPath() == fullPath ) {
			ret = i;
			break;
		}
	}
	Unlock( "AttachFileList::FindByFullPath()" );
	return ret;
}

/**
 * źեեեID˸פ륪֥ȤΥƥ졼֤
 * @param file_id źեեΥեID
 * @retval źեե륪֥ȤؤΥƥ졼
 * @retval ¸ߤʤ硢end()
 */
vector<AttachFile>::iterator
AttachFileList::FindByFileId( int file_id )
{
	Lock( "AttachFileList::FindByFileId()" );
	vector<AttachFile>::iterator ret = end();
	for( vector<AttachFile>::iterator ixfile = begin(); ixfile != end(); ixfile++ ) {
#ifdef DEBUG
		printf( "file_id  %d\n", file_id );fflush(stdout);
		printf( "ixfile->FileId %d\n", ixfile->FileId() );fflush(stdout);
		printf( "ixfile->FileName %s\n", ixfile->FileName().c_str() );fflush(stdout);
#endif
		if ( file_id == ixfile->FileId() ) {
			ret = ixfile;
			break;
		}
	}
	Unlock( "AttachFileList::FindByFileId()" );
	return ret;
}

/**
 * źեե륳󥹥ȥ饯
 * <ul>
 * <li>file_id+1ǥեid</li>
 * </ul>
 */
AttachFile::AttachFile()
{
#ifdef DEBUG
	printf("file_id before     == %d\n", file_id );fflush(stdout);
#endif
	_FileId = file_id++;
#ifdef DEBUG
	printf("AttachFile::FileId == %d\n", FileId() );fflush(stdout);
	printf("file_id after      == %d\n", file_id );fflush(stdout);
#endif
}

/**
 * źեե
 */
void
AttachFile::GetLocalFileInfo()
{
	struct stat st;
	unsigned int loc = FullPath().find_last_of( '/' );
	string filename, location;
	if ( loc == string::npos ) {
		filename = FullPath();
	} else {
		location = FullPath().substr( 0, loc );
		filename = FullPath().substr( loc + 1 );
	}
	setFileName( filename );
	setLocation( location );
	lstat( FullPath().c_str(), &st );
	setAttr( 0 );
	if ( S_ISDIR( st.st_mode ) ) {
		setAttr( IPMSG_FILE_DIR );
		st.st_size = 0;
	} else {
		setAttr( IPMSG_FILE_REGULAR );
	}
	setMTime( st.st_mtime );
	setIsDownloaded( false );
	setIsDownloading( false );
	setFileSize( st.st_size );
}

/**
 * źեե뤬̥ե뤫ɤȽꡣ
 * @retval true:̥ե
 * @retval false:̥եǤʤ
 */
bool
AttachFile::IsRegularFile() const
{
	return GET_FILETYPE( Attr() ) == IPMSG_FILE_REGULAR;
}

/**
 * źեե뤬ǥ쥯ȥ꤫ɤȽꡣ
 * @retval true:ǥ쥯ȥ
 * @retval false:ǥ쥯ȥǤʤ
 */
bool
AttachFile::IsDirectory() const
{
	return GET_FILETYPE( Attr() ) == IPMSG_FILE_DIR;
}

/**
 * ǥ쥯ȥꥹåեѥ롣
 * @param dirstack ǥ쥯ȥꥹå
 * @retval եѥ
 */
string
AttachFile::CreateDirFullPath( const vector<string>& dirstack )
{
	string retdir = "";
	for( int i = 0; i < (int)dirstack.size(); i++ ){
		if ( dirstack[i] != "" ) {
			retdir += dirstack[i] + ( dirstack[i].at(dirstack[i].size() - 1) == '/' ? "" : "/" );
#ifdef DEBUG
			printf("retdir = %s\n", retdir.c_str());fflush(stdout);
#endif
		}
	}
	return retdir;
}

/**
 * ǥ쥯ȥ׵ʸαǥ쥯ȥ깽¤إåϤźեե륪֥Ȥ롣
 * @param buf Хåե
 * @param conv ե̾С
 * @retval źեե륪֥
 */
AttachFile
AttachFile::AnalyzeHeader( char *buf, FileNameConverter *conv )
{
	char tmpbuf[100];
	int len = strlen( buf );
	int j = 0;
	int pos = 0;
	AttachFile f;
	for( int i=0; i < len; i++ ) {
		if ( buf[i] == ':' ) {
			if ( buf[i+1] != ':' ) {
				tmpbuf[j] = 0;
				pos = ++i;
				f.setFileName( conv->ConvertNetworkToLocal( tmpbuf ) );
				break;
			} else {
				i++;
			}
		}
		tmpbuf[j] = buf[i];
		j++;
	}
	char *dmyptr;
	string size = "";
	j = 0;
	for( int i=pos; i < len; i++ ){
		if ( buf[i] == ':' ) {
			tmpbuf[j] = 0;
			size = tmpbuf;
			pos = ++i;
			break;
		}
		tmpbuf[j] = buf[i];
		j++;
	}
	f.setFileSize( strtoull( size.c_str(), &dmyptr, 16 ) );

	string fattr = "";
	j = 0;
	for( int i=pos; i < len; i++ ){
		if ( buf[i] == ':' ) {
			tmpbuf[j] = 0;
			fattr = tmpbuf;
			pos = ++i;
			break;
		}
		tmpbuf[j] = buf[i];
		j++;
	}
	f.setAttr( strtoull( fattr.c_str(), &dmyptr, 16 ) );

	while( buf[pos] != '\0' ) {
		j = 0;
		string fextattr = "";
		for( int i=pos; i < len; i++ ){
			if ( buf[i] == ':' ) {
				tmpbuf[j] = 0;
				fextattr = tmpbuf;
				int eqpos = -1;
				for( int k = 0; tmpbuf[k] != '\0'; k++ ){ 
					if ( tmpbuf[k] == '=' ) {
						tmpbuf[k] = '\0';
						eqpos = k + 1;
						break;
					}
				}
				if ( eqpos >= 0 ) {
					dmyptr = tmpbuf;
					char *topchar = dmyptr;
					while( *dmyptr != '\0' ) {
						f.addExtAttrs( tmpbuf, strtoul( topchar, &dmyptr, 16 ) );
						topchar = ++dmyptr;
					}
					pos = ++i;
					break;
				}
			}
			tmpbuf[j] = buf[i];
			j++;
		}
	}

	return f;
}
