/**
 * IP å󥸥饤֥(Unix)
 * ۥȥꥹȥ饹
 */
  
#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "IpMessenger.h"
#include "IpMessengerImpl.h"
#include "ipmsg.h"
#include <algorithm>

using namespace std;

#define HOST_LIST_SEND_MAX_AT_ONCE	100

/**
 * 󥹥ȥ饯
 * <ul>
 * <li>ۥȥꥹȤå뤿Υߥ塼ƥå</li>
 * </ul>
 */
HostList::HostList()
{
	IpMsgMutexInit( "HostList::HostList()", &hostListMutex, NULL );
}

/**
 * ԡ󥹥ȥ饯
 * <ul>
 * <li>ۥȥꥹȤå뤿Υߥ塼ƥå</li>
 * </ul>
 * @param other ԡΥ֥
 */
HostList::HostList( const HostList& other )
{
	IpMsgMutexInit( "HostList::HostList(HostList&)", &hostListMutex, NULL );
	Lock( "HostList::HostList(HostList&)" );
	CopyFrom( other );
	Unlock( "HostList::HostList(HostList&)" );
}

/**
 * ǥȥ饯
 * <ul>
 * <li>ۥȥꥹȤå뤿Υߥ塼ƥå˴</li>
 * </ul>
 */
HostList::~HostList()
{
	IpMsgMutexDestroy( "HostList::~HostList()", &hostListMutex );
}

/**
 * 黻ҡ
 * <ul>
 * <li>ۥȥꥹȤå뤿Υߥ塼ƥå</li>
 * </ul>
 * @param other ԡΥ֥
 * @retval ֥ȤΥ󥹥
 */
HostList&
HostList::operator=( const HostList& other )
{
	IpMsgMutexInit( "HostList::operator=(HostList&)", &hostListMutex, NULL );
	Lock( "HostList::operator=(HostList&)" );
	CopyFrom( other );
	Unlock( "HostList::operator=(HostList&)" );
	return *this;
}

/**
 * ԡ᥽åɡ
 * @param other ԡΥ֥
 */
void
HostList::CopyFrom( const HostList& other )
{
	items = other.items;
}

/**
 * ۥȥꥹȤå
 * @param pos åƤ֤򼨤ʸ
 */
void
HostList::Lock( const char *pos ) const
{
	IpMsgMutexLock( pos, const_cast< pthread_mutex_t* >( &hostListMutex ) );
}

/**
 * ۥȥꥹȤ򥢥å
 * @param pos åƤ֤򼨤ʸ
 */
void
HostList::Unlock( const char *pos ) const
{
	IpMsgMutexUnlock( pos, const_cast< pthread_mutex_t * >( &hostListMutex ) );
}

/**
 * ۥȥꥹȤƬ򼨤ƥ졼֤
 * @retval ۥȥꥹȤƬ򼨤ƥ졼
 */
inline
vector<HostListItem>::iterator
HostList::begin()
{
	return items.begin();
}

/**
 * ۥȥꥹȤܣ򼨤ƥ졼֤
 * @retval ۥȥꥹȤܣ򼨤ƥ졼
 */
inline
vector<HostListItem>::iterator
HostList::end()
{
	return items.end();
}

/**
 * ۥȥꥹȤθĿ֤
 * @retval ۥȥꥹȤθĿ
 */
int
HostList::size() const
{
	Lock( "HostList::size()" );
	int ret = items.size();
	Unlock( "HostList::size()" );
	return ret;
}

/**
 * ۥȥꥹȤ򥯥ꥢ롣
 */
void
HostList::clear()
{
	Lock( "HostList::clear()" );
	items.clear();
	Unlock( "HostList::clear()" );
}

/**
 * С䤤碌Ԥ
 */
void
HostListItem::QueryVersionInfo()
{
	IpMessengerAgentImpl *agent = IpMessengerAgentImpl::GetInstance();
	agent->QueryVersionInfo( *this );
}

/**
 * Ժʸ䤤碌Ԥ
 */
void
HostListItem::QueryAbsenceInfo()
{
	IpMessengerAgentImpl *agent = IpMessengerAgentImpl::GetInstance();
	agent->QueryAbsenceInfo( *this );
}

/**
 * IPɥ쥹򸵤˥ۥȤɤ롣
 * @retval true:ۥ
 * @retval false:ۥȤǤϤʤ
 */
bool
HostListItem::IsLocalHost() const
{
	IpMessengerAgentImpl *agent = IpMessengerAgentImpl::GetInstance();
	vector<NetworkInterface> nics = agent->NICs;
	for( unsigned int i = 0; i < nics.size(); i++ ){
		if ( IpAddress() == nics[i].IpAddress() ){
#if defined(INFO) || !defined(NDEBUG)
			printf("LOCALHOST\n");fflush(stdout);
#endif
			return true;
		}
	}
#if defined(INFO) || !defined(NDEBUG)
	printf("OTHERHOST\n");fflush(stdout);
#endif
	return false;
}

/**
 * ۥȾۥȥꥹȤɲä롣
 * @param host ۥȾ
 */
void
HostList::AddHost( const HostListItem& host )
{
	Lock( "HostList::AddHost()" );
	bool is_found = false;

	IpMessengerAgentImpl *agent = IpMessengerAgentImpl::GetInstance();
	string localhostName = agent->HostName();
	vector<NetworkInterface> nics = agent->NICs;
	for( unsigned int i = 1; i < nics.size(); i++ ){
#if defined(INFO) || !defined(NDEBUG)
		printf("AddHost HOST CHECK IpAddress=%s addr=%s\n", host.IpAddress().c_str(), nics[i].IpAddress().c_str() );fflush(stdout);
#endif
		if ( host.IpAddress() == nics[i].IpAddress() ) {
			Unlock( "HostList::AddHost()" );
			return;
		}
	}
	for( unsigned int i = 0; i < nics.size(); i++ ){
#if defined(INFO) || !defined(NDEBUG)
		printf("AddHost HOST CHECK IpAddress=%s addr=%s\n", host.IpAddress().c_str(), nics[i].IpAddress().c_str() );fflush(stdout);
#endif
		if ( host.IpAddress() == nics[i].NetworkAddress() ||
			 host.IpAddress() == nics[i].BroadcastAddress() ){
			Unlock( "HostList::AddHost()" );
			return;
		}
	}
#if defined(INFO) || !defined(NDEBUG)
	printf("AddHost HOST CHECK IpAddress=%s addr=%s\n", host.IpAddress().c_str(), nics[0].IpAddress().c_str() );fflush(stdout);
	printf("AddHost HOST CHECK HostName=%s localhost=%s\n", host.HostName().c_str(), localhostName.c_str() );fflush(stdout);
#endif
	if ( host.IpAddress() == "127.0.0.1" ){
#if defined(INFO) || !defined(NDEBUG)
		printf("IGNORE HOST.Because host IpAddress local loopback.\n" );fflush(stdout);
#endif
		Unlock( "HostList::AddHost()" );
		return;
	}
	if ( host.IpAddress() == nics[0].IpAddress() && host.HostName() != localhostName ){
		Unlock( "HostList::AddHost()" );
		return;
	}
	for( unsigned int i = 0; i < items.size(); i++ ){
		HostListItem tmpHost = items.at( i );
		if ( tmpHost.Equals( host ) ) {
			is_found = true;
			break;
		}
	}
	if ( !is_found ) {
#if defined(INFO) || !defined(NDEBUG)
		printf("AddHost Nickname=%s\n", host.Nickname().c_str() );fflush(stdout);
		printf("AddHost GroupName=%s\n", host.GroupName().c_str() );fflush(stdout);
#endif
		items.push_back( host );
	}
	if ( agent->GetSortHostListComparator() != NULL ){
		if ( items.size() > 0 ) {
			qsort( agent->GetSortHostListComparator(), 0, items.size() - 1 );
		}
	}
	Unlock( "HostList::AddHost()" );
}

/**
 * ۥȾۥȥꥹȤ롣
 * @param it ۥȾΥƥ졼
 */
void
HostList::Delete( vector<HostListItem>::iterator &it )
{
	Lock( "HostList::Delete()" );
	items.erase( it );
	Unlock( "HostList::Delete()" );
}
/**
 * ۥȾۥȥꥹȤ롣
 * @param hostname ۥ̾
 */
void
HostList::DeleteHost( string hostname )
{
	Lock( "HostList::DeleteHost()" );
	for( vector<HostListItem>::iterator ix = items.begin(); ix < items.end(); ix++ ){
		if ( ix->HostName() == hostname ) {
			items.erase( ix );
			break;
		}
	}
	Unlock( "HostList::DeleteHost()" );
}

/**
 * ۥȥꥹʸ롣
 * @param start ϰ
 * @param addr Υɥ쥹
 * @retval ۥȥꥹʸ
 */
string
HostList::ToString( int start, const struct sockaddr_in *addr )
{
	Lock( "HostList::ToString" );
	char buf[MAX_UDPBUF];
	string ret;
	unsigned int maxLength= IpMessengerAgentImpl::GetInstance()->GetMaxOptionBufferSize();

	ret = "";
	int hostCount = 0;
	for( unsigned int i = start ; i < items.size(); i++ ){
		HostListItem item = items.at( i );
		//ʬIPɥ쥹֤¾ΥͥåȥΥɥ쥹äƤˡ
		//Υ󥿡եΥɥ쥹֤
		if ( item.IsLocalHost() ) {
			IpMessengerAgentImpl *agent = IpMessengerAgentImpl::GetInstance();
			vector<NetworkInterface> nics = agent->NICs;
			string localaddr = nics[0].IpAddress();
			for( unsigned int i = 0; i < nics.size(); i++ ){
				if ( nics[i].NativeNetworkAddress() == (in_addr_t)( addr->sin_addr.s_addr & nics[i].NativeNetMask() ) ){
					localaddr = nics[i].IpAddress();
					break;
				}
			}
			sprintf( buf, "%s\a%s\a%ld\a%s\a%d\a%s\a%s\a",
							item.UserName() == "" ? "\b" : item.UserName().c_str(),
							item.HostName() == "" ? "\b" : item.HostName().c_str(),
							item.CommandNo(),
							localaddr == "" ? "\b" : localaddr.c_str(),
							htons( item.PortNo() ),
							item.Nickname() == "" ? "\b" : item.Nickname().c_str(),
							item.GroupName() == "" ? "\b" : item.GroupName().c_str() );
		} else {
			sprintf( buf, "%s\a%s\a%ld\a%s\a%d\a%s\a%s\a",
							item.UserName() == "" ? "\b" : item.UserName().c_str(),
							item.HostName() == "" ? "\b" : item.HostName().c_str(),
							item.CommandNo(),
							item.IpAddress() == "" ? "\b" : item.IpAddress().c_str(),
							htons( item.PortNo() ),
							item.Nickname() == "" ? "\b" : item.Nickname().c_str(),
							item.GroupName() == "" ? "\b" : item.GroupName().c_str() );
		}
		if ( ret.length() >= maxLength ){
			break;
		}
		ret = ret + buf;
		hostCount++;
	}
	snprintf( buf, sizeof( buf ), "%-5d\a%-5d\a", start , hostCount );
	ret = buf + ret;
	Unlock( "HostList::ToString" );
	return ret;
}

/**
 * ѥåȥ֥Ȥۥȥꥹȥƥ롣
 * @param packet ѥåȥ֥
 * @retval ۥȥꥹȥƥ
 */
HostListItem
HostList::CreateHostListItemFromPacket( const Packet& packet )
{
	HostListItem ret;
	ret.setHostName( packet.HostName() );
	ret.setUserName( packet.UserName() );
	ret.setCommandNo( packet.CommandMode() | packet.CommandOption() );
	char tmp[100];
	ret.setIpAddress( inet_ntoa_r( packet.Addr().sin_addr.s_addr, tmp, sizeof( tmp ) ) );
#if defined(INFO) || !defined(NDEBUG)
	printf( "CreateHostListItemFromPacket port %d\n", ntohs( packet.Addr().sin_port ) );fflush(stdout);
#endif
	ret.setPortNo( ntohs( packet.Addr().sin_port ) );
	unsigned int loc = packet.Option().find_first_of( '\0' );
	if ( loc == string::npos ) {
		ret.setNickname( packet.Option() );
		ret.setGroupName( "" );
	} else {
		ret.setNickname( packet.Option().substr( 0, loc ) );
		ret.setGroupName( packet.Option().substr( loc + 1 ) );
	}
	return ret;
}

/**
 * ۥȥꥹȤۥ̾ǸHostListItemֵѤ롣
 * @param hostName ۥ̾
 * @retval HostListItem
 */
vector<HostListItem>::iterator
HostList::FindHostByHostName( string hostName )
{
	Lock( "HostList::FindHostByHostName()" );
	vector<HostListItem>::iterator ret = end();
	for( vector<HostListItem>::iterator ix = begin(); ix < end(); ix++ ){
		if ( ix->HostName() == hostName ) {
			ret = ix;
			break;
		}
	}
	Unlock( "HostList::FindHostByHostName()" );
	return ret;
}

/**
 * ۥȥꥹȤIPɥ쥹ǸHostListItemֵѤ롣
 * @param addr IPɥ쥹ʸ
 * @retval HostListItem
 */
vector<HostListItem>::iterator
HostList::FindHostByAddress( string addr )
{
	Lock( "HostList::FindHostByAddress()" );
	vector<HostListItem>::iterator ret = end();
	for( vector<HostListItem>::iterator ix = begin(); ix < end(); ix++ ){
#if defined(DEBUG)
		printf("HOST CHECK IpAddress=%s addr=%s\n", ix->IpAddress().c_str(), addr.c_str() );fflush(stdout);
#endif
		if ( ix->IpAddress() == addr ) {
#if defined(DEBUG)
			printf("HOST FOUND!!!\n");fflush(stdout);
#endif
			ret = ix;
			break;
		}
	}
#if defined(DEBUG)
	printf("HOST NOT FOUND!!!\n");fflush(stdout);
#endif
	Unlock( "HostList::FindHostByAddress()" );
	return ret;
}

/**
 * ۥȤեźդ򥵥ݡȤƤ뤫
 * @retval true:ݡ
 * @retval false:ݡȤʤ
 */
bool
HostListItem::IsFileAttachSupport() const
{
	return CommandNo() & IPMSG_FILEATTACHOPT;
}

/**
 * ۥȤŹ򥵥ݡȤƤ뤫
 * @retval true:ݡ
 * @retval false:ݡȤʤ
 */
bool
HostListItem::IsEncryptSupport() const
{
	return CommandNo() & IPMSG_ENCRYPTOPT;
}

/**
 * ۥȤԺߤ
 * @retval true:Ժ
 * @retval false:ԺߤǤʤ
 */
bool
HostListItem::IsAbsence() const
{
	return CommandNo() & IPMSG_ABSENCEOPT;
}

/**
 * ۥȥꥹȥƥ४֥ȤʬȰפ뤫֤
 * @param item ۥȥꥹȥƥ
 * @retval true:
 * @retval false:פʤ
 */
bool
HostListItem::Equals( const HostListItem& item ) const
{
	return	Compare( item ) == 0;
}
/**
 * ӡ
 * @param item ۥȾ1
 * @retval -n:*this礭
 * @retval 0:item*this
 * @retval +n:item礭
 */
int
HostListItem::Compare( const HostListItem& item ) const
{
//	if ( item.UserName()  == UserName() &&
//		 item.HostName()  == HostName() &&
//		 item.IpAddress() == IpAddress() &&
//		 item.Nickname()  == Nickname() &&
//		 item.GroupName() == GroupName() &&
//		 item.PortNo()    == PortNo() {
	if ( item.UserName()  == UserName() &&
		 item.HostName()  == HostName() &&
		 item.IpAddress() == IpAddress() ){
		return 0;
	}
//	if ( item.UserName()  > UserName() &&
//		 item.HostName()  > HostName() &&
//		 item.IpAddress() > IpAddress() &&
//		 item.Nickname()  > Nickname() &&
//		 item.GroupName() > GroupName() &&
//		 item.PortNo()    > PortNo() {
	if ( item.UserName()  > UserName() &&
		 item.HostName()  > HostName() &&
		 item.IpAddress() > IpAddress() ){
		return 1;
	}
	return -1;
}

/**
 * ۥȥꥹȤӥ֥ȤΥȽ˱äƥȤޤ
 * @param comparator ӥ֥
 */
void
HostList::qsort( HostListComparator *comparator, int left, int right )
{
	//ϰϤγϡλ
	int i = left, j = right;
#if defined(INFO) || !defined(NDEBUG)
	printf("ADDRESS LEFT(%d)  =IpAddress=%s\n", left, (items.begin() + left)->IpAddress().c_str() );fflush(stdout);
	printf("ADDRESS RIGHT(%d) =IpAddress=%s\n", right, (items.begin() + right)->IpAddress().c_str() );fflush(stdout);
#endif
	//
	vector<HostListItem>::iterator pivot = items.begin() + ( ( left + right ) / 2 );
	//å
	while( true ){
		while( comparator->compare( items.begin() + i, pivot ) < 0 ) i++;
		while( comparator->compare( pivot, items.begin() + j ) < 0 ) j--;
		if ( i >= j ) break;
#if defined(INFO) || !defined(NDEBUG)
			printf("SWAP BEFORE I(%d)  =IpAddress=%s\n", i, (items.begin() + i)->IpAddress().c_str() );fflush(stdout);
			printf("SWAP BEFORE J(%d) =IpAddress=%s\n", j, (items.begin() + j)->IpAddress().c_str() );fflush(stdout);
#endif
		iter_swap( items.begin() + i, items.begin() + j );
#if defined(INFO) || !defined(NDEBUG)
		printf("SWAP BEFORE I(%d) =IpAddress=%s\n", i, (items.begin() + i)->IpAddress().c_str() );fflush(stdout);
		printf("SWAP BEFORE J(%d) =IpAddress=%s\n", j, (items.begin() + j)->IpAddress().c_str() );fflush(stdout);
#endif
		i++;
		j--;
	}
	if ( left < i - 1 ) {	//ͤκˣİʾǤк򥽡Ȥ롣
		qsort( comparator, left, i - 1 );
	}
	if ( j + 1 < right ) {	//ͤαˣİʾǤб򥽡Ȥ롣
		qsort( comparator, j + 1, right );
	}
}

/**
 * ۥȥꥹȤӥ֥ȤΥȽ˱äƥȤޤ
 * @param comparator ӥ֥
 */
void
HostList::sort( HostListComparator *comparator )
{
	if ( items.size() > 0 ) {
		qsort( comparator, 0, items.size() - 1 );
	}
}
//end of source
