/**
 * IP å󥸥饤֥(Unix)
 * IPå󥸥㥨ȥ饹
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "IpMessenger.h"
#include "IpMessengerImpl.h"

//NICκ
#define IFR_MAX 20

static IpMessengerAgent *myInstance = NULL;

static pthread_mutex_t instanceMutex;
static int mutex_init_result = IpMsgMutexInit( "IpMessenger::Global", &instanceMutex, NULL );

IpMessengerEvent::~IpMessengerEvent(){};
/**
 * IP å󥸥㥨ȥ饹Υ󥹥󥹤롣
 * <ul>
 * <li>SingletonѥѤƤΤǡۥͣΥ󥹥󥹤ǤʤФʤʤ</li>
 * </ul>
 */
IpMessengerAgent *
IpMessengerAgent::GetInstance()
{
	IpMsgMutexLock( "IpMessengerAgent::GetInstance()", &instanceMutex );
	if ( myInstance == NULL ) {
		myInstance = new IpMessengerAgent();
	}
	IpMsgMutexUnlock( "IpMessengerAgent::GetInstance()", &instanceMutex );
	return myInstance;
}

/**
 * IP å󥸥㥨ȥ饹Υ󥹥󥹤롣
 * <ul>
 * <li>Υ᥽åɤȤäƥ֥ȤʤФʤʤ</li>
 * <li>饤֥̤ʤľdelete줿ϤθưˤĤƴΤʤ</li>
 * </ul>
 */
void
IpMessengerAgent::Release()
{
	IpMsgMutexLock( "IpMessengerAgent::Release()", &instanceMutex );
	if ( myInstance == NULL ) {
		IpMsgMutexUnlock( "IpMessengerAgent::Release()", &instanceMutex );
		return;
	}
	delete myInstance;
	myInstance = NULL;
	IpMsgMutexUnlock( "IpMessengerAgent::Release()", &instanceMutex );
}

/**
 * IP å󥸥㥨ȥ饹Υ󥹥ȥ饯
 */
IpMessengerAgent::IpMessengerAgent()
{
	ipmsgImpl = IpMessengerAgentImpl::GetInstance();
}

/**
 * IP å󥸥㥨ȥ饹Υǥȥ饯
 */
IpMessengerAgent::~IpMessengerAgent()
{
	IpMessengerAgentImpl::Release();
}

/**
 * NICꤻIP å󥸥㥨ȥ饹Υͥåȥư롣
 * <ul>
 * <li>ƤNICФƥǥեȥݡȤǥͥåȥư롣</li>
 * </ul>
 */
void
IpMessengerAgent::StartNetwork()
{
	ipmsgImpl->StartNetwork();
}

/**
 * IP å󥸥㥨ȥ饹Υͥåȥư롣
 * @parem nics ưоݤȤNICΥ٥
 */
void
IpMessengerAgent::StartNetwork( const vector<NetworkInterface>& nics )
{
	ipmsgImpl->StartNetwork( nics );
}

/**
 * IP å󥸥㥨ȥ饹Υͥåȥߤ롣
 */
void
IpMessengerAgent::StopNetwork()
{
	ipmsgImpl->StopNetwork();
}

/**
 * NICꤻIP å󥸥㥨ȥ饹ΥͥåȥƵư롣
 * <ul>
 * <li>ƤNICФƥǥեȥݡȤǥͥåȥư롣</li>
 * </ul>
 */
void
IpMessengerAgent::RestartNetwork()
{
	ipmsgImpl->RestartNetwork();
}

/**
 * IP å󥸥㥨ȥ饹ΥͥåȥƵư롣
 * @parem nics ưоݤȤNICΥ٥
 */
void
IpMessengerAgent::RestartNetwork( const vector<NetworkInterface>& nics )
{
	ipmsgImpl->RestartNetwork( nics );
}

/**
 * ե̾СΥå
 * @retval СΥɥ쥹
 */
FileNameConverter *
IpMessengerAgent::GetFileNameConverter()
{
	return ipmsgImpl->GetFileNameConverter();
}

/**
 * ե̾СΥå
 * @param conv СΥɥ쥹ưŪ˺Τǡå˺ƤϤʤʤҡ׾˺뤳ȡ
 */
void
IpMessengerAgent::SetFileNameConverter( FileNameConverter *conv )
{
	ipmsgImpl->SetFileNameConverter( conv );
}

/**
 * ٥ȥ֥ȤΥå
 * @retval ٥ȥ֥ȤΥɥ쥹
 */
HostListComparator *
IpMessengerAgent::GetSortHostListComparator()
{
	return ipmsgImpl->GetSortHostListComparator();
}; 

/**
 * ۥȥꥹӥ֥ȤΥå
 * @param comparator ۥȥꥹӥ֥ȤΥɥ쥹ưŪ˺Τǡå˺ƤϤʤʤҡ׾˺뤳ȡ
 */
void
IpMessengerAgent::SetSortHostListComparator( HostListComparator *comparator )
{
	ipmsgImpl->SetSortHostListComparator( comparator );
}

/**
 * ٥ȥ֥ȤΥå
 * @retval ٥ȥ֥ȤΥɥ쥹
 */
IpMessengerEvent *
IpMessengerAgent::GetEventObject()
{
	return ipmsgImpl->GetEventObject();
}; 

/**
 * ٥ȥ֥ȤΥå
 * @param evt ٥ȥ֥ȤΥɥ쥹ưŪ˺Τǡå˺ƤϤʤʤҡ׾˺뤳ȡ
 */
void
IpMessengerAgent::SetEventObject( IpMessengerEvent *evt )
{
	ipmsgImpl->SetEventObject( evt );
}

/**
 * NICξ롣
 * @param nics ͥåȥ󥿡եΰ
 */
void
IpMessengerAgent::GetNetworkInterfaceInfo( vector<NetworkInterface>& nics )
{
	IpMessengerAgentImpl::GetNetworkInterfaceInfo( nics );
}

/**
 * ʥӥΡˡ
 */
void
IpMessengerAgent::Login( string nickname, string groupName )
{
	ipmsgImpl->Login( nickname, groupName );
}

/**
 * ȡʥӥæΡˡ
 */
void
IpMessengerAgent::Logout()
{	
	ipmsgImpl->Logout();
}

/**
 * ۥȥꥹȼ
 * @retval ȤݻƤHostList֥
 */
HostList&
IpMessengerAgent::GetHostList()
{
	return ipmsgImpl->GetHostList();
}

/**
 * ۥȥꥹȹ
 * @retval HostList֥
 */
HostList&
IpMessengerAgent::UpdateHostList()
{
	return ipmsgImpl->UpdateHostList();
}

/**
 * Ժߥ⡼ɤɤȽꡣ
 * @retval ѤԺߥ⡼ɤ֤
 */
bool
IpMessengerAgent::IsAbsence()
{
	return ipmsgImpl->IsAbsence();
}
/**
 * Ժߥ⡼ɤ򥯥ꥢ롣
 */
void
IpMessengerAgent::ResetAbsence()
{
	ipmsgImpl->ResetAbsence();
}

/**
 * Ժߥ⡼ɤꤹ롣
 * @param encoding 륨󥳡ǥ
 * @param absenceModes AbsenceMode֥ȤΥ٥ʼưʣ󥳡ǥб뤿
 */
void
IpMessengerAgent::SetAbsence( string encoding, vector<AbsenceMode> absenceModes )
{
	ipmsgImpl->SetAbsence( encoding, absenceModes );
}

/**
 * å
 * @param host ۥ
 * @param msg å
 * @param isSecret 񤫤ɤ򼨤ե饰
 * @param isLockPassword Ĥɤ򼨤ե饰
 * @param hostCountAtSameTime Ʊۥȿ
 * @param IsNoLogging ˻ĤʤʤȤ侩
 * @param opt ץ
 */
SentMessage
IpMessengerAgent::SendMsg( HostListItem host, string msg, bool isSecret, bool isLockPassword, int hostCountAtSameTime, bool IsNoLogging, unsigned long opt )
{
	return ipmsgImpl->SendMsg( host, msg, isSecret, isLockPassword, hostCountAtSameTime, IsNoLogging, opt );
}

/**
 * å
 * @param host ۥ
 * @param msg å
 * @param isSecret 񤫤ɤ򼨤ե饰
 * @param file źեե
 * @param isLockPassword Ĥɤ򼨤ե饰
 * @param hostCountAtSameTime Ʊۥȿ
 * @param IsNoLogging ˻ĤʤʤȤ侩
 * @param opt ץ
 */
SentMessage
IpMessengerAgent::SendMsg( HostListItem host, string msg, bool isSecret, AttachFile& file, bool isLockPassword, int hostCountAtSameTime, bool IsNoLogging, unsigned long opt )
{
	return ipmsgImpl->SendMsg( host, msg, isSecret, file, isLockPassword, hostCountAtSameTime, IsNoLogging, opt );
}

/**
 * å
 * @param host ۥ
 * @param msg å
 * @param isSecret 񤫤ɤ򼨤ե饰
 * @param files źեե뷲
 * @param isLockPassword Ĥɤ򼨤ե饰
 * @param hostCountAtSameTime Ʊۥȿ
 * @param IsNoLogging ˻ĤʤʤȤ侩
 * @param opt ץ
 */
SentMessage
IpMessengerAgent::SendMsg( HostListItem host, string msg, bool isSecret, AttachFileList& files, bool isLockPassword, int hostCountAtSameTime, bool IsNoLogging, unsigned long opt )
{
	return ipmsgImpl->SendMsg( host, msg, isSecret, files, isLockPassword, hostCountAtSameTime, IsNoLogging, opt );
}

/**
 * ϿѤΥ֥ɥ㥹ȥɥ쥹ƥꥢ
 */
void
IpMessengerAgent::ClearBroadcastAddress()
{
	ipmsgImpl->ClearBroadcastAddress();
}

/**
 * ϿѤΥ֥ɥ㥹ȥɥ쥹
 * @param addr ϿѤΥ֥ɥ㥹ȥɥ쥹
 */
void
IpMessengerAgent::DeleteBroadcastAddress( string addr )
{
	ipmsgImpl->DeleteBroadcastAddress( addr );
}

/**
 * ֥ɥ㥹ȥɥ쥹Ͽ
 * @param addr Ͽ֥ɥ㥹ȥɥ쥹
 */
void
IpMessengerAgent::AddBroadcastAddress( string addr )
{
	ipmsgImpl->AddBroadcastAddress( addr );
}

/**
 * оݥۥȤΥС
 * @param host оݤΥۥ
 * @retval оݥۥȤΥС
 */
string
IpMessengerAgent::GetInfo( HostListItem& host )
{
	return ipmsgImpl->GetInfo( host );
}

/**
 * оݥۥȤԺʸ
 * @param host оݤΥۥ
 * @retval оݥۥȤԺʸ
 */
string
IpMessengerAgent::GetAbsenceInfo( HostListItem& host )
{
	return ipmsgImpl->GetAbsenceInfo( host );
}

/**
 * ݻΥۥȥꥹȤ饰롼ץꥹȤ롣
 * @retval 롼ץꥹ
 */
vector<GroupItem>
IpMessengerAgent::GetGroupList()
{
	return ipmsgImpl->GetGroupList();
}

/**
 * ˥åȤΤ롣
 * @param msg å֥ȡ
 */
void
IpMessengerAgent::DeleteNotify( RecievedMessage msg )
{
	ipmsgImpl->DeleteNotify( msg );
}

/**
 * ˥åȤΤ롣
 * @param msg å֥ȡ
 */
void
IpMessengerAgent::ConfirmMessage( RecievedMessage &msg )
{
	ipmsgImpl->ConfirmMessage( msg );
}

/**
 * ѥåꥹȤ˳줿Ȥޡ롣
 * @param msg å֥ȡ
 */
void
IpMessengerAgent::AcceptConfirmNotify( SentMessage msg )
{
	ipmsgImpl->AcceptConfirmNotify( msg );
}
		
// private methods start here

/**
 * ʥ桼ˡ
 * Υ᥽åɤϥåɥդǤʤ
 */
int
IpMessengerAgent::Process()
{
	return ipmsgImpl->Process();
}

/**
 * åθĿ롣
 * @retval åθĿ
 */
int
IpMessengerAgent::GetRecievedMessageCount()
{
	return ipmsgImpl->GetRecievedMessageCount();
}

/**
 * åļФåꥹȤ롣
 * @retval å֥ȡ
 */
RecievedMessage
IpMessengerAgent::PopRecievedMessage()
{
	return ipmsgImpl->PopRecievedMessage();
}

/**
 * ѥåꥹȤΥݥ󥿤롣
 * @retval ѥåꥹȤΥݥ󥿡
 */
SentMessageList *
IpMessengerAgent::GetSentMessages()
{
	return ipmsgImpl->GetSentMessages();
}

/**
 * ѥåꥹȤΥԡ롣
 * @retval ѥåꥹȤΥԡ
 */
SentMessageList
IpMessengerAgent::CloneSentMessages()
{
	return ipmsgImpl->CloneSentMessages();
}

/**
 * ̾Υå
 * @retval ̾
 */
string
IpMessengerAgent::LoginName()
{
	return ipmsgImpl->LoginName();
}

/**
 * ۥ̾Υå
 * @retval ۥ̾
 */
string
IpMessengerAgent::HostName()
{
	return ipmsgImpl->HostName();
}

/**
 * 륢åפΥå
 * @retval 륢å
 */
bool
IpMessengerAgent::IsDialup()
{
	return ipmsgImpl->IsDialup();
}

/**
 * 륢åפΥå
 * @param isDialup 륢å
 */
void
IpMessengerAgent::setIsDialup( bool isDialup )
{
	ipmsgImpl->setIsDialup( isDialup );
}

/**
 * ɻ˥ե뤬ѹ줿˶ػߤ뤫ɤΥե饰Υå
 * @retval ɻ˥ե뤬ѹ줿˶ػߤ뤫ɤΥե饰
 */
bool
IpMessengerAgent::AbortDownloadAtFileChanged()
{
	return ipmsgImpl->AbortDownloadAtFileChanged();
}

/**
 * ɻ˥ե뤬ѹ줿˶ػߤ뤫ɤΥե饰Υå
 * @param isAbort ɻ˥ե뤬ѹ줿˶ػߤ뤫ɤΥե饰
 */
void
IpMessengerAgent::setAbortDownloadAtFileChanged( bool isAbort )
{
	ipmsgImpl->setAbortDownloadAtFileChanged( isAbort );
}

/**
 * å¸뤫ɤΥե饰Υå
 * @retval å¸뤫ɤΥե饰
 */
bool
IpMessengerAgent::SaveSentMessage()
{
	return ipmsgImpl->SaveSentMessage();
}

/**
 * å¸뤫ɤΥե饰Υå
 * @param isSave å¸뤫ɤΥե饰
 */
void
IpMessengerAgent::setSaveSentMessage( bool isSave )
{
	ipmsgImpl->setSaveSentMessage( isSave );
}

/**
 * å¸뤫ɤΥե饰Υå
 * @retval å¸뤫ɤΥե饰
 */
bool
IpMessengerAgent::SaveRecievedMessage()
{
	return ipmsgImpl->SaveRecievedMessage();
}

/**
 * å¸뤫ɤΥե饰Υå
 * @param isSave å¸뤫ɤΥե饰
 */
void
IpMessengerAgent::setSaveRecievedMessage( bool isSave )
{
	ipmsgImpl->setSaveRecievedMessage( isSave );
}

/**
 * ®٤򻻽Ф롣
 * @retval ®١ʥХȡáˡ
 */
long double
DownloadInfo::getSpeed()
{
	return Time() == 0 ? (long double)0 : ( ( long double )Size() / ( long double )Time() );
}

/**
 * ®ʸ롣
 * @retval ®ʸñ̡áˡ:1 B/sec, 2.00KB/sec, 3.00 MB/sec, 4.00 GB/sec, 5.00 TB/sec
 */
string
DownloadInfo::getSpeedString()
{
	return DownloadInfo::getUnitSizeString( ( long long )getSpeed() ) + "/sec";
}

/**
 * ʸ롣
 * @retval ʸñ̡ˡ:1 B, 2.00KB, 3.00 MB, 4.00 GB, 5.00 TB
 */
string
DownloadInfo::getSizeString()
{
	return DownloadInfo::getUnitSizeString( Size() );
}

#define IPMSG_SIZE_B	(long double)(1)
#define IPMSG_SIZE_KB	(long double)(1024 * IPMSG_SIZE_B)
#define IPMSG_SIZE_MB	(long double)(1024 * IPMSG_SIZE_KB)
#define IPMSG_SIZE_GB	(long double)(1024 * IPMSG_SIZE_MB)
#define IPMSG_SIZE_TB	(long double)(1024 * IPMSG_SIZE_GB)

/**
 * ʸ롣
 * @retval ʸñ̡ˡ:1 B, 2.00KB, 3.00 MB, 4.00 GB, 5.00 TB
 */
string
DownloadInfo::getUnitSizeString( long long size )
{
	long double dsize = (long double)size;
	char buf[100];
	if ( dsize >= IPMSG_SIZE_TB ) {
		snprintf( buf, sizeof( buf ), "%.2Lf TB", (dsize / IPMSG_SIZE_TB) );
		return buf;
	} else if ( dsize >= IPMSG_SIZE_GB ) {
		snprintf( buf, sizeof( buf ), "%.2Lf GB", (dsize / IPMSG_SIZE_GB) );
		return buf;
	} else if ( dsize >= IPMSG_SIZE_MB ) {
		snprintf( buf, sizeof( buf ), "%.2Lf MB", (dsize / IPMSG_SIZE_MB) );
		return buf;
	} else if ( dsize >= IPMSG_SIZE_KB ) {
		snprintf( buf, sizeof( buf ), "%.2Lf KB", (dsize / IPMSG_SIZE_KB) );
		return buf;
	}
	snprintf( buf, sizeof( buf ), "%lld B", size );
	return buf;
}
//end of source
