#ifndef _IPMESSENGER_H_
#define _IPMESSENGER_H_
#include <stdio.h>
#include <fcntl.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <netinet/in.h>
#include <net/if.h>
#include <dirent.h>
#include <netdb.h>
#include <utime.h>
#include <errno.h>

#ifdef HAVE_OPENSSL
#include <openssl/rsa.h>
#include <openssl/engine.h>
#include <openssl/err.h>
#include <openssl/blowfish.h>
#include <openssl/rc2.h>
#endif

#include <string>
#include <queue>
#include <map>
#include <vector>
using namespace std;

/**
 * ɤ߹ѥץѥƥ
 * IPMSG_READONLY_PROPERTY( SomeClass, PropName )
 * -------------------------------------------------------------------
 *   private: SomeClass _PropName;
 *   public: SomeClass& PropName(){ return _PropName; };
 * -------------------------------------------------------------------
 * Ÿޤ
 **/
#define IPMSG_READONLY_PROPERTY(t, name ) \
									private: \
										t _##name; \
									public: \
										inline t name() const { return _##name; };

/**
 * ɤ߽ξѥץѥƥ
 * IPMSG_PROPERTY( SomeClass, PropName )
 * -------------------------------------------------------------------
 *   private: SomeClass _PropName;
 *   public: SomeClass PropName(){ return _PropName; };
 *           void setPropName( SomeClass val ){ _PropName = val; };
 * -------------------------------------------------------------------
 * Ÿޤ
 **/
#define IPMSG_PROPERTY(t, name )	private: \
										t _##name; \
									public: \
										inline t name() const { return _##name; }; \
										inline void set##name( const t val ){ _##name = val; };

/**
 * ɤ߽ξѥץѥƥ()
 * IPMSG_PROPERTY_REF( SomeClass, PropName )
 * -------------------------------------------------------------------
 *   private: SomeClass _PropName;
 *   public: SomeClass& PropName(){ return _PropName; };
 *           void setPropName( SomeClass& val ){ _PropName = val; };
 * -------------------------------------------------------------------
 * Ÿޤ
 **/
#define IPMSG_PROPERTY_REF(t, name )	\
									private: \
										t _##name; \
									public: \
										inline t& name() { return _##name; }; \
										inline void set##name( const t& val ){ _##name = val; };
/**
 * ѥåȥ饹
 **/
class Packet{
	public:
		IPMSG_PROPERTY( unsigned long, VersionNo );
		IPMSG_PROPERTY( unsigned long, PacketNo );
		IPMSG_PROPERTY( unsigned long, CommandMode );
		IPMSG_PROPERTY( unsigned long, CommandOption );
		IPMSG_PROPERTY( time_t, Recieved );
		IPMSG_PROPERTY( string, HostName );
		IPMSG_PROPERTY( string, UserName );
		IPMSG_PROPERTY( string, Option );
		IPMSG_PROPERTY( struct sockaddr_in, Addr );
		IPMSG_PROPERTY( int, TcpSocket );
};

/**
 * ͥåȥ󥿡ե饹
 **/
class NetworkInterface {
	public:
		IPMSG_PROPERTY( string, DeviceName );
		IPMSG_PROPERTY( string, IpAddress );
		IPMSG_PROPERTY( string, NetMask );
		IPMSG_PROPERTY( string, NetworkAddress );
		IPMSG_PROPERTY( string, BroadcastAddress );
		IPMSG_PROPERTY( in_addr_t, NativeIpAddress );
		IPMSG_PROPERTY( in_addr_t, NativeNetMask );
		IPMSG_PROPERTY( in_addr_t, NativeNetworkAddress );
		IPMSG_PROPERTY( in_addr_t, NativeBroadcastAddress );
		IPMSG_PROPERTY( int, PortNo );
};

/**
 * 롼ץ饹
 **/
class GroupItem{
	public:
		IPMSG_PROPERTY( string, GroupName );
		IPMSG_PROPERTY( string, EncodingName );
};

/**
 * ۥȥ饹
 **/
class HostListItem{
	public:
		IPMSG_PROPERTY( string, Version );
		IPMSG_PROPERTY( string, AbsenceDescription );
		IPMSG_PROPERTY( string, UserName );
		IPMSG_PROPERTY( string, HostName );
		IPMSG_PROPERTY( unsigned long, CommandNo );
		IPMSG_PROPERTY( string, IpAddress );
		IPMSG_PROPERTY( string, Nickname );
		IPMSG_PROPERTY( string, GroupName );
		IPMSG_PROPERTY( string, EncodingName );
		IPMSG_PROPERTY( string, Priority );
		IPMSG_PROPERTY( unsigned long, PortNo );
		IPMSG_PROPERTY( unsigned long, EncryptionCapacity );
		IPMSG_PROPERTY( string, PubKeyHex );
		IPMSG_PROPERTY( string, EncryptMethodHex );
		bool IsLocalHost() const;
		bool IsFileAttachSupport() const;
		bool IsEncryptSupport() const;
		bool IsAbsence() const;
		bool Equals( const HostListItem& item ) const;
		int Compare( const HostListItem& item ) const;
		void QueryVersionInfo();
		void QueryAbsenceInfo();
};

/**
 * ۥȰӥ饹
 *ʳApplicationɬפ˱ƤΥ饹ѾƽƤ
 **/
class HostListComparator{
	public:
		/**
		 * ӡ
		 * @param host1 ۥȾ1
		 * @param host2 ۥȾ2
		 * @retval -n:host1礭
		 * @retval 0:host1host2
		 * @retval +n:host2礭
		 */
		virtual int compare( vector<HostListItem>::iterator host1, vector<HostListItem>::iterator host2 )=0;
};

/**
 * ۥȰǥեȥӥ饹
 **/
class HostListDefaultComparator: public HostListComparator{
	public:
		/**
		 * ӡ
		 * @param host1 ۥȾ1
		 * @param host2 ۥȾ2
		 * @retval -n:host1礭
		 * @retval 0:host1host2
		 * @retval +n:host2礭
		 */
		virtual int compare( vector<HostListItem>::iterator host1, vector<HostListItem>::iterator host2 ){
			return host1->Compare( *host2 );
		};
};

/**
 * ۥȰ饹
 **/
class HostList{
	public:
		IPMSG_PROPERTY( bool, IsAsking );
		IPMSG_PROPERTY( time_t, AskStartTime );
		IPMSG_PROPERTY( time_t, PrevTry );
		IPMSG_PROPERTY( int, RetryCount );
		void AddHost( const HostListItem& host );
		void Delete( vector<HostListItem>::iterator &it );
		void DeleteHost( string hostname );
		vector<HostListItem>::iterator FindHostByAddress( string addr );
		vector<HostListItem>::iterator FindHostByHostName( string hostName );
		static HostListItem CreateHostListItemFromPacket( const Packet& packet );
		vector<HostListItem>::iterator begin();
		vector<HostListItem>::iterator end();
		int size() const;
		void clear();
		string ToString( int start, const struct sockaddr_in *addr );
		void sort( HostListComparator *comparator );
		HostList();
		HostList( const HostList& other );
		~HostList();
		HostList& operator=( const HostList& other );
	private:
		void qsort( HostListComparator *comparator, int left, int right );
		void Lock( const char *pos ) const;
		void Unlock( const char *pos ) const;
		void CopyFrom( const HostList& other );
		vector<HostListItem>items;
		pthread_mutex_t hostListMutex;
};

/**
 * ե̾С饹
 * ʳApplicationɬפ˱ƤΥ饹ѾƽƤ
 **/
class FileNameConverter {
	public:
		virtual string ConvertNetworkToLocal( string original_file_name ) = 0;
		virtual string ConvertLocalToNetwork( string original_file_name ) = 0;
};

/**
 * ե̵̾ѴС饹
 **/
class NullFileNameConverter:public FileNameConverter {
	public:
		virtual string ConvertNetworkToLocal( string original_file_name ){ return original_file_name; };
		virtual string ConvertLocalToNetwork( string original_file_name ){ return original_file_name; };
};

/**
 * źեե륯饹
 **/
class AttachFile{
	public:
		map<string, vector<unsigned long> >::iterator beginExtAttrs() { return _ExtAttrs.begin(); };
		map<string, vector<unsigned long> >::iterator endExtAttrs() { return _ExtAttrs.end(); };
		void addExtAttrs( string key, unsigned long val ){ _ExtAttrs[key].push_back( val ); };
		IPMSG_PROPERTY( int, FileId );
		IPMSG_PROPERTY( string, FullPath );
		IPMSG_PROPERTY( string, FileName );
		IPMSG_PROPERTY( string, Location );
		IPMSG_PROPERTY( long long, FileSize );
		IPMSG_PROPERTY( long long, TransSize );
		IPMSG_PROPERTY( bool, IsDownloaded );
		IPMSG_PROPERTY( bool, IsDownloading );
		IPMSG_PROPERTY( time_t, MTime );
		IPMSG_PROPERTY( unsigned long, Attr );

		AttachFile();
		bool IsRegularFile() const;
		bool IsDirectory() const;
		void GetLocalFileInfo();
	private:
		map<string, vector<unsigned long> > _ExtAttrs;
	public:
		static AttachFile AnalyzeHeader( char *buf, FileNameConverter *conv );
		static string CreateDirFullPath( const vector<string>& dirstack );
};

/**
 * ɾ󥯥饹
 **/
class DownloadInfo{
	public:
		IPMSG_PROPERTY( unsigned long long, Size );
		IPMSG_PROPERTY( time_t, Time );
		IPMSG_PROPERTY( long, FileCount );
		IPMSG_PROPERTY( bool, Processing );
		IPMSG_PROPERTY( string, LocalFileName );
		IPMSG_PROPERTY_REF( AttachFile, File );

		DownloadInfo():_Size( 0ULL ), _Time( 0 ), _FileCount( 0L ), _LocalFileName(""){};
		long double getSpeed();
		string getSpeedString();
		string getSizeString();
		static string getUnitSizeString( long long size );
};

/**
 * źեե饹
 **/
class AttachFileList{
	public:
		void AddFile( const AttachFile& file );
		vector<AttachFile>::iterator begin();
		vector<AttachFile>::iterator end();
		int size() const;
		void clear();
		vector<AttachFile>::iterator erase( vector<AttachFile>::iterator item );
		vector<AttachFile>::iterator erase( const AttachFile& item );
		vector<AttachFile>::iterator FindByFullPath( const string& fullPath );
		vector<AttachFile>::iterator FindByFileId( int file_id );
		AttachFileList();
		AttachFileList( const AttachFileList& other );
		~AttachFileList();
		AttachFileList& operator=( const AttachFileList& other );
	private:
		void Lock( const char *pos ) const;
		void Unlock( const char *pos ) const;
		void CopyFrom( const AttachFileList& other );
		vector<AttachFile> files;
		pthread_mutex_t filesMutex;
};

class IpMessengerEvent;

/**
 * å饹
 **/
class RecievedMessage{
	public:
		IPMSG_PROPERTY( Packet, MessagePacket );
		IPMSG_PROPERTY( string, Message );
		IPMSG_PROPERTY( time_t, Recieved );
		IPMSG_PROPERTY( bool, IsConfirmed );
		IPMSG_PROPERTY( bool, IsSecret );
		IPMSG_PROPERTY( bool, IsNoLogging );
		IPMSG_PROPERTY( bool, IsCrypted );
		IPMSG_PROPERTY( HostListItem, Host );
		IPMSG_PROPERTY( bool, IsPasswordLock );
		IPMSG_PROPERTY( bool, IsBroadcast );
		IPMSG_PROPERTY( bool, IsMulticast );
		IPMSG_PROPERTY( bool, HasAttachFile );
		IPMSG_PROPERTY_REF( AttachFileList, Files );
		RecievedMessage();
		RecievedMessage( const RecievedMessage& other );
		RecievedMessage& operator=( const RecievedMessage& other );
		bool DownloadFile( AttachFile &file, string saveFileNameFullPath, DownloadInfo& info, FileNameConverter *conv=NULL, void *data=NULL );
		bool DownloadDir( AttachFile &file, string saveDirName, string saveBaseDir, DownloadInfo& info, FileNameConverter *conv=NULL, void *data=NULL );
	private:
		void CopyFrom( const RecievedMessage& other );
		bool DownloadFilePrivate( IpMessengerEvent *event, AttachFile &file, string saveFileNameFullPath, DownloadInfo& info, FileNameConverter *conv=NULL, void *data=NULL );
		bool DownloadDirPrivate( IpMessengerEvent *event, AttachFile &file, string saveDirName, string saveBaseDir, DownloadInfo& info, FileNameConverter *conv=NULL, void *data=NULL );
		string GetFormalDir( string dirName );
		string GetSaveDir( string saveName, string saveBaseDir );
};

/**
 * å饹
 **/
class RecievedMessageList {
	public:
		vector<RecievedMessage>::iterator begin();
		vector<RecievedMessage>::iterator end();
		vector<RecievedMessage>::iterator erase( vector<RecievedMessage>::iterator item );
		void append( const RecievedMessage &item );
		int size() const;
		void clear();
		RecievedMessageList();
		RecievedMessageList( const RecievedMessageList& other );
		~RecievedMessageList();
		RecievedMessageList& operator=( const RecievedMessageList& other );
	private:
		void Lock( const char *pos ) const;
		void Unlock( const char *pos ) const;
		void CopyFrom( const RecievedMessageList& other );
		vector<RecievedMessage> messages;
		pthread_mutex_t messagesMutex;
};

/**
 * å饹
 **/
class SentMessage{
	public:
		IPMSG_PROPERTY( struct sockaddr_in, To );
		IPMSG_PROPERTY( HostListItem, Host );
		IPMSG_PROPERTY( unsigned long, PacketNo );
		IPMSG_PROPERTY( string, Message );
		IPMSG_PROPERTY( time_t, Sent );
		IPMSG_PROPERTY( time_t, PrevTry );
		IPMSG_PROPERTY( bool, IsRetryMaxOver );
		IPMSG_PROPERTY( bool, IsSent );
		IPMSG_PROPERTY( bool, IsPasswordLock );
		IPMSG_PROPERTY( bool, IsCrypted );
		IPMSG_PROPERTY( int, RetryCount );
		IPMSG_PROPERTY( bool, IsConfirmed );
		IPMSG_PROPERTY( bool, IsConfirmAnswered );
		IPMSG_PROPERTY( bool, IsSecret );
		IPMSG_PROPERTY( bool, IsNoLogging );
		IPMSG_PROPERTY( int, HostCountAtSameTime );
		IPMSG_PROPERTY( unsigned long, Opt );
		IPMSG_PROPERTY_REF( AttachFileList, Files );
		SentMessage();
		SentMessage( const SentMessage& other );
		SentMessage& operator=( const SentMessage& other );
		bool isRetryMaxOver() const;
		bool needSendRetry( time_t tryNow ) const;
		vector<AttachFile>::iterator FindAttachFileByPacket( const Packet &packet );
	private:
		void CopyFrom( const SentMessage& other );
};

/**
 * å饹
 **/
class SentMessageList {
	public:
		vector<SentMessage>::iterator begin();
		vector<SentMessage>::iterator end();
		vector<SentMessage>::iterator erase( vector<SentMessage>::iterator item );
		vector<SentMessage>::iterator FindSentMessageByPacketNo( unsigned long PacketNo );
		vector<SentMessage>::iterator FindSentMessageByPacket( Packet packet );
		void append( const SentMessage &item );
		int size() const;
		void clear();
		vector<SentMessage> *GetMessageList();
		SentMessageList();
		SentMessageList( const SentMessageList& other );
		~SentMessageList();
		SentMessageList& operator=( const SentMessageList& other );

	private:
		void Lock( const char *pos ) const;
		void Unlock( const char *pos ) const;
		void CopyFrom( const SentMessageList& other );
		vector<SentMessage> messages;
		pthread_mutex_t messagesMutex;
};

/**
 * Ժߥ⡼ɥ饹
 **/
class AbsenceMode {
	public:
		IPMSG_PROPERTY( string, EncodingName );
		IPMSG_PROPERTY( string, AbsenceName );
		IPMSG_PROPERTY( string, AbsenceDescription );
};


/**
 * IP Messenger ٥ȥ饹
 * ʳApplicationϤΥ饹ѾƽƤ
 **/
class IpMessengerEvent {
	public:
		/**
		 * ۥȥꥹȹ奤٥
		 * @param hostList ۥȥꥹ
		 */
		virtual void UpdateHostListAfter( HostList& hostList )=0;
		/**
		 * ۥȥꥹȼȥ饤顼٥
		 * @retval true:ȥ饤
		 * @retval false:ȥ饤ʤ
		 */
		virtual bool GetHostListRetryError()=0;
		/**
		 * å奤٥ȡ
		 * @param msg å
		 * @retval true:ƥå¸
		 * @retval false:å¸
		 */
		virtual bool RecieveAfter( RecievedMessage& msg )=0;
		/**
		 * å奤٥
		 * @param msg å
		 */
		virtual void SendAfter( SentMessage& msg )=0;
		/**
		 * åȥ饤顼٥
		 * @param msg å
		 * @retval true:ȥ饤
		 * @retval false:ȥ饤ʤ
		 */
		virtual bool SendRetryError( SentMessage& msg )=0;
		/**
		 * θ奤٥
		 * @param msg å
		 */
		virtual void OpenAfter( SentMessage& msg )=0;
		/**
		 * ɳϥ٥
		 * @param msg å
		 * @param file źեե
		 * @param info ɾ
		 * @param data DownloadFileDownloadDirǻꤷǤեǡؤΥݥ
		 */
		virtual void DownloadStart( RecievedMessage& msg, AttachFile& file, DownloadInfo &info, void *data )=0;
		/**
		 * ɽ楤٥
		 * @param msg å
		 * @param file źեե
		 * @param info ɾ
		 * @param data DownloadFileDownloadDirǻꤷǤեǡؤΥݥ
		 */
		virtual void DownloadProcessing( RecievedMessage& msg, AttachFile& file, DownloadInfo &info, void *data )=0;
		/**
		 * ɽλ٥
		 * @param msg å
		 * @param file źեե
		 * @param info ɾ
		 * @param data DownloadFileDownloadDirǻꤷǤեǡؤΥݥ
		 */
		virtual void DownloadEnd( RecievedMessage& msg, AttachFile& file, DownloadInfo &info, void *data )=0;
		/**
		 * ɥ顼٥(ȥ饤TRUE֤)
		 * @param msg å
		 * @param file źեե
		 * @param info ɾ
		 * @param data DownloadFileDownloadDirǻꤷǤեǡؤΥݥ
		 * @retval true:ȥ饤
		 * @retval false:ȥ饤ʤ
		 */
		virtual bool DownloadError( RecievedMessage& msg, AttachFile& file, DownloadInfo &info, void *data )=0;
		/**
		 * ۥȤλθ奤٥
		 * @param hostList ۥȥꥹ
		 */
		virtual void EntryAfter( HostList& hostList )=0;
		/**
		 * ۥȤæθ奤٥
		 * @param hostList ۥȥꥹ
		 */
		virtual void ExitAfter( HostList& hostList )=0;
		/**
		 * Ժߥ⡼ɹ奤٥
		 * @param hostList ۥȥꥹ
		 */
		virtual void AbsenceModeChangeAfter( HostList& hostList )=0;
		/**
		 * С奤٥
		 * @param host ۥ
		 * @param version С
		 */
		virtual void VersionInfoRecieveAfter( HostListItem &host, string version )=0;
		/**
		 * Ժ߾ܺپ奤٥
		 * @param host ۥ
		 * @param absenceDetail Ժ߾ܺپ
		 */
		virtual void AbsenceDetailRecieveAfter( HostListItem& host, string absenceDetail )=0;
		/**
		 * ǥȥ饯
		 */
		virtual ~IpMessengerEvent()=0;
};

class IpMessengerAgentImpl;

/**
 * IP Messenger ȥ饹
 **/
class IpMessengerAgent {
	public:
		/**
		 * 󥹥󥹤
		 **/
		static IpMessengerAgent *GetInstance();

		/**
		 * 󥹥󥹤
		 **/
		static void Release();

		/**
		 * NICξ
		 **/
		static void GetNetworkInterfaceInfo( vector<NetworkInterface>& nics );

		/**
		 * ֥ɥ㥹ȥɥ쥹ΥꥹȤ򥯥ꥢ
		 **/
		void ClearBroadcastAddress();

		/**
		 * ֥ɥ㥹ȥɥ쥹ΥꥹȤ饢ɥ쥹
		 **/
		void DeleteBroadcastAddress( string addr );

		/**
		 * ֥ɥ㥹ȥɥ쥹ΥꥹȤ˥ɥ쥹ɲ
		 **/
		void AddBroadcastAddress( string addr );

		/**
		 * ΡʻΡ
		 **/
		void Login( string nickname, string groupName );

		/**
		 * ΡæΡ
		 **/
		void Logout();

		/**
		 * ۥȥꥹȤ
		 **/
		HostList& GetHostList();

		/**
		 * ۥȥꥹȤ򹹿Ƽ
		 **/
		HostList& UpdateHostList();

		/**
		 * åź̵
		 **/
		SentMessage SendMsg( HostListItem host, string msg, bool isSecret, bool isLockPassword=false, int hostCountAtSameTime=1, bool IsNoLogging=false, unsigned long opt=0UL );

		/**
		 * åʰźա
		 **/
		SentMessage SendMsg( HostListItem host, string msg, bool isSecret, AttachFile& file, bool isLockPassword=false, int hostCountAtSameTime=1, bool IsNoLogging=false, unsigned long opt=0UL );

		/**
		 * åʣźա
		 **/
		SentMessage SendMsg( HostListItem host, string msg, bool isSecret, AttachFileList& files, bool isLockPassword=false, int hostCountAtSameTime=1, bool IsNoLogging=false, unsigned long opt=0UL );

		/**
		 * Ժ߲
		 **/
		void ResetAbsence();

		/**
		 * Ժ
		 **/
		void SetAbsence( string encoding, vector<AbsenceMode> absenceModes );

		/**
		 * 롼װ
		 **/
		vector<GroupItem> GetGroupList();

		/**
		 * С
		 **/
		string GetInfo( HostListItem& host );

		/**
		 * Ժ߾
		 **/
		string GetAbsenceInfo( HostListItem& host );

		/**
		 * ѥåȤνʥݡѡ
		 **/
		int Process();

		/**
		 * ѥåθĿ
		 **/
		int GetRecievedMessageCount();

		/**
		 * åμФ
		 **/
		RecievedMessage PopRecievedMessage();

		/**
		 * ˳Τ
		 **/
		void ConfirmMessage( RecievedMessage &msg );

		/**
		 * ˥åѴˤ
		 **/
		void DeleteNotify( RecievedMessage msg );

		/**
		 * ѥå˳ѤǤ뤳Ȥޡ
		 **/
		void AcceptConfirmNotify( SentMessage msg );

		/**
		 * åꥹȤμ
		 **/
		SentMessageList *GetSentMessages();

		/**
		 * åꥹȤΥԡμ
		 **/
		SentMessageList CloneSentMessages();

		/**
		 * ۥȥꥹӥ֥Ȥ
		 **/
		void SetSortHostListComparator( HostListComparator *comparator );

		/**
		 * ۥȥꥹӥ֥Ȥμ
		 **/
		HostListComparator *GetSortHostListComparator();

		/**
		 * ٥ȥ֥Ȥ
		 **/
		void SetEventObject( IpMessengerEvent *evt );

		/**
		 * ٥ȥ֥Ȥμ
		 **/
		IpMessengerEvent *GetEventObject();

		/**
		 * ե륳С
		 **/
		void SetFileNameConverter( FileNameConverter *conv );

		/**
		 * ե륳Сμ
		 **/
		FileNameConverter *GetFileNameConverter();

		/**
		 * Ժߡ
		 **/
		bool IsAbsence();

		/**
		 * ͥåȥεưNIC
		 **/
		void StartNetwork( const vector<NetworkInterface>& nics );

		/**
		 * ͥåȥεư(ǥե)
		 **/
		void StartNetwork();

		/**
		 * ͥåȥνλ
		 **/
		void StopNetwork();

		/**
		 * ͥåȥκƵưNIC
		 **/
		void RestartNetwork( const vector<NetworkInterface>& nics );

		/**
		 * ͥåȥκƵư(ǥե)
		 **/
		void RestartNetwork();

		/**
		 * ̾
		 **/
		string LoginName();

		/**
		 * ۥ̾
		 **/
		string HostName();

		/**
		 * 륢å
		 **/
		bool IsDialup();
		void setIsDialup( bool isDialup );

		/**
		 * ե뤬ѹ줿ɤǤ
		 **/
		bool AbortDownloadAtFileChanged();
		void setAbortDownloadAtFileChanged( bool isAbort );
		/* ߴΰ(0.1.0) */
		bool GetAbortDownloadAtFileChanged(){ return AbortDownloadAtFileChanged(); };
		void SetAbortDownloadAtFileChanged( bool isAbort ){ setAbortDownloadAtFileChanged( isAbort ); };

		/**
		 * å򵭲
		 **/
		bool SaveSentMessage();
		void setSaveSentMessage( bool isSave );

		/**
		 * å򵭲
		 **/
		bool SaveRecievedMessage();
		void setSaveRecievedMessage( bool isSave );

	private:
		IpMessengerAgent();
		~IpMessengerAgent();
		IpMessengerAgentImpl *ipmsgImpl;
};

#endif
