/**
 * IP å󥸥饤֥(Unix)
 * IPå󥸥㥨ȥ饹
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "IpMessenger.h"
#include "IpMessengerImpl.h"

using namespace ipmsg;

//NICκ
#define IFR_MAX 20

static IpMessengerAgent *myInstance = NULL;

static pthread_mutex_t instanceMutex;
static int mutex_init_result = IpMsgMutexInit( "IpMessenger::Global", &instanceMutex, NULL );

IpMessengerEvent::~IpMessengerEvent(){};
/**
 * IP å󥸥㥨ȥ饹Υ󥹥󥹤롣
 * <ul>
 * <li>SingletonѥѤƤΤǡۥͣΥ󥹥󥹤ǤʤФʤʤ</li>
 * </ul>
 */
IpMessengerAgent *
IpMessengerAgent::GetInstance()
{
	IpMsgMutexLock( "IpMessengerAgent::GetInstance()", &instanceMutex );
	if ( myInstance == NULL ) {
		myInstance = new IpMessengerAgent();
	}
	IpMsgMutexUnlock( "IpMessengerAgent::GetInstance()", &instanceMutex );
	return myInstance;
}

/**
 * IP å󥸥㥨ȥ饹Υ󥹥󥹤롣
 * <ul>
 * <li>Υ᥽åɤȤäƥ֥ȤʤФʤʤ</li>
 * <li>饤֥̤ʤľdelete줿ϤθưˤĤƴΤʤ</li>
 * </ul>
 */
void
IpMessengerAgent::Release()
{
	IpMsgMutexLock( "IpMessengerAgent::Release()", &instanceMutex );
	if ( myInstance == NULL ) {
		IpMsgMutexUnlock( "IpMessengerAgent::Release()", &instanceMutex );
		return;
	}
	delete myInstance;
	myInstance = NULL;
	IpMsgMutexUnlock( "IpMessengerAgent::Release()", &instanceMutex );
}

/**
 * IP å󥸥㥨ȥ饹Υ󥹥ȥ饯
 */
IpMessengerAgent::IpMessengerAgent()
{
	ipmsgImpl = IpMessengerAgentImpl::GetInstance();
}

/**
 * IP å󥸥㥨ȥ饹Υǥȥ饯
 */
IpMessengerAgent::~IpMessengerAgent()
{
	IpMessengerAgentImpl::Release();
}

/**
 * NICꤻIP å󥸥㥨ȥ饹Υͥåȥư롣
 * <ul>
 * <li>ƤNICФƥǥեȥݡȤǥͥåȥư롣</li>
 * </ul>
 */
void
IpMessengerAgent::StartNetwork()
{
	ipmsgImpl->StartNetwork();
}

/**
 * IP å󥸥㥨ȥ饹Υͥåȥư롣
 * @parem nics ưоݤȤNICΥ٥
 */
void
IpMessengerAgent::StartNetwork( const std::vector<NetworkInterface>& nics )
{
	ipmsgImpl->StartNetwork( nics );
}

/**
 * IP å󥸥㥨ȥ饹Υͥåȥߤ롣
 */
void
IpMessengerAgent::StopNetwork()
{
	ipmsgImpl->StopNetwork();
}

/**
 * NICꤻIP å󥸥㥨ȥ饹ΥͥåȥƵư롣
 * <ul>
 * <li>ƤNICФƥǥեȥݡȤǥͥåȥư롣</li>
 * </ul>
 */
void
IpMessengerAgent::RestartNetwork()
{
	ipmsgImpl->RestartNetwork();
}

/**
 * IP å󥸥㥨ȥ饹ΥͥåȥƵư롣
 * @parem nics ưоݤȤNICΥ٥
 */
void
IpMessengerAgent::RestartNetwork( const std::vector<NetworkInterface>& nics )
{
	ipmsgImpl->RestartNetwork( nics );
}

/**
 * ե̾СΥå
 * @retval СΥɥ쥹
 */
FileNameConverter *
IpMessengerAgent::GetFileNameConverter() const
{
	return ipmsgImpl->GetFileNameConverter();
}

/**
 * ե̾СΥå
 * @param conv СΥɥ쥹ưŪ˺Τǡå˺ƤϤʤʤҡ׾˺뤳ȡ
 */
void
IpMessengerAgent::SetFileNameConverter( const FileNameConverter *conv )
{
	ipmsgImpl->SetFileNameConverter( conv );
}

/**
 * ٥ȥ֥ȤΥå
 * @retval ٥ȥ֥ȤΥɥ쥹
 */
HostListComparator *
IpMessengerAgent::GetSortHostListComparator() const
{
	return ipmsgImpl->GetSortHostListComparator();
}; 

/**
 * ۥȥꥹӥ֥ȤΥå
 * @param comparator ۥȥꥹӥ֥ȤΥɥ쥹ưŪ˺Τǡå˺ƤϤʤʤҡ׾˺뤳ȡ
 */
void
IpMessengerAgent::SetSortHostListComparator( const HostListComparator *comparator )
{
	ipmsgImpl->SetSortHostListComparator( comparator );
}

/**
 * ٥ȥ֥ȤΥå
 * @retval ٥ȥ֥ȤΥɥ쥹
 */
IpMessengerEvent *
IpMessengerAgent::GetEventObject() const
{
	return ipmsgImpl->GetEventObject();
}; 

/**
 * ٥ȥ֥ȤΥå
 * @param evt ٥ȥ֥ȤΥɥ쥹ưŪ˺Τǡå˺ƤϤʤʤҡ׾˺뤳ȡ
 */
void
IpMessengerAgent::SetEventObject( const IpMessengerEvent *evt )
{
	ipmsgImpl->SetEventObject( evt );
}

/**
 * NICξ롣
 * @param nics ͥåȥ󥿡եΰ
 */
void
IpMessengerAgent::GetNetworkInterfaceInfo( std::vector<NetworkInterface>& nics )
{
	IpMessengerAgentImpl::GetNetworkInterfaceInfo( nics );
}

/**
 * ʥӥΡˡ
 */
void
IpMessengerAgent::Login( std::string nickname, std::string groupName )
{
	ipmsgImpl->Login( nickname, groupName );
}

/**
 * ȡʥӥæΡˡ
 */
void
IpMessengerAgent::Logout()
{	
	ipmsgImpl->Logout();
}

/**
 * ۥȥꥹȼ
 * @retval ȤݻƤHostList֥
 */
HostList&
IpMessengerAgent::GetHostList()
{
	return ipmsgImpl->GetHostList();
}

/**
 * ۥȥꥹȹ
 * @retval HostList֥
 */
HostList&
IpMessengerAgent::UpdateHostList()
{
	return ipmsgImpl->UpdateHostList();
}

/**
 * Ժߥ⡼ɤɤȽꡣ
 * @retval ѤԺߥ⡼ɤ֤
 */
bool
IpMessengerAgent::IsAbsence() const
{
	return ipmsgImpl->IsAbsence();
}
/**
 * Ժߥ⡼ɤ򥯥ꥢ롣
 */
void
IpMessengerAgent::ResetAbsence()
{
	ipmsgImpl->ResetAbsence();
}

/**
 * Ժߥ⡼ɤꤹ롣
 * @param encoding 륨󥳡ǥ
 * @param absenceModes AbsenceMode֥ȤΥ٥ʼưʣ󥳡ǥб뤿
 */
void
IpMessengerAgent::SetAbsence( std::string encoding, std::vector<AbsenceMode> absenceModes )
{
	ipmsgImpl->SetAbsence( encoding, absenceModes );
}

/**
 * å
 * @param host ۥ
 * @param msg å
 * @param isSecret 񤫤ɤ򼨤ե饰
 * @param isLockPassword Ĥɤ򼨤ե饰
 * @param hostCountAtSameTime Ʊۥȿ
 * @param IsNoLogging ˻ĤʤʤȤ侩
 * @param opt ץ
 */
bool
IpMessengerAgent::SendMsg( HostListItem host, std::string msg, bool isSecret, bool isLockPassword, int hostCountAtSameTime, bool IsNoLogging, unsigned long opt )
{
	return ipmsgImpl->SendMsg( host, msg, isSecret, isLockPassword, hostCountAtSameTime, IsNoLogging, opt );
}

/**
 * å
 * @param host ۥ
 * @param msg å
 * @param isSecret 񤫤ɤ򼨤ե饰
 * @param file źեե
 * @param isLockPassword Ĥɤ򼨤ե饰
 * @param hostCountAtSameTime Ʊۥȿ
 * @param IsNoLogging ˻ĤʤʤȤ侩
 * @param opt ץ
 */
bool
IpMessengerAgent::SendMsg( HostListItem host, std::string msg, bool isSecret, AttachFile& file, bool isLockPassword, int hostCountAtSameTime, bool IsNoLogging, unsigned long opt )
{
	return ipmsgImpl->SendMsg( host, msg, isSecret, file, isLockPassword, hostCountAtSameTime, IsNoLogging, opt );
}

/**
 * å
 * @param host ۥ
 * @param msg å
 * @param isSecret 񤫤ɤ򼨤ե饰
 * @param files źեե뷲
 * @param isLockPassword Ĥɤ򼨤ե饰
 * @param hostCountAtSameTime Ʊۥȿ
 * @param IsNoLogging ˻ĤʤʤȤ侩
 * @param opt ץ
 */
bool
IpMessengerAgent::SendMsg( HostListItem host, std::string msg, bool isSecret, AttachFileList& files, bool isLockPassword, int hostCountAtSameTime, bool IsNoLogging, unsigned long opt )
{
	return ipmsgImpl->SendMsg( host, msg, isSecret, files, isLockPassword, hostCountAtSameTime, IsNoLogging, opt );
}

/**
 * ϿѤΥ֥ɥ㥹ȥɥ쥹ƥꥢ
 */
void
IpMessengerAgent::ClearBroadcastAddress()
{
	ipmsgImpl->ClearBroadcastAddress();
}

/**
 * ϿѤΥ֥ɥ㥹ȥɥ쥹
 * @param addr ϿѤΥ֥ɥ㥹ȥɥ쥹
 */
void
IpMessengerAgent::DeleteBroadcastAddress( std::string addr )
{
	ipmsgImpl->DeleteBroadcastAddress( addr );
}

/**
 * ֥ɥ㥹ȥɥ쥹Ͽ
 * @param addr Ͽ֥ɥ㥹ȥɥ쥹
 */
void
IpMessengerAgent::AddBroadcastAddress( std::string addr )
{
	ipmsgImpl->AddBroadcastAddress( addr );
}

/**
 * оݥۥȤΥС
 * @param host оݤΥۥ
 * @retval оݥۥȤΥС
 */
std::string
IpMessengerAgent::GetInfo( HostListItem& host )
{
	return ipmsgImpl->GetInfo( host );
}

/**
 * оݥۥȤԺʸ
 * @param host оݤΥۥ
 * @retval оݥۥȤԺʸ
 */
std::string
IpMessengerAgent::GetAbsenceInfo( HostListItem& host )
{
	return ipmsgImpl->GetAbsenceInfo( host );
}

/**
 * ݻΥۥȥꥹȤ饰롼ץꥹȤ롣
 * @retval 롼ץꥹ
 */
std::vector<GroupItem>
IpMessengerAgent::GetGroupList()
{
	return ipmsgImpl->GetGroupList();
}

/**
 * ˥åȤΤ롣
 * @param msg å֥ȡ
 */
void
IpMessengerAgent::DeleteNotify( RecievedMessage msg )
{
	ipmsgImpl->DeleteNotify( msg );
}

/**
 * ˥åȤΤ롣
 * @param msg å֥ȡ
 */
void
IpMessengerAgent::ConfirmMessage( RecievedMessage &msg )
{
	ipmsgImpl->ConfirmMessage( msg );
}

/**
 * ѥåꥹȤ˳줿Ȥޡ롣
 * @param msg å֥ȡ
 */
void
IpMessengerAgent::AcceptConfirmNotify( SentMessage msg )
{
	ipmsgImpl->AcceptConfirmNotify( msg );
}
		
// private methods start here

/**
 * ʥ桼ˡ
 * Υ᥽åɤϥåɥդǤʤ
 */
int
IpMessengerAgent::Process()
{
	return ipmsgImpl->Process();
}

/**
 * åθĿ롣
 * @retval åθĿ
 */
int
IpMessengerAgent::GetRecievedMessageCount()
{
	return ipmsgImpl->GetRecievedMessageCount();
}

/**
 * åļФåꥹȤ롣
 * @retval å֥ȡ
 */
RecievedMessage
IpMessengerAgent::PopRecievedMessage()
{
	return ipmsgImpl->PopRecievedMessage();
}

/**
 * ѥåꥹȤΥݥ󥿤롣
 * @retval ѥåꥹȤΥݥ󥿡
 */
SentMessageList *
IpMessengerAgent::GetSentMessages()
{
	return ipmsgImpl->GetSentMessages();
}

/**
 * ѥåꥹȤΥԡ롣
 * @retval ѥåꥹȤΥԡ
 */
SentMessageList
IpMessengerAgent::CloneSentMessages() const
{
	return ipmsgImpl->CloneSentMessages();
}

/**
 * ̾Υå
 * @retval ̾
 */
std::string
IpMessengerAgent::LoginName() const
{
	return ipmsgImpl->LoginName();
}

/**
 * ۥ̾Υå
 * @retval ۥ̾
 */
std::string
IpMessengerAgent::HostName() const
{
	return ipmsgImpl->HostName();
}

/**
 * ǥեȥݡȤΥå
 * @retval ǥեȥݡ
 */
int
IpMessengerAgent::DefaultPortNo() const
{
	return ipmsgImpl->DefaultPortNo();
}

/**
 * ǥեȥݡȤΥå
 * @param defaultPortNo ǥեȥݡ
 */
void
IpMessengerAgent::setDefaultPortNo( const int defaultPortNo )
{
	ipmsgImpl->setDefaultPortNo( defaultPortNo );
}

/**
 * 륢åפΥå
 * @retval 륢å
 */
bool
IpMessengerAgent::IsDialup() const
{
	return ipmsgImpl->IsDialup();
}

/**
 * 륢åפΥå
 * @param isDialup 륢å
 */
void
IpMessengerAgent::setIsDialup( const bool isDialup )
{
	ipmsgImpl->setIsDialup( isDialup );
}

/**
 * ɻ˥ե뤬ѹ줿˶ػߤ뤫ɤΥե饰Υå
 * @retval ɻ˥ե뤬ѹ줿˶ػߤ뤫ɤΥե饰
 */
bool
IpMessengerAgent::AbortDownloadAtFileChanged() const
{
	return ipmsgImpl->AbortDownloadAtFileChanged();
}

/**
 * ɻ˥ե뤬ѹ줿˶ػߤ뤫ɤΥե饰Υå
 * @param isAbort ɻ˥ե뤬ѹ줿˶ػߤ뤫ɤΥե饰
 */
void
IpMessengerAgent::setAbortDownloadAtFileChanged( const bool isAbort )
{
	ipmsgImpl->setAbortDownloadAtFileChanged( isAbort );
}

/**
 * å¸뤫ɤΥե饰Υå
 * @retval å¸뤫ɤΥե饰
 */
bool
IpMessengerAgent::SaveSentMessage() const
{
	return ipmsgImpl->SaveSentMessage();
}

/**
 * å¸뤫ɤΥե饰Υå
 * @param isSave å¸뤫ɤΥե饰
 */
void
IpMessengerAgent::setSaveSentMessage( const bool isSave )
{
	ipmsgImpl->setSaveSentMessage( isSave );
}

/**
 * å¸뤫ɤΥե饰Υå
 * @retval å¸뤫ɤΥե饰
 */
bool
IpMessengerAgent::SaveRecievedMessage() const
{
	return ipmsgImpl->SaveRecievedMessage();
}

/**
 * å¸뤫ɤΥե饰Υå
 * @param isSave å¸뤫ɤΥե饰
 */
void
IpMessengerAgent::setSaveRecievedMessage( const bool isSave )
{
	ipmsgImpl->setSaveRecievedMessage( isSave );
}

/**
 * Ź沽˼ԤåʤɤΥե饰Υå
 * @retval Ź沽˼ԤåʤɤΥե饰
 */
bool IpMessengerAgent::NoSendMessageOnEncryptionFailed() const
{
	return ipmsgImpl->NoSendMessageOnEncryptionFailed();
}

/**
 * Ź沽˼ԤåʤɤΥե饰Υå
 * @param isSave Ź沽˼ԤåʤɤΥե饰
 */
void IpMessengerAgent::setNoSendMessageOnEncryptionFailed( const bool isNoSend )
{
	return ipmsgImpl->setNoSendMessageOnEncryptionFailed( isNoSend );
}

/**
 * ®٤򻻽Ф롣
 * @retval ®١ʥХȡáˡ
 */
long double
DownloadInfo::getSpeed()
{
	return Time() == 0 ? (long double)0 : ( ( long double )Size() / ( long double )Time() );
}

/**
 * ®ʸ롣
 * @retval ®ʸñ̡áˡ:1 B/sec, 2.00KB/sec, 3.00 MB/sec, 4.00 GB/sec, 5.00 TB/sec
 */
std::string
DownloadInfo::getSpeedString()
{
	return DownloadInfo::getUnitSizeString( ( long long )getSpeed() ) + "/sec";
}

/**
 * ʸ롣
 * @retval ʸñ̡ˡ:1 B, 2.00KB, 3.00 MB, 4.00 GB, 5.00 TB
 */
std::string
DownloadInfo::getSizeString()
{
	return DownloadInfo::getUnitSizeString( Size() );
}

#define IPMSG_SIZE_B	(long double)(1)
#define IPMSG_SIZE_KB	(long double)(1024 * IPMSG_SIZE_B)
#define IPMSG_SIZE_MB	(long double)(1024 * IPMSG_SIZE_KB)
#define IPMSG_SIZE_GB	(long double)(1024 * IPMSG_SIZE_MB)
#define IPMSG_SIZE_TB	(long double)(1024 * IPMSG_SIZE_GB)

/**
 * ʸ롣
 * @retval ʸñ̡ˡ:1 B, 2.00KB, 3.00 MB, 4.00 GB, 5.00 TB
 */
std::string
DownloadInfo::getUnitSizeString( long long size )
{
	long double dsize = (long double)size;
	char buf[100];
	if ( dsize >= IPMSG_SIZE_TB ) {
		snprintf( buf, sizeof( buf ), "%.2Lf TB", (dsize / IPMSG_SIZE_TB) );
		return buf;
	} else if ( dsize >= IPMSG_SIZE_GB ) {
		snprintf( buf, sizeof( buf ), "%.2Lf GB", (dsize / IPMSG_SIZE_GB) );
		return buf;
	} else if ( dsize >= IPMSG_SIZE_MB ) {
		snprintf( buf, sizeof( buf ), "%.2Lf MB", (dsize / IPMSG_SIZE_MB) );
		return buf;
	} else if ( dsize >= IPMSG_SIZE_KB ) {
		snprintf( buf, sizeof( buf ), "%.2Lf KB", (dsize / IPMSG_SIZE_KB) );
		return buf;
	}
	snprintf( buf, sizeof( buf ), "%lld B", size );
	return buf;
}

/**
 * IPɥ쥹ꤷͥåȥɥ쥹֥ɥ㥹ȥɥ쥹Ʒ׻롣
 * @param val IPɥ쥹ʸ
 */
void
NetworkInterface::setIpAddress( const std::string val )
{
	_IpAddress = val;
	inet_pton( AF_INET, val.c_str(), (void *)&_NativeIpAddress );
	recalc();
}
/**
 * ͥåȥޥꤷͥåȥɥ쥹֥ɥ㥹ȥɥ쥹Ʒ׻롣
 * @param val ͥåȥޥʸ
 */
void
NetworkInterface::setNetMask( const std::string val )
{
	_NetMask = val;
	inet_pton( AF_INET, val.c_str(), (void *)&_NativeNetMask );
	recalc();
}
/**
 * IPɥ쥹(ͥƥ)ꤷͥåȥɥ쥹֥ɥ㥹ȥɥ쥹Ʒ׻롣
 * @param val IPɥ쥹
 */
void
NetworkInterface::setNativeIpAddress( const struct in_addr val )
{
	_NativeIpAddress = val;
	char ipAddrBuf[IP_ADDR_MAX_SIZE];
	_IpAddress = inet_ntop( AF_INET, &val, ipAddrBuf, sizeof( ipAddrBuf ) );
	recalc();
}
/**
 * ͥåȥޥ(ͥƥ)ꤷͥåȥɥ쥹֥ɥ㥹ȥɥ쥹Ʒ׻롣
 * @param val ͥåȥޥ
 */
void
NetworkInterface::setNativeNetMask( const struct in_addr val )
{
	_NativeNetMask = val;
	char netMaskBuf[IP_ADDR_MAX_SIZE];
	_NetMask = inet_ntop( AF_INET, &val, netMaskBuf, sizeof( netMaskBuf ) );
	recalc();
}
/**
 * ͥåȥɥ쥹֥ɥ㥹ȥɥ쥹׻롣
 */
void
NetworkInterface::recalc()
{
	char buf[IP_ADDR_MAX_SIZE];
	_NativeNetworkAddress.s_addr = _NativeIpAddress.s_addr & _NativeNetMask.s_addr;
	_NetworkAddress = inet_ntop( AF_INET, &_NativeNetworkAddress, buf, sizeof( buf ) );

	_NativeBroadcastAddress = GetBroadcastAddress( _NativeNetworkAddress, _NativeNetMask );
	_BroadcastAddress = inet_ntop( AF_INET, &_NativeBroadcastAddress, buf, sizeof( buf ) );
}
//end of source
