/**
 * IP å󥸥饤֥(Unix)
 * IPå󥸥㥨ȥ饹
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "IpMessenger.h"
#include "IpMessengerImpl.h"

using namespace ipmsg;

static IpMessengerAgent *myInstance = NULL;

static pthread_mutex_t instanceMutex;
static int mutex_init_result = IpMsgMutexInit( "IpMessenger::Global", &instanceMutex, NULL );

IpMessengerEvent::~IpMessengerEvent()
{
	IPMSG_FUNC_ENTER("IpMessengerEvent::~IpMessengerEvent()");
	IPMSG_FUNC_EXIT;
};
/**
 * IP å󥸥㥨ȥ饹Υ󥹥󥹤롣
 * <ul>
 * <li>SingletonѥѤƤΤǡۥͣΥ󥹥󥹤ǤʤФʤʤ</li>
 * </ul>
 */
IpMessengerAgent *
IpMessengerAgent::GetInstance()
{
	IPMSG_FUNC_ENTER("IpMessengerAgent * IpMessengerAgent::GetInstance()");
	mutex_init_result = 0; //fix warnings. but no effect.
	IpMsgMutexLock( "IpMessengerAgent::GetInstance()", &instanceMutex );
	if ( myInstance == NULL ) {
		myInstance = new IpMessengerAgent();
	}
	IpMsgMutexUnlock( "IpMessengerAgent::GetInstance()", &instanceMutex );
	IPMSG_FUNC_RETURN( myInstance );
}

/**
 * IP å󥸥㥨ȥ饹Υ󥹥󥹤롣
 * <ul>
 * <li>Υ᥽åɤȤäƥ֥ȤʤФʤʤ</li>
 * <li>饤֥̤ʤľdelete줿ϤθưˤĤƴΤʤ</li>
 * </ul>
 */
void
IpMessengerAgent::Release()
{
	IPMSG_FUNC_ENTER("void IpMessengerAgent::Release()");
	IpMsgMutexLock( "IpMessengerAgent::Release()", &instanceMutex );
	if ( myInstance == NULL ) {
		IpMsgMutexUnlock( "IpMessengerAgent::Release()", &instanceMutex );
		IPMSG_FUNC_EXIT;
	}
	delete myInstance;
	myInstance = NULL;
	IpMsgMutexUnlock( "IpMessengerAgent::Release()", &instanceMutex );
	IPMSG_FUNC_EXIT;
}

/**
 * IP å󥸥㥨ȥ饹Υ󥹥ȥ饯
 */
IpMessengerAgent::IpMessengerAgent()
{
	IPMSG_FUNC_ENTER("IpMessengerAgent::IpMessengerAgent()");
	if ( isSupportIPv4() ) {
		printf("This host support IPv4.\n");
	} else {
		printf("This host not support IPv4.\n");
	}
	if ( isSupportIPv6() ) {
		printf("This host support IPv6.\n");
	} else {
		printf("This host not support IPv6.\n");
	}
	ipmsgImpl = IpMessengerAgentImpl::GetInstance();
	IPMSG_FUNC_EXIT;
}

/**
 * IP å󥸥㥨ȥ饹Υǥȥ饯
 */
IpMessengerAgent::~IpMessengerAgent()
{
	IPMSG_FUNC_ENTER("IpMessengerAgent::~IpMessengerAgent()");
	IpMessengerAgentImpl::Release();
	IPMSG_FUNC_EXIT;
}

/**
 * NICꤻIP å󥸥㥨ȥ饹Υͥåȥư롣
 * <ul>
 * <li>ƤNICФƥǥեȥݡȤǥͥåȥư롣</li>
 * </ul>
 */
void
IpMessengerAgent::StartNetwork()
{
	IPMSG_FUNC_ENTER("void IpMessengerAgent::StartNetwork()");
	ipmsgImpl->StartNetwork();
	IPMSG_FUNC_EXIT;
}

/**
 * IP å󥸥㥨ȥ饹Υͥåȥư롣
 * @parem nics ưоݤȤNICΥ٥
 */
void
IpMessengerAgent::StartNetwork( const std::vector<NetworkInterface>& nics )
{
	IPMSG_FUNC_ENTER("void IpMessengerAgent::StartNetwork( const std::vector<NetworkInterface>& nics )");
	ipmsgImpl->StartNetwork( nics );
	IPMSG_FUNC_EXIT;
}

/**
 * IP å󥸥㥨ȥ饹Υͥåȥߤ롣
 */
void
IpMessengerAgent::StopNetwork()
{
	IPMSG_FUNC_ENTER("void IpMessengerAgent::StopNetwork()");
	ipmsgImpl->StopNetwork();
	IPMSG_FUNC_EXIT;
}

/**
 * NICꤻIP å󥸥㥨ȥ饹ΥͥåȥƵư롣
 * <ul>
 * <li>ƤNICФƥǥեȥݡȤǥͥåȥư롣</li>
 * </ul>
 */
void
IpMessengerAgent::RestartNetwork()
{
	IPMSG_FUNC_ENTER("void IpMessengerAgent::RestartNetwork()");
	ipmsgImpl->RestartNetwork();
	IPMSG_FUNC_EXIT;
}

/**
 * IP å󥸥㥨ȥ饹ΥͥåȥƵư롣
 * @parem nics ưоݤȤNICΥ٥
 */
void
IpMessengerAgent::RestartNetwork( const std::vector<NetworkInterface>& nics )
{
	IPMSG_FUNC_ENTER("void IpMessengerAgent::RestartNetwork( const std::vector<NetworkInterface>& nics )");
	ipmsgImpl->RestartNetwork( nics );
	IPMSG_FUNC_EXIT;
}

/**
 * ե̾СΥå
 * @retval СΥɥ쥹
 */
FileNameConverter *
IpMessengerAgent::GetFileNameConverter() const
{
	IPMSG_FUNC_ENTER("FileNameConverter *IpMessengerAgent::GetFileNameConverter() const");
	IPMSG_FUNC_RETURN( ipmsgImpl->GetFileNameConverter() );
}

/**
 * ե̾СΥå
 * @param conv СΥɥ쥹ưŪ˺Τǡå˺ƤϤʤʤҡ׾˺뤳ȡ
 */
void
IpMessengerAgent::SetFileNameConverter( const FileNameConverter *conv )
{
	IPMSG_FUNC_ENTER("void IpMessengerAgent::SetFileNameConverter( const FileNameConverter *conv )");
	ipmsgImpl->SetFileNameConverter( conv );
	IPMSG_FUNC_EXIT;
}

/**
 * ٥ȥ֥ȤΥå
 * @retval ٥ȥ֥ȤΥɥ쥹
 */
HostListComparator *
IpMessengerAgent::GetSortHostListComparator() const
{
	IPMSG_FUNC_ENTER("HostListComparator *IpMessengerAgent::GetSortHostListComparator() const");
	IPMSG_FUNC_RETURN( ipmsgImpl->GetSortHostListComparator() );
}; 

/**
 * ۥȥꥹӥ֥ȤΥå
 * @param comparator ۥȥꥹӥ֥ȤΥɥ쥹ưŪ˺Τǡå˺ƤϤʤʤҡ׾˺뤳ȡ
 */
void
IpMessengerAgent::SetSortHostListComparator( const HostListComparator *comparator )
{
	IPMSG_FUNC_ENTER("void IpMessengerAgent::SetSortHostListComparator( const HostListComparator *comparator )");
	ipmsgImpl->SetSortHostListComparator( comparator );
	IPMSG_FUNC_EXIT;
}

/**
 * ٥ȥ֥ȤΥå
 * @retval ٥ȥ֥ȤΥɥ쥹
 */
IpMessengerEvent *
IpMessengerAgent::GetEventObject() const
{
	IPMSG_FUNC_ENTER("IpMessengerEvent *IpMessengerAgent::GetEventObject() const");
	IPMSG_FUNC_RETURN( ipmsgImpl->GetEventObject() );
}; 

/**
 * ٥ȥ֥ȤΥå
 * @param evt ٥ȥ֥ȤΥɥ쥹ưŪ˺Τǡå˺ƤϤʤʤҡ׾˺뤳ȡ
 */
void
IpMessengerAgent::SetEventObject( const IpMessengerEvent *evt )
{
	IPMSG_FUNC_ENTER("void IpMessengerAgent::SetEventObject( const IpMessengerEvent *evt )");
	ipmsgImpl->SetEventObject( evt );
	IPMSG_FUNC_EXIT;
}

/**
 * NICξ롣
 * @param nics ͥåȥ󥿡եΰ
 */
void
IpMessengerAgent::GetNetworkInterfaceInfo( std::vector<NetworkInterface>& nics, bool useIPv6 )
{
	IPMSG_FUNC_ENTER("void IpMessengerAgent::GetNetworkInterfaceInfo( std::vector<NetworkInterface>& nics, bool useIPv6 )");
	IpMessengerAgentImpl::GetNetworkInterfaceInfo( nics, useIPv6 );
	IPMSG_FUNC_EXIT;
}

/**
 * ʥӥΡˡ
 */
void
IpMessengerAgent::Login( std::string nickname, std::string groupName )
{
	IPMSG_FUNC_ENTER("void IpMessengerAgent::Login( std::string nickname, std::string groupName )");
	ipmsgImpl->Login( nickname, groupName );
	IPMSG_FUNC_EXIT;
}

/**
 * ȡʥӥæΡˡ
 */
void
IpMessengerAgent::Logout()
{	
	IPMSG_FUNC_ENTER("void IpMessengerAgent::Logout()");
	ipmsgImpl->Logout();
	IPMSG_FUNC_EXIT;
}

/**
 * ۥȥꥹȼ
 * @retval ȤݻƤHostList֥
 */
HostList&
IpMessengerAgent::GetHostList()
{
	IPMSG_FUNC_ENTER("HostList& IpMessengerAgent::GetHostList()");
	IPMSG_FUNC_RETURN( ipmsgImpl->GetHostList() );
}

/**
 * ۥȥꥹȹ
 * @retval HostList֥
 */
HostList&
IpMessengerAgent::UpdateHostList()
{
	IPMSG_FUNC_ENTER("HostList& IpMessengerAgent::UpdateHostList()");
	IPMSG_FUNC_RETURN( ipmsgImpl->UpdateHostList() );
}

/**
 * Ժߥ⡼ɤɤȽꡣ
 * @retval ѤԺߥ⡼ɤ֤
 */
bool
IpMessengerAgent::IsAbsence() const
{
	IPMSG_FUNC_ENTER("bool IpMessengerAgent::IsAbsence() const");
	IPMSG_FUNC_RETURN( ipmsgImpl->IsAbsence() );
}
/**
 * Ժߥ⡼ɤ򥯥ꥢ롣
 */
void
IpMessengerAgent::ResetAbsence()
{
	IPMSG_FUNC_ENTER("void IpMessengerAgent::ResetAbsence()");
	ipmsgImpl->ResetAbsence();
	IPMSG_FUNC_EXIT;
}

/**
 * Ժߥ⡼ɤꤹ롣
 * @param encoding 륨󥳡ǥ
 * @param absenceModes AbsenceMode֥ȤΥ٥ʼưʣ󥳡ǥб뤿
 */
void
IpMessengerAgent::SetAbsence( std::string encoding, std::vector<AbsenceMode> absenceModes )
{
	IPMSG_FUNC_ENTER("void IpMessengerAgent::SetAbsence( std::string encoding, std::vector<AbsenceMode> absenceModes )");
	ipmsgImpl->SetAbsence( encoding, absenceModes );
	IPMSG_FUNC_EXIT;
}

/**
 * å
 * @param host ۥ
 * @param msg å
 * @param isSecret 񤫤ɤ򼨤ե饰
 * @param isLockPassword Ĥɤ򼨤ե饰
 * @param hostCountAtSameTime Ʊۥȿ
 * @param IsNoLogging ˻ĤʤʤȤ侩
 * @param opt ץ
 */
bool
IpMessengerAgent::SendMsg( HostListItem host, std::string msg, const Secret &isSecret, const LockPassword &isLockPassword, int hostCountAtSameTime, const Logging &IsLogging, unsigned long opt )
{
	IPMSG_FUNC_ENTER("bool IpMessengerAgent::SendMsg( HostListItem host, std::string msg, const Secret &isSecret, const LockPassword &isLockPassword, int hostCountAtSameTime, const Logging &IsLogging, unsigned long opt )");
	IPMSG_FUNC_RETURN( ipmsgImpl->SendMsg( host, msg, isSecret, isLockPassword, hostCountAtSameTime, IsLogging, opt ) );
}

/**
 * å
 * @param host ۥ
 * @param msg å
 * @param isSecret 񤫤ɤ򼨤ե饰
 * @param file źեե
 * @param isLockPassword Ĥɤ򼨤ե饰
 * @param hostCountAtSameTime Ʊۥȿ
 * @param IsNoLogging ˻ĤʤʤȤ侩
 * @param opt ץ
 */
bool
IpMessengerAgent::SendMsg( HostListItem host, std::string msg, const Secret &isSecret, AttachFile& file, const LockPassword &isLockPassword, int hostCountAtSameTime, const Logging &IsLogging, unsigned long opt )
{
	IPMSG_FUNC_ENTER("bool IpMessengerAgent::SendMsg( HostListItem host, std::string msg, const Secret &isSecret, AttachFile& file, const LockPassword &isLockPassword, int hostCountAtSameTime, const Logging &IsLogging, unsigned long opt )");
	IPMSG_FUNC_RETURN( ipmsgImpl->SendMsg( host, msg, isSecret, file, isLockPassword, hostCountAtSameTime, IsLogging, opt ) );
}

/**
 * å
 * @param host ۥ
 * @param msg å
 * @param isSecret 񤫤ɤ򼨤ե饰
 * @param files źեե뷲
 * @param isLockPassword Ĥɤ򼨤ե饰
 * @param hostCountAtSameTime Ʊۥȿ
 * @param IsNoLogging ˻ĤʤʤȤ侩
 * @param opt ץ
 */
bool
IpMessengerAgent::SendMsg( HostListItem host, std::string msg, const Secret &isSecret, AttachFileList& files, const LockPassword &isLockPassword, int hostCountAtSameTime, const Logging &IsLogging, unsigned long opt )
{
	IPMSG_FUNC_ENTER("bool IpMessengerAgent::SendMsg( HostListItem host, std::string msg, const Secret &isSecret, AttachFileList& files, const LockPassword &isLockPassword, int hostCountAtSameTime, const Logging &IsLogging, unsigned long opt )");
	IPMSG_FUNC_RETURN( ipmsgImpl->SendMsg( host, msg, isSecret, files, isLockPassword, hostCountAtSameTime, IsLogging, opt ) );
}

/**
 * ϿѤΥ֥ɥ㥹ȥɥ쥹ƥꥢ
 */
void
IpMessengerAgent::ClearBroadcastAddress()
{
	IPMSG_FUNC_ENTER("void IpMessengerAgent::ClearBroadcastAddress()");
	ipmsgImpl->ClearBroadcastAddress();
	IPMSG_FUNC_EXIT;
}

/**
 * ϿѤΥ֥ɥ㥹ȥɥ쥹
 * @param addr ϿѤΥ֥ɥ㥹ȥɥ쥹
 */
void
IpMessengerAgent::DeleteBroadcastAddress( std::string addr )
{
	IPMSG_FUNC_ENTER("void IpMessengerAgent::DeleteBroadcastAddress( std::string addr )");
	ipmsgImpl->DeleteBroadcastAddress( addr );
	IPMSG_FUNC_EXIT;
}

/**
 * ֥ɥ㥹ȥɥ쥹Ͽ
 * @param addr Ͽ֥ɥ㥹ȥɥ쥹
 */
void
IpMessengerAgent::AddBroadcastAddress( std::string addr )
{
	IPMSG_FUNC_ENTER("void IpMessengerAgent::AddBroadcastAddress( std::string addr )");
	ipmsgImpl->AddBroadcastAddress( addr );
	IPMSG_FUNC_EXIT;
}

/**
 * ΥۥȤ鱣硢ʤۥȤΥꥹȤ򥯥ꥢ
 */
void
IpMessengerAgent::ClearSkulkHost()
{
	IPMSG_FUNC_ENTER("void IpMessengerAgent::ClearSkulkHost()");
	ipmsgImpl->ClearSkulkHost();
	IPMSG_FUNC_EXIT;
}

/**
 * ΥۥȤ鱣硢ʤۥȤΥꥹȤ饢ɥ쥹
 * @param host ϿѤθʤʱ˥ۥȥɥ쥹
 */
void
IpMessengerAgent::DeleteSkulkHostAddress( std::string addr )
{
	IPMSG_FUNC_ENTER("void IpMessengerAgent::DeleteSkulkHostAddress( std::string addr )");
	ipmsgImpl->DeleteSkulkHostAddress( addr );
	IPMSG_FUNC_EXIT;
}

/**
 * ΥۥȤ鱣硢ʤۥȤΥꥹȤۥȤ
 * @param host ϿѤθʤʱ˥ۥ
 */
void
IpMessengerAgent::DeleteSkulkHost( HostListItem &host )
{
	IPMSG_FUNC_ENTER("void IpMessengerAgent::DeleteSkulkHost( HostListItem &host )");
	ipmsgImpl->DeleteSkulkHost( host );
	IPMSG_FUNC_EXIT;
}

/**
 * ΥۥȤ鱣硢ʤۥȤΥꥹȤ˥ۥȥɥ쥹ɲ
 * @param host Ͽ븫ʤʱ˥ۥȥɥ쥹
 */
void
IpMessengerAgent::AddSkulkHostAddress( std::string addr )
{
	IPMSG_FUNC_ENTER("void IpMessengerAgent::AddSkulkHostAddress( std::string )");
	ipmsgImpl->AddSkulkHostAddress( addr );
	IPMSG_FUNC_EXIT;
}

/**
 * ΥۥȤ鱣硢ʤۥȤΥꥹȤ˥ۥȤɲ
 * @param host Ͽ븫ʤʱ˥ۥ
 */
void
IpMessengerAgent::AddSkulkHost( HostListItem &host )
{
	IPMSG_FUNC_ENTER("void IpMessengerAgent::AddSkulkHost( HostListItem &host )");
	ipmsgImpl->AddSkulkHost( host );
	IPMSG_FUNC_EXIT;
}

/**
 * ΥۥȤ鱣硢ʤۥȤΥꥹȤ֤
 * @retval Ͽ븫ʤʱ˥ۥȥꥹ
 */
HostList
IpMessengerAgent::GetSkulkHost()
{
	IPMSG_FUNC_ENTER("HostList IpMessengerAgent::GetSkulkHost()");
	IPMSG_FUNC_RETURN( ipmsgImpl->GetSkulkHost() );
}

/**
 * оݥۥȤΥС
 * @param host оݤΥۥ
 * @retval оݥۥȤΥС
 */
std::string
IpMessengerAgent::GetInfo( HostListItem& host )
{
	IPMSG_FUNC_ENTER("std::string IpMessengerAgent::GetInfo( HostListItem& host )");
	IPMSG_FUNC_RETURN( ipmsgImpl->GetInfo( host ) );
}

/**
 * оݥۥȤԺʸ
 * @param host оݤΥۥ
 * @retval оݥۥȤԺʸ
 */
std::string
IpMessengerAgent::GetAbsenceInfo( HostListItem& host )
{
	IPMSG_FUNC_ENTER("std::string IpMessengerAgent::GetAbsenceInfo( HostListItem& host )");
	IPMSG_FUNC_RETURN( ipmsgImpl->GetAbsenceInfo( host ) );
}

/**
 * ݻΥۥȥꥹȤ饰롼ץꥹȤ롣
 * @retval 롼ץꥹ
 */
std::vector<GroupItem>
IpMessengerAgent::GetGroupList()
{
	IPMSG_FUNC_ENTER("std::vector<GroupItem> IpMessengerAgent::GetGroupList()");
	IPMSG_FUNC_RETURN( ipmsgImpl->GetGroupList() );
}

/**
 * ˥åȤΤ롣
 * @param msg å֥ȡ
 */
void
IpMessengerAgent::DeleteNotify( RecievedMessage msg )
{
	IPMSG_FUNC_ENTER("void IpMessengerAgent::DeleteNotify( RecievedMessage msg )");
	ipmsgImpl->DeleteNotify( msg );
	IPMSG_FUNC_EXIT;
}

/**
 * ˥åȤΤ롣
 * @param msg å֥ȡ
 */
void
IpMessengerAgent::ConfirmMessage( RecievedMessage &msg )
{
	IPMSG_FUNC_ENTER("void IpMessengerAgent::ConfirmMessage( RecievedMessage &msg )");
	ipmsgImpl->ConfirmMessage( msg );
	IPMSG_FUNC_EXIT;
}

/**
 * ѥåꥹȤ˳줿Ȥޡ롣
 * @param msg å֥ȡ
 */
void
IpMessengerAgent::AcceptConfirmNotify( SentMessage msg )
{
	IPMSG_FUNC_ENTER("void IpMessengerAgent::AcceptConfirmNotify( SentMessage msg )");
	ipmsgImpl->AcceptConfirmNotify( msg );
	IPMSG_FUNC_EXIT;
}
		
// private methods start here

/**
 * ʥ桼ˡ
 * Υ᥽åɤϥåɥդǤʤ
 */
int
IpMessengerAgent::Process()
{
	IPMSG_FUNC_ENTER("int IpMessengerAgent::Process()");
	IPMSG_FUNC_RETURN( ipmsgImpl->Process() );
}

/**
 * åθĿ롣
 * @retval åθĿ
 */
int
IpMessengerAgent::GetRecievedMessageCount()
{
	IPMSG_FUNC_ENTER("int IpMessengerAgent::GetRecievedMessageCount()");
	IPMSG_FUNC_RETURN( ipmsgImpl->GetRecievedMessageCount() );
}

/**
 * åļФåꥹȤ롣
 * @retval å֥ȡ
 */
RecievedMessage
IpMessengerAgent::PopRecievedMessage()
{
	IPMSG_FUNC_ENTER("RecievedMessage IpMessengerAgent::PopRecievedMessage()");
	IPMSG_FUNC_RETURN( ipmsgImpl->PopRecievedMessage() );
}

/**
 * ѥåꥹȤΥݥ󥿤롣
 * @retval ѥåꥹȤΥݥ󥿡
 */
SentMessageList *
IpMessengerAgent::GetSentMessages()
{
	IPMSG_FUNC_ENTER("SentMessageList *IpMessengerAgent::GetSentMessages()");
	IPMSG_FUNC_RETURN( ipmsgImpl->GetSentMessages() );
}

/**
 * ѥåꥹȤΥԡ롣
 * @retval ѥåꥹȤΥԡ
 */
SentMessageList
IpMessengerAgent::CloneSentMessages() const
{
	IPMSG_FUNC_ENTER("SentMessageList IpMessengerAgent::CloneSentMessages() const");
	IPMSG_FUNC_RETURN( ipmsgImpl->CloneSentMessages() );
}

/**
 * ̾Υå
 * @retval ̾
 */
std::string
IpMessengerAgent::LoginName() const
{
	IPMSG_FUNC_ENTER("std::string IpMessengerAgent::LoginName() const");
	IPMSG_FUNC_RETURN( ipmsgImpl->LoginName() );
}

/**
 * ۥ̾Υå
 * @retval ۥ̾
 */
std::string
IpMessengerAgent::HostName() const
{
	IPMSG_FUNC_ENTER("std::string IpMessengerAgent::HostName() const");
	IPMSG_FUNC_RETURN( ipmsgImpl->HostName() );
}

/**
 * ǥեȥݡȤΥå
 * @retval ǥեȥݡ
 */
int
IpMessengerAgent::DefaultPortNo() const
{
	IPMSG_FUNC_ENTER("int IpMessengerAgent::DefaultPortNo() const");
	IPMSG_FUNC_RETURN( ipmsgImpl->DefaultPortNo() );
}

/**
 * ǥեȥݡȤΥå
 * @param defaultPortNo ǥեȥݡ
 */
void
IpMessengerAgent::setDefaultPortNo( const int defaultPortNo )
{
	IPMSG_FUNC_ENTER("void IpMessengerAgent::setDefaultPortNo( const int defaultPortNo )");
	ipmsgImpl->setDefaultPortNo( defaultPortNo );
	IPMSG_FUNC_EXIT;
}

/**
 * 륢åפΥå
 * @retval 륢å
 */
bool
IpMessengerAgent::IsDialup() const
{
	IPMSG_FUNC_ENTER("bool IpMessengerAgent::IsDialup() const");
	IPMSG_FUNC_RETURN( ipmsgImpl->IsDialup() );
}

/**
 * 륢åפΥå
 * @param isDialup 륢å
 */
void
IpMessengerAgent::setIsDialup( const bool isDialup )
{
	IPMSG_FUNC_ENTER("void IpMessengerAgent::setIsDialup( const bool isDialup )");
	ipmsgImpl->setIsDialup( isDialup );
	IPMSG_FUNC_EXIT;
}

/**
 * ɻ˥ե뤬ѹ줿˶ػߤ뤫ɤΥե饰Υå
 * @retval ɻ˥ե뤬ѹ줿˶ػߤ뤫ɤΥե饰
 */
bool
IpMessengerAgent::AbortDownloadAtFileChanged() const
{
	IPMSG_FUNC_ENTER("bool IpMessengerAgent::AbortDownloadAtFileChanged() const");
	IPMSG_FUNC_RETURN( ipmsgImpl->AbortDownloadAtFileChanged() );
}

/**
 * ɻ˥ե뤬ѹ줿˶ػߤ뤫ɤΥե饰Υå
 * @param isAbort ɻ˥ե뤬ѹ줿˶ػߤ뤫ɤΥե饰
 */
void
IpMessengerAgent::setAbortDownloadAtFileChanged( const bool isAbort )
{
	IPMSG_FUNC_ENTER("void IpMessengerAgent::setAbortDownloadAtFileChanged( const bool isAbort )");
	ipmsgImpl->setAbortDownloadAtFileChanged( isAbort );
	IPMSG_FUNC_EXIT;
}

/**
 * å¸뤫ɤΥե饰Υå
 * @retval å¸뤫ɤΥե饰
 */
bool
IpMessengerAgent::SaveSentMessage() const
{
	IPMSG_FUNC_ENTER("bool IpMessengerAgent::SaveSentMessage() const");
	IPMSG_FUNC_RETURN( ipmsgImpl->SaveSentMessage() );
}

/**
 * å¸뤫ɤΥե饰Υå
 * @param isSave å¸뤫ɤΥե饰
 */
void
IpMessengerAgent::setSaveSentMessage( const bool isSave )
{
	IPMSG_FUNC_ENTER("void IpMessengerAgent::setSaveSentMessage( const bool isSave )");
	ipmsgImpl->setSaveSentMessage( isSave );
	IPMSG_FUNC_EXIT;
}

/**
 * å¸뤫ɤΥե饰Υå
 * @retval å¸뤫ɤΥե饰
 */
bool
IpMessengerAgent::SaveRecievedMessage() const
{
	IPMSG_FUNC_ENTER("bool IpMessengerAgent::SaveRecievedMessage() const");
	IPMSG_FUNC_RETURN( ipmsgImpl->SaveRecievedMessage() );
}

/**
 * å¸뤫ɤΥե饰Υå
 * @param isSave å¸뤫ɤΥե饰
 */
void
IpMessengerAgent::setSaveRecievedMessage( const bool isSave )
{
	IPMSG_FUNC_ENTER("void IpMessengerAgent::setSaveRecievedMessage( const bool isSave )");
	ipmsgImpl->setSaveRecievedMessage( isSave );
	IPMSG_FUNC_EXIT;
}

/**
 * Ź沽˼ԤåʤɤΥե饰Υå
 * @retval Ź沽˼ԤåʤɤΥե饰
 */
bool
IpMessengerAgent::NoSendMessageOnEncryptionFailed() const
{
	IPMSG_FUNC_ENTER("bool IpMessengerAgent::NoSendMessageOnEncryptionFailed() const");
	IPMSG_FUNC_RETURN( ipmsgImpl->NoSendMessageOnEncryptionFailed() );
}

/**
 * Ź沽˼ԤåʤɤΥե饰Υå
 * @param isNoSend Ź沽˼ԤåʤɤΥե饰
 */
void
IpMessengerAgent::setNoSendMessageOnEncryptionFailed( const bool isNoSend )
{
	IPMSG_FUNC_ENTER("void IpMessengerAgent::setNoSendMessageOnEncryptionFailed( const bool isNoSend )");
	IPMSG_FUNC_RETURN( ipmsgImpl->setNoSendMessageOnEncryptionFailed( isNoSend ) );
}

/**
 * IPv6ȤɤΥե饰Υå
 * @retval IPv6ȤɤΥե饰
 */
bool
IpMessengerAgent::UseIPv6() const
{
	IPMSG_FUNC_ENTER("bool IpMessengerAgent::UseIPv6() const");
	IPMSG_FUNC_RETURN( ipmsgImpl->UseIPv6() );
}

/**
 * IPv6ȤɤΥե饰Υå
 * @param useIPv6 IPv6ȤɤΥե饰
 */
void
IpMessengerAgent::setUseIPv6( const bool useIPv6 )
{
	IPMSG_FUNC_ENTER("void IpMessengerAgent::setUseIPv6( const bool useIPv6 )");
#ifdef ENABLE_IPV6
	ipmsgImpl->setUseIPv6( useIPv6 );
#else
	ipmsgImpl->setUseIPv6( false );
#endif
	IPMSG_FUNC_EXIT;
}

/**
 * IPv6򥵥ݡȤƤ뤫ӥɥץ롣
 * @retval true:IPv6򥵥ݡ
 * @retval false:IPv6򥵥ݡȤƤʤ
 */
bool
IpMessengerAgent::isSupportIPv6()
{
#ifdef ENABLE_IPV6
	return true;
#else
	return false;
#endif
}

/**
 * IPv4򥵥ݡȤƤ뤫ӥɥץ롣
 * @retval true:IPv4򥵥ݡ
 * @retval false:IPv4򥵥ݡȤƤʤ
 */
bool
IpMessengerAgent::isSupportIPv4()
{
#ifdef ENABLE_IPV4
	return true;
#else
	return false;
#endif
}

/**
 * ®٤򻻽Ф롣
 * @retval ®١ʥХȡáˡ
 */
long double
DownloadInfo::getSpeed()
{
	IPMSG_FUNC_ENTER("long double DownloadInfo::getSpeed()");
	IPMSG_FUNC_RETURN( Time() == 0 ? (long double)0 : ( ( long double )Size() / ( long double )Time() ) );
}

/**
 * ®ʸ롣
 * @retval ®ʸñ̡áˡ:1 B/sec, 2.00KB/sec, 3.00 MB/sec, 4.00 GB/sec, 5.00 TB/sec
 */
std::string
DownloadInfo::getSpeedString()
{
	IPMSG_FUNC_ENTER("std::string DownloadInfo::getSpeedString()");
	IPMSG_FUNC_RETURN( DownloadInfo::getUnitSizeString( ( long long )getSpeed() ) + "/sec" );
}

/**
 * ʸ롣
 * @retval ʸñ̡ˡ:1 B, 2.00KB, 3.00 MB, 4.00 GB, 5.00 TB
 */
std::string
DownloadInfo::getSizeString()
{
	IPMSG_FUNC_ENTER("std::string DownloadInfo::getSizeString()");
	IPMSG_FUNC_RETURN( DownloadInfo::getUnitSizeString( Size() ) );
}

#define IPMSG_SIZE_B	(long double)(1)
#define IPMSG_SIZE_KB	(long double)(1024 * IPMSG_SIZE_B)
#define IPMSG_SIZE_MB	(long double)(1024 * IPMSG_SIZE_KB)
#define IPMSG_SIZE_GB	(long double)(1024 * IPMSG_SIZE_MB)
#define IPMSG_SIZE_TB	(long double)(1024 * IPMSG_SIZE_GB)

/**
 * ʸ롣
 * @retval ʸñ̡ˡ:1 B, 2.00KB, 3.00 MB, 4.00 GB, 5.00 TB
 */
std::string
DownloadInfo::getUnitSizeString( long long size )
{
	IPMSG_FUNC_ENTER("std::string DownloadInfo::getUnitSizeString( long long size )");
	long double dsize = (long double)size;
	char buf[100];
	if ( dsize >= IPMSG_SIZE_TB ) {
		snprintf( buf, sizeof( buf ), "%.2Lf TB", (dsize / IPMSG_SIZE_TB) );
		IPMSG_FUNC_RETURN( buf );
	} else if ( dsize >= IPMSG_SIZE_GB ) {
		snprintf( buf, sizeof( buf ), "%.2Lf GB", (dsize / IPMSG_SIZE_GB) );
		IPMSG_FUNC_RETURN( buf );
	} else if ( dsize >= IPMSG_SIZE_MB ) {
		snprintf( buf, sizeof( buf ), "%.2Lf MB", (dsize / IPMSG_SIZE_MB) );
		IPMSG_FUNC_RETURN( buf );
	} else if ( dsize >= IPMSG_SIZE_KB ) {
		snprintf( buf, sizeof( buf ), "%.2Lf KB", (dsize / IPMSG_SIZE_KB) );
		IPMSG_FUNC_RETURN( buf );
	}
	snprintf( buf, sizeof( buf ), "%lld B", size );
	IPMSG_FUNC_RETURN( buf );
}

/**
 * ǥХ̾ꤷϡɥɥ쥹롣
 * @param val ǥХ̾
 */
void
NetworkInterface::setDeviceName( const std::string val )
{
	IPMSG_FUNC_ENTER("void NetworkInterface::setDeviceName( const std::string val )");
	_DeviceName = val;
	_HardwareAddress = getNetworkInterfaceMacAddress( val );
	IPMSG_FUNC_EXIT;
}

/**
 * IPɥ쥹ꤷͥåȥɥ쥹֥ɥ㥹ȥɥ쥹Ʒ׻롣
 * @param val IPɥ쥹ʸ
 */
void
NetworkInterface::setIpAddress( const std::string val )
{
	IPMSG_FUNC_ENTER("void NetworkInterface::setIpAddress( const std::string val )");
	_IpAddress = val;
	recalc();
	IPMSG_FUNC_EXIT;
}

/**
 * ͥåȥޥꤷͥåȥɥ쥹֥ɥ㥹ȥɥ쥹Ʒ׻롣
 * @param val ͥåȥޥʸ
 */
void
NetworkInterface::setNetMask( const std::string val )
{
	IPMSG_FUNC_ENTER("void NetworkInterface::setNetMask( const std::string val )");
	_NetMask = val;
	recalc();
	IPMSG_FUNC_EXIT;
}

/**
 * ͥåȥɥ쥹֥ɥ㥹ȥɥ쥹׻롣
 */
void
NetworkInterface::recalc()
{
	IPMSG_FUNC_ENTER("void NetworkInterface::recalc()");
	_NetworkAddress = getNetworkAddress( _AddressFamily, _IpAddress, _NetMask );
	_BroadcastAddress = getBroadcastAddress( _AddressFamily, _NetworkAddress, _NetMask );
	IPMSG_FUNC_EXIT;
}
//end of source
