#ifndef _IPMESSENGER_H_
#define _IPMESSENGER_H_
#include <stdio.h>
#include <fcntl.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <netinet/in.h>
#include <net/if.h>
#include <dirent.h>
#include <netdb.h>
#include <utime.h>
#include <errno.h>

#ifdef HAVE_OPENSSL
#include <openssl/rsa.h>
#include <openssl/engine.h>
#include <openssl/err.h>
#include <openssl/blowfish.h>
#include <openssl/rc2.h>
#endif

#include <string>
#include <map>
#include <vector>

namespace ipmsg {

/**
 * ɤ߹ѥץѥƥ
 * IPMSG_READONLY_PROPERTY( SomeClass, PropName )
 * -------------------------------------------------------------------
 *   private: SomeClass _PropName;
 *   public: SomeClass& PropName(){ return _PropName; };
 * -------------------------------------------------------------------
 * Ÿޤ
 **/
#define IPMSG_READONLY_PROPERTY(t, name ) \
									private: \
										t _##name; \
									public: \
										inline t name() const { return _##name; };

/**
 * ɤ߽ξѥץѥƥ
 * IPMSG_PROPERTY( SomeClass, PropName )
 * -------------------------------------------------------------------
 *   private: SomeClass _PropName;
 *   public: SomeClass PropName(){ return _PropName; };
 *           void setPropName( SomeClass val ){ _PropName = val; };
 * -------------------------------------------------------------------
 * Ÿޤ
 **/
#define IPMSG_PROPERTY(t, name )	private: \
										t _##name; \
									public: \
										inline t name() const { return _##name; }; \
										inline void set##name( const t val ){ _##name = val; };

/**
 * ɤ߽ξѥץѥƥ()
 * IPMSG_PROPERTY_REF( SomeClass, PropName )
 * -------------------------------------------------------------------
 *   private: SomeClass _PropName;
 *   public: SomeClass& PropName(){ return _PropName; };
 *           void setPropName( SomeClass& val ){ _PropName = val; };
 * -------------------------------------------------------------------
 * Ÿޤ
 **/
#define IPMSG_PROPERTY_REF(t, name )	\
									private: \
										t _##name; \
									public: \
										inline t& name() { return _##name; }; \
										inline void set##name( const t& val ){ _##name = val; };
/**
 * ѥåȥ饹
 **/
class Packet{
	public:
		IPMSG_PROPERTY( unsigned long, VersionNo );
		IPMSG_PROPERTY( unsigned long, PacketNo );
		IPMSG_PROPERTY( unsigned long, CommandMode );
		IPMSG_PROPERTY( unsigned long, CommandOption );
		IPMSG_PROPERTY( time_t, Recieved );
		IPMSG_PROPERTY( std::string, HostName );
		IPMSG_PROPERTY( std::string, UserName );
		IPMSG_PROPERTY( std::string, Option );
		IPMSG_PROPERTY( struct sockaddr_storage, Addr );
		IPMSG_PROPERTY( int, UdpSocket );
		IPMSG_PROPERTY( int, TcpSocket );
};

/**
 * ͥåȥ󥿡ե饹
 **/
class NetworkInterface {
	public:
		IPMSG_READONLY_PROPERTY( std::string, DeviceName );
		IPMSG_PROPERTY( int, AddressFamily );
		IPMSG_READONLY_PROPERTY( std::string, IpAddress );
		IPMSG_READONLY_PROPERTY( std::string, HardwareAddress );
		IPMSG_READONLY_PROPERTY( std::string, NetMask );
		IPMSG_READONLY_PROPERTY( std::string, NetworkAddress );
		IPMSG_READONLY_PROPERTY( std::string, BroadcastAddress );
		IPMSG_PROPERTY( int, PortNo );
		NetworkInterface( std::string deviceName ):_AddressFamily( AF_INET ){ setDeviceName( deviceName ); };
		NetworkInterface( int addressFamily, std::string deviceName ):_AddressFamily( addressFamily ){ setDeviceName( deviceName ); };
		NetworkInterface():_AddressFamily( AF_INET ){};
	public:
		void setDeviceName( const std::string val );
		void setIpAddress( const std::string val );
		void setNetMask( const std::string val );
		void recalc();
};

/**
 * 롼ץ饹
 **/
class GroupItem{
	public:
		IPMSG_PROPERTY( std::string, GroupName );
		IPMSG_PROPERTY( std::string, EncodingName );
};

/**
 * ۥȥ饹
 **/
class HostListItem{
	public:
		IPMSG_PROPERTY( std::string, Version );
		IPMSG_PROPERTY( std::string, AbsenceDescription );
		IPMSG_PROPERTY( std::string, UserName );
		IPMSG_PROPERTY( std::string, HostName );
		IPMSG_PROPERTY( unsigned long, CommandNo );
		IPMSG_PROPERTY( int, AddressFamily );
		std::string IpAddress() const;
		void setIpAddress( const std::string val );
		IPMSG_READONLY_PROPERTY( std::string, HardwareAddress );
		IPMSG_PROPERTY( std::string, Nickname );
		IPMSG_PROPERTY( std::string, GroupName );
		IPMSG_PROPERTY( std::string, EncodingName );
		IPMSG_PROPERTY( std::string, Priority );
		IPMSG_PROPERTY( unsigned long, PortNo );
		IPMSG_PROPERTY( unsigned long, EncryptionCapacity );
		IPMSG_PROPERTY( std::string, PubKeyHex );
		IPMSG_PROPERTY( std::string, EncryptMethodHex );
		bool IsLocalHost() const;
		bool IsFileAttachSupport() const;
		bool IsEncryptSupport() const;
		bool IsAbsence() const;
		bool Equals( const HostListItem& item ) const;
		bool EqualsHardwareAddress( const HostListItem& item ) const;
		int Compare( const HostListItem& item ) const;
		int CompareHardwareAddress( const HostListItem& item ) const;
		void QueryVersionInfo();
		void QueryAbsenceInfo();
	private:
		std::string _IpAddress;
};

/**
 * ۥȰӥ饹
 *ʳApplicationɬפ˱ƤΥ饹ѾƽƤ
 **/
class HostListComparator{
	public:
		/**
		 * ӡ
		 * @param host1 ۥȾ1
		 * @param host2 ۥȾ2
		 * @retval -n:host1礭
		 * @retval 0:host1host2
		 * @retval +n:host2礭
		 */
		virtual int compare( std::vector<HostListItem>::iterator host1, std::vector<HostListItem>::iterator host2 )=0;
		virtual ~HostListComparator(){};
};

/**
 * ۥȰǥեȥӥ饹
 **/
class HostListDefaultComparator: public HostListComparator{
	public:
		/**
		 * ӡ
		 * @param host1 ۥȾ1
		 * @param host2 ۥȾ2
		 * @retval -n:host1礭
		 * @retval 0:host1host2
		 * @retval +n:host2礭
		 */
		virtual int compare( std::vector<HostListItem>::iterator host1, std::vector<HostListItem>::iterator host2 ){
			return host1->Compare( *host2 );
		};
};

/**
 * ۥȰ饹
 **/
class HostList{
	public:
		IPMSG_PROPERTY( bool, IsAsking );
		IPMSG_PROPERTY( time_t, AskStartTime );
		IPMSG_PROPERTY( time_t, PrevTry );
		IPMSG_PROPERTY( int, RetryCount );
		int AddHost( const HostListItem& host, bool isPermitSameHardwareAddress=true );
		void Delete( std::vector<HostListItem>::iterator &it );
		void DeleteHostByAddress( std::string addr );
		std::vector<HostListItem>::iterator FindHostByAddress( std::string addr );
		std::vector<HostListItem>::iterator FindHostByHostName( std::string hostName, int addressFamily );
		static HostListItem CreateHostListItemFromPacket( const Packet& packet );
		std::vector<HostListItem>::iterator begin();
		std::vector<HostListItem>::iterator end();
		int size() const;
		void clear();
		std::string ToString( int start, const struct sockaddr_storage *addr );
		void sort( HostListComparator *comparator );
		HostList();
		HostList( const HostList& other );
		~HostList();
		HostList& operator=( const HostList& other );
		std::vector<GroupItem> GetGroupList();
	private:
		void qsort( HostListComparator *comparator, int left, int right );
		void Lock( const char *pos ) const;
		void Unlock( const char *pos ) const;
		void CopyFrom( const HostList& other );
		std::vector<HostListItem>items;
		pthread_mutex_t hostListMutex;
};

/**
 * ե̾С饹
 * ʳApplicationɬפ˱ƤΥ饹ѾƽƤ
 **/
class FileNameConverter {
	public:
		virtual std::string ConvertNetworkToLocal( std::string original_file_name ) = 0;
		virtual std::string ConvertLocalToNetwork( std::string original_file_name ) = 0;
		virtual ~FileNameConverter(){};
};

/**
 * ե̵̾ѴС饹
 **/
class NullFileNameConverter:public FileNameConverter {
	public:
		virtual std::string ConvertNetworkToLocal( std::string original_file_name ){ return original_file_name; };
		virtual std::string ConvertLocalToNetwork( std::string original_file_name ){ return original_file_name; };
};

/**
 * źեե륯饹
 **/
class AttachFile{
	public:
		std::map<std::string, std::vector<unsigned long> >::iterator beginExtAttrs() { return _ExtAttrs.begin(); };
		std::map<std::string, std::vector<unsigned long> >::iterator endExtAttrs() { return _ExtAttrs.end(); };
		void addExtAttrs( std::string key, unsigned long val ){ _ExtAttrs[key].push_back( val ); };
		IPMSG_PROPERTY( int, FileId );
		IPMSG_PROPERTY( std::string, FullPath );
		IPMSG_PROPERTY( std::string, FileName );
		IPMSG_PROPERTY( std::string, Location );
		IPMSG_PROPERTY( long long, FileSize );
		IPMSG_PROPERTY( long long, TransSize );
		IPMSG_PROPERTY( bool, IsDownloaded );
		IPMSG_PROPERTY( bool, IsDownloading );
		IPMSG_PROPERTY( time_t, MTime );
		IPMSG_PROPERTY( unsigned long, Attr );

		AttachFile();
		bool IsRegularFile() const;
		bool IsDirectory() const;
		void GetLocalFileInfo();
	private:
		std::map<std::string, std::vector<unsigned long> > _ExtAttrs;
	public:
		static AttachFile AnalyzeHeader( char *buf, FileNameConverter *conv );
		static std::string CreateDirFullPath( const std::vector<std::string>& dirstack );
};

/**
 * ɾ󥯥饹
 **/
class DownloadInfo{
	public:
		IPMSG_PROPERTY( unsigned long long, Size );
		IPMSG_PROPERTY( time_t, Time );
		IPMSG_PROPERTY( long, FileCount );
		IPMSG_PROPERTY( bool, Processing );
		IPMSG_PROPERTY( std::string, LocalFileName );
		IPMSG_PROPERTY_REF( AttachFile, File );

		DownloadInfo():_Size( 0ULL ), _Time( 0 ), _FileCount( 0L ), _LocalFileName(""){};
		long double getSpeed();
		std::string getSpeedString();
		std::string getSizeString();
		static std::string getUnitSizeString( long long size );
};

/**
 * źեե饹
 **/
class AttachFileList{
	public:
		void AddFile( const AttachFile& file );
		std::vector<AttachFile>::iterator begin();
		std::vector<AttachFile>::iterator end();
		int size() const;
		void clear();
		std::vector<AttachFile>::iterator erase( std::vector<AttachFile>::iterator item );
		std::vector<AttachFile>::iterator erase( const AttachFile& item );
		std::vector<AttachFile>::iterator FindByFullPath( const std::string& fullPath );
		std::vector<AttachFile>::iterator FindByFileId( int file_id );
		AttachFileList();
		AttachFileList( const AttachFileList& other );
		~AttachFileList();
		AttachFileList& operator=( const AttachFileList& other );
	private:
		void Lock( const char *pos ) const;
		void Unlock( const char *pos ) const;
		void CopyFrom( const AttachFileList& other );
		std::vector<AttachFile> files;
		pthread_mutex_t filesMutex;
};

class IpMessengerEvent;

/**
 * å饹
 **/
class RecievedMessage{
	public:
		IPMSG_PROPERTY( Packet, MessagePacket );
		IPMSG_PROPERTY( std::string, Message );
		IPMSG_PROPERTY( time_t, Recieved );
		IPMSG_PROPERTY( bool, IsConfirmed );
		IPMSG_PROPERTY( bool, IsSecret );
		IPMSG_PROPERTY( bool, IsNoLogging );
		IPMSG_PROPERTY( bool, IsCrypted );
		IPMSG_PROPERTY( HostListItem, Host );
		IPMSG_PROPERTY( bool, IsPasswordLock );
		IPMSG_PROPERTY( bool, IsBroadcast );
		IPMSG_PROPERTY( bool, IsMulticast );
		IPMSG_PROPERTY( bool, HasAttachFile );
		IPMSG_PROPERTY_REF( AttachFileList, Files );
		RecievedMessage();
		RecievedMessage( const RecievedMessage& other );
		RecievedMessage& operator=( const RecievedMessage& other );
		bool DownloadFile( AttachFile &file, std::string saveFileNameFullPath, DownloadInfo& info, FileNameConverter *conv=NULL, void *data=NULL );
		bool DownloadDir( AttachFile &file, std::string saveDirName, std::string saveBaseDir, DownloadInfo& info, FileNameConverter *conv=NULL, void *data=NULL );
	private:
		void CopyFrom( const RecievedMessage& other );
		bool DownloadFilePrivate( IpMessengerEvent *event, AttachFile &file, std::string saveFileNameFullPath, DownloadInfo& info, FileNameConverter *conv=NULL, void *data=NULL );
		bool DownloadDirPrivate( IpMessengerEvent *event, AttachFile &file, std::string saveDirName, std::string saveBaseDir, DownloadInfo& info, FileNameConverter *conv=NULL, void *data=NULL );
		std::string GetFormalDir( std::string dirName );
		std::string GetSaveDir( std::string saveName, std::string saveBaseDir );
};

/**
 * å饹
 **/
class RecievedMessageList {
	public:
		std::vector<RecievedMessage>::iterator begin();
		std::vector<RecievedMessage>::iterator end();
		std::vector<RecievedMessage>::iterator erase( std::vector<RecievedMessage>::iterator item );
		void append( const RecievedMessage &item );
		int size() const;
		void clear();
		RecievedMessageList();
		RecievedMessageList( const RecievedMessageList& other );
		~RecievedMessageList();
		RecievedMessageList& operator=( const RecievedMessageList& other );
	private:
		void Lock( const char *pos ) const;
		void Unlock( const char *pos ) const;
		void CopyFrom( const RecievedMessageList& other );
		std::vector<RecievedMessage> messages;
		pthread_mutex_t messagesMutex;
};

/**
 * å饹
 **/
class SentMessage{
	public:
		IPMSG_PROPERTY( struct sockaddr_storage, To );
		IPMSG_PROPERTY( HostListItem, Host );
		IPMSG_PROPERTY( unsigned long, PacketNo );
		IPMSG_PROPERTY( std::string, Message );
		IPMSG_PROPERTY( time_t, Sent );
		IPMSG_PROPERTY( time_t, PrevTry );
		IPMSG_PROPERTY( bool, IsRetryMaxOver );
		IPMSG_PROPERTY( bool, IsSent );
		IPMSG_PROPERTY( bool, IsPasswordLock );
		IPMSG_PROPERTY( bool, IsCrypted );
		IPMSG_PROPERTY( int, RetryCount );
		IPMSG_PROPERTY( bool, IsConfirmed );
		IPMSG_PROPERTY( bool, IsConfirmAnswered );
		IPMSG_PROPERTY( bool, IsSecret );
		IPMSG_PROPERTY( bool, IsNoLogging );
		IPMSG_PROPERTY( int, HostCountAtSameTime );
		IPMSG_PROPERTY( unsigned long, Opt );
		IPMSG_PROPERTY_REF( AttachFileList, Files );
		SentMessage();
		SentMessage( const SentMessage& other );
		SentMessage& operator=( const SentMessage& other );
		bool isRetryMaxOver() const;
		bool needSendRetry( time_t tryNow ) const;
		std::vector<AttachFile>::iterator FindAttachFileByPacket( const Packet &packet );
	private:
		void CopyFrom( const SentMessage& other );
};

/**
 * å饹
 **/
class SentMessageList {
	public:
		std::vector<SentMessage>::iterator begin();
		std::vector<SentMessage>::iterator end();
		std::vector<SentMessage>::iterator erase( std::vector<SentMessage>::iterator item );
		std::vector<SentMessage>::iterator FindSentMessageByPacketNo( unsigned long PacketNo );
		std::vector<SentMessage>::iterator FindSentMessageByPacket( Packet packet );
		void append( const SentMessage &item );
		int size() const;
		void clear();
		std::vector<SentMessage> *GetMessageList();
		SentMessageList();
		SentMessageList( const SentMessageList& other );
		~SentMessageList();
		SentMessageList& operator=( const SentMessageList& other );

	private:
		void Lock( const char *pos ) const;
		void Unlock( const char *pos ) const;
		void CopyFrom( const SentMessageList& other );
		std::vector<SentMessage> messages;
		pthread_mutex_t messagesMutex;
};

/**
 * Ժߥ⡼ɥ饹
 **/
class AbsenceMode {
	public:
		IPMSG_PROPERTY( std::string, EncodingName );
		IPMSG_PROPERTY( std::string, AbsenceName );
		IPMSG_PROPERTY( std::string, AbsenceDescription );
};


/**
 * IP Messenger ٥ȥ饹
 * ʳApplicationϤΥ饹ѾƽƤ
 **/
class IpMessengerEvent {
	public:
		/**
		 * Υ٥ȳ٥(GUIåɤΥåƤ)
		 */
		virtual void EventBefore()=0;
		/**
		 * Υ٥Ƚλ奤٥(GUIåɤΥåƤ)
		 */
		virtual void EventAfter()=0;
		/**
		 * ۥȥꥹȥեå奤٥
		 * @param hostList ۥȥꥹ
		 */
		virtual void RefreshHostListAfter( HostList& hostList )=0;
		/**
		 * ۥȥꥹȹ奤٥
		 * @param hostList ۥȥꥹ
		 */
		virtual void UpdateHostListAfter( HostList& hostList )=0;
		/**
		 * ۥȥꥹȼȥ饤顼٥
		 * @retval true:ȥ饤
		 * @retval false:ȥ饤ʤ
		 */
		virtual bool GetHostListRetryError()=0;
		/**
		 * å奤٥ȡ
		 * @param msg å
		 * @retval true:ƥå¸
		 * @retval false:å¸
		 */
		virtual bool RecieveAfter( RecievedMessage& msg )=0;
		/**
		 * å奤٥
		 * @param msg å
		 */
		virtual void SendAfter( SentMessage& msg )=0;
		/**
		 * åŹ沽Υ٥ȡ
		 */
		virtual void NotifySendEncryptionFail( HostListItem& host )=0;
		/**
		 * åŹ沽ԥ٥ȡ
		 * @retval true:Ź沽
		 * @retval false:Ԥ
		 */
		virtual bool IsSendContinueOnEncryptionFail( HostListItem& host )=0;
		/**
		 * åȥ饤顼٥
		 * @param msg å
		 * @retval true:ȥ饤
		 * @retval false:ȥ饤ʤ
		 */
		virtual bool SendRetryError( SentMessage& msg )=0;
		/**
		 * θ奤٥
		 * @param msg å
		 */
		virtual void OpenAfter( SentMessage& msg )=0;
		/**
		 * ɳϥ٥
		 * @param msg å
		 * @param file źեե
		 * @param info ɾ
		 * @param data DownloadFileDownloadDirǻꤷǤեǡؤΥݥ
		 */
		virtual void DownloadStart( RecievedMessage& msg, AttachFile& file, DownloadInfo &info, void *data )=0;
		/**
		 * ɽ楤٥
		 * @param msg å
		 * @param file źեե
		 * @param info ɾ
		 * @param data DownloadFileDownloadDirǻꤷǤեǡؤΥݥ
		 */
		virtual void DownloadProcessing( RecievedMessage& msg, AttachFile& file, DownloadInfo &info, void *data )=0;
		/**
		 * ɽλ٥
		 * @param msg å
		 * @param file źեե
		 * @param info ɾ
		 * @param data DownloadFileDownloadDirǻꤷǤեǡؤΥݥ
		 */
		virtual void DownloadEnd( RecievedMessage& msg, AttachFile& file, DownloadInfo &info, void *data )=0;
		/**
		 * ɥ顼٥(ȥ饤TRUE֤)
		 * @param msg å
		 * @param file źեե
		 * @param info ɾ
		 * @param data DownloadFileDownloadDirǻꤷǤեǡؤΥݥ
		 * @retval true:ȥ饤
		 * @retval false:ȥ饤ʤ
		 */
		virtual bool DownloadError( RecievedMessage& msg, AttachFile& file, DownloadInfo &info, void *data )=0;
		/**
		 * ۥȤλθ奤٥
		 * @param host ۥ
		 */
		virtual void EntryAfter( HostListItem& host )=0;
		/**
		 * ۥȤæθ奤٥
		 * @param host ۥ
		 */
		virtual void ExitAfter( HostListItem& host )=0;
		/**
		 * Ժߥ⡼ɹ奤٥
		 * @param hostList ۥ
		 */
		virtual void AbsenceModeChangeAfter( HostListItem& host )=0;
		/**
		 * С奤٥
		 * @param host ۥ
		 * @param version С
		 */
		virtual void VersionInfoRecieveAfter( HostListItem &host, std::string version )=0;
		/**
		 * Ժ߾ܺپ奤٥
		 * @param host ۥ
		 * @param absenceDetail Ժ߾ܺپ
		 */
		virtual void AbsenceDetailRecieveAfter( HostListItem& host, std::string absenceDetail )=0;
		/**
		 * ǥȥ饯
		 */
		virtual ~IpMessengerEvent()=0;
};

class IpMessengerAgentImpl;

class Secret {
	public:
		explicit Secret( bool isSecret ):_IsSecret( isSecret ){};
		static Secret On() { return Secret( true ); };
		static Secret Off() { return Secret( false ); };
		IPMSG_READONLY_PROPERTY( bool, IsSecret );
};

class LockPassword {
	public:
		explicit LockPassword( bool isLockPassword ):_IsLockPassword( isLockPassword ){};
		static LockPassword On() { return LockPassword( true ); };
		static LockPassword Off() { return LockPassword( false ); };
		IPMSG_READONLY_PROPERTY( bool, IsLockPassword );
};

class Logging {
	public:
		explicit Logging( bool isLogging ):_IsLogging( isLogging ){};
		static Logging On() { return Logging( true ); };
		static Logging Off() { return Logging( false ); };
		IPMSG_READONLY_PROPERTY( bool, IsLogging );
};

/**
 * IP Messenger ȥ饹
 **/
class IpMessengerAgent {
	public:
		/**
		 * 󥹥󥹤
		 **/
		static IpMessengerAgent *GetInstance();

		/**
		 * 󥹥󥹤
		 **/
		static void Release();

		/**
		 * NICξ
		 **/
		static void GetNetworkInterfaceInfo( std::vector<NetworkInterface>& nics, bool useIPv6 );

		/**
		 * ֥ɥ㥹ȥɥ쥹ΥꥹȤ򥯥ꥢ
		 **/
		void ClearBroadcastAddress();

		/**
		 * ֥ɥ㥹ȥɥ쥹ΥꥹȤ饢ɥ쥹
		 **/
		void DeleteBroadcastAddress( std::string addr );

		/**
		 * ֥ɥ㥹ȥɥ쥹ΥꥹȤ˥ɥ쥹ɲ
		 **/
		void AddBroadcastAddress( std::string addr );

		/**
		 * ΥۥȤ鱣硢ʤۥȥɥ쥹ΥꥹȤ˥ɥ쥹ɲ
		 **/
		void AddSkulkHostAddress( std::string addr );

		/**
		 * ΥۥȤ鱣硢ʤۥȥꥹȤ˥ۥȤɲ
		 **/
		void AddSkulkHost( HostListItem &host );

		/**
		 * ΥۥȤ鱣硢ʤۥȥɥ쥹ΥꥹȤ饢ɥ쥹
		 **/
		void DeleteSkulkHostAddress( std::string addr );

		/**
		 * ΥۥȤ鱣硢ʤۥȥꥹȤۥȤ
		 **/
		void DeleteSkulkHost( HostListItem &host );

		/**
		 * ΥۥȤ鱣硢ʤۥȥɥ쥹ΥꥹȤ򥯥ꥢ
		 **/
		void ClearSkulkHost();

		/**
		 * ΥۥȤ鱣硢ʤۥȥɥ쥹ΥꥹȤ֤
		 **/
		HostList GetSkulkHost();

		/**
		 * ΡʻΡ
		 **/
		void Login( std::string nickname, std::string groupName );

		/**
		 * ΡæΡ
		 **/
		void Logout();

		/**
		 * ۥȥꥹȤ
		 **/
		HostList& GetHostList();

		/**
		 * ۥȥꥹȤ򹹿Ƽ
		 **/
		HostList& UpdateHostList();

		/**
		 * åź̵
		 **/
		bool SendMsg( HostListItem host, std::string msg, const Secret &isSecret, const LockPassword &isLockPassword=LockPassword::Off(), int hostCountAtSameTime=1, const Logging &isLogging=Logging::On(), unsigned long opt=0UL );

		/**
		 * åʰźա
		 **/
		bool SendMsg( HostListItem host, std::string msg, const Secret &isSecret, AttachFile& file, const LockPassword &isLockPassword=LockPassword::Off(), int hostCountAtSameTime=1, const Logging &isLogging=Logging::On(), unsigned long opt=0UL );

		/**
		 * åʣźա
		 **/
		bool SendMsg( HostListItem host, std::string msg, const Secret &isSecret, AttachFileList& files, const LockPassword &isLockPassword=LockPassword::Off(), int hostCountAtSameTime=1, const Logging &isLogging=Logging::On(), unsigned long opt=0UL );

		/**
		 * Ժ߲
		 **/
		void ResetAbsence();

		/**
		 * Ժ
		 **/
		void SetAbsence( std::string encoding, std::vector<AbsenceMode> absenceModes );

		/**
		 * 롼װ
		 **/
		std::vector<GroupItem> GetGroupList();

		/**
		 * С
		 **/
		std::string GetInfo( HostListItem& host );

		/**
		 * Ժ߾
		 **/
		std::string GetAbsenceInfo( HostListItem& host );

		/**
		 * ѥåȤνʥݡѡ
		 **/
		int Process();

		/**
		 * ѥåθĿ
		 **/
		int GetRecievedMessageCount();

		/**
		 * åμФ
		 **/
		RecievedMessage PopRecievedMessage();

		/**
		 * ˳Τ
		 **/
		void ConfirmMessage( RecievedMessage &msg );

		/**
		 * ˥åѴˤ
		 **/
		void DeleteNotify( RecievedMessage msg );

		/**
		 * ѥå˳ѤǤ뤳Ȥޡ
		 **/
		void AcceptConfirmNotify( SentMessage msg );

		/**
		 * åꥹȤμ
		 **/
		SentMessageList *GetSentMessages();

		/**
		 * åꥹȤΥԡμ
		 **/
		SentMessageList CloneSentMessages() const;

		/**
		 * ۥȥꥹӥ֥Ȥ
		 **/
		void SetSortHostListComparator( const HostListComparator *comparator );

		/**
		 * ۥȥꥹӥ֥Ȥμ
		 **/
		HostListComparator *GetSortHostListComparator() const;

		/**
		 * ٥ȥ֥Ȥ
		 **/
		void SetEventObject( const IpMessengerEvent *evt );

		/**
		 * ٥ȥ֥Ȥμ
		 **/
		IpMessengerEvent *GetEventObject() const;

		/**
		 * ե륳С
		 **/
		void SetFileNameConverter( const FileNameConverter *conv );

		/**
		 * ե륳Сμ
		 **/
		FileNameConverter *GetFileNameConverter() const;

		/**
		 * Ժߡ
		 **/
		bool IsAbsence() const;

		/**
		 * ͥåȥεưNIC
		 **/
		void StartNetwork( const std::vector<NetworkInterface>& nics );

		/**
		 * ͥåȥεư(ǥե)
		 **/
		void StartNetwork();

		/**
		 * ͥåȥνλ
		 **/
		void StopNetwork();

		/**
		 * ͥåȥκƵưNIC
		 **/
		void RestartNetwork( const std::vector<NetworkInterface>& nics );

		/**
		 * ͥåȥκƵư(ǥե)
		 **/
		void RestartNetwork();

		/**
		 * ̾
		 **/
		std::string LoginName() const;

		/**
		 * ۥ̾
		 **/
		std::string HostName() const;

		/**
		 * ǥեȥݡ
		 **/
		int DefaultPortNo() const;
		void setDefaultPortNo( const int defaultPortNo );

		/**
		 * 륢å
		 **/
		bool IsDialup() const;
		void setIsDialup( const bool isDialup );

		/**
		 * ե뤬ѹ줿ɤǤ
		 **/
		bool AbortDownloadAtFileChanged() const;
		void setAbortDownloadAtFileChanged( const bool isAbort );

		/**
		 * å򵭲
		 **/
		bool SaveSentMessage() const;
		void setSaveSentMessage( const bool isSave );

		/**
		 * å򵭲
		 **/
		bool SaveRecievedMessage() const;
		void setSaveRecievedMessage( const bool isSave );

		/**
		 * Ź沽˼Ԥåʤ
		 **/
		bool NoSendMessageOnEncryptionFailed() const;
		void setNoSendMessageOnEncryptionFailed( const bool isNoSend );

		/**
		 * IPv6Ѥ롣
		 **/
		bool UseIPv6() const;
		void setUseIPv6( const bool useIPv6 );

		/**
		 * APIΥݡȾĴ٤롣
		 **/
		bool isSupportIPv6();
		bool isSupportIPv4();
	private:
		IpMessengerAgent();
		~IpMessengerAgent();
		IpMessengerAgentImpl *ipmsgImpl;
};

}; // namespace ipmsg
#endif
