
//LogConfig.add({category: 'com.gui.imageView', level: LOG_LEVEL.DEBUG});

WUI.ImageView = new Object();
WUI.ImageView.logger = LoggerFactory.create("com.gui.imageView");

WUI.ImageView.Angle = Class.create();
Object.extend(WUI.ImageView.Angle.prototype, {
  initialize: function(src) {
    this.x     = 0;
    this.y     = 0;
    this.ratio = 0;
    if (src) {
      this.x     = src.x;
      this.y     = src.y;
      this.ratio = src.ratio;
    }
  },
  clone: function() {
    return new WUI.ImageView.Angle(this);
  },
  inspect: function() {
    return "x:" + this.x + " y:" + this.y + " r:" + this.ratio;
  }
});

//------------------------------------------------------------------------------
//ツールホルダ
WUI.ImageView.Tools = new Object();

//------------------------------------------------------------------------------
// ツールの空実装
WUI.ImageView.Tools.Template = Class.create();
WUI.ImageView.Tools.Template.prototype = {
  initialize: function(view) {
    if (view) {	//クラス生成時、引数なしのケースあり
      this.view      = view;
      this.eventVars = view.eventVars;
    }
  },
  click     : function(e) {return false},
  down      : function(e) {return false},
  move      : function(e) {return false},
  drag      : function(e) {return false},
  up        : function(e) {return false},
  out       : function(e) {return false},
  start     : function() {},
  end       : function() {},
  restart   : function() {this.end();this.start();},
  callback  : function() {}
};

//------------------------------------------------------------------------------
// 移動ツール
WUI.ImageView.Tools.Move = Class.create();
WUI.ImageView.Tools.Move.prototype = Object.extend(new WUI.ImageView.Tools.Template(), {
  start: function() {
    Element.setStyle(this.view.imgObj, {cursor: 'move'});
  },

  end: function() {
    Element.setStyle(this.view.imgObj, {cursor: ''});
  },

  click: function(e) {
    WUI.ImageView.logger.debug("move tool clicked");

    var v = this.view;
    var obj = v.divObj;

    var lx = WUI.Event.layerX(e, v.divObj.id);
    var ly = WUI.Event.layerY(e, v.divObj.id);
    var cx = v.imgParam.width  / 2;
    var cy = v.imgParam.height / 2;
    var r  = v.state.ratio;

    var x  = cx - lx / r;
    var y  = cy - ly / r;
    WUI.ImageView.logger.debug("x:" + x + " y:" + y);
    v.moveTo(x, y, v.animation.used);
  },
  
  down: function(e) {
    WUI.ImageView.logger.debug("move tool down");

    this.eventVars.imgX = WUI.Util.getElementX(this.view.divObj);
    this.eventVars.imgY = WUI.Util.getElementY(this.view.divObj);
  
    Event.stop(e);	//停止しないとドラックできない
    return true;
  },
   
  drag: function(e) {
    var ev = this.eventVars;
    var x = Event.pointerX(e) - ev.lastPointerX + new Number(ev.imgX);
    var y = Event.pointerY(e) - ev.lastPointerY + new Number(ev.imgY);
    Event.stop(e);	//停止しないとドラックできない
    WUI.Util.setPosition(this.view.divObj, x, y);
  },
      
  up: function(e, vars) {
    var v = this.view;
    v.setByPixel(WUI.Util.getElementX(v.divObj), WUI.Util.getElementY(v.divObj));
    this.callback.call(v, v.state);

    WUI.ImageView.logger.debug("move tool up");
  }
});

//------------------------------------------------------------------------------
// 矩形選択
WUI.ImageView.Tools.Rect = Class.create();
WUI.ImageView.Tools.Rect.prototype = Object.extend(new WUI.ImageView.Tools.Template(), {
  start: function() {
    var v = this.view;
    Element.setStyle(this.view.imgObj, {cursor: 'crosshair'});
    this.view.toolObj = "";
    this.parent = this.view.divObj;
//    this.parent = this.view.parent;

    this.running = false;
  },

  end: function() {
    Element.setStyle(this.view.imgObj, {cursor: ''});
    this.removeToolObj(this.view);
    this.running = false;
  },
  
  down: function(e) {
    var v  = this.view;
    var ev = this.eventVars;

    var obj = v.toolObj;
    if (obj) {
      //２回目のクリック
//      WUI.ImageView.logger.debug("[rect]second point clicked.");
      this.running = false;

      var x = WUI.Util.getElementX(obj);
      var y = WUI.Util.getElementY(obj);
      var w = WUI.Util.getElementWidth( obj);
      var h = WUI.Util.getElementHeight(obj);
      var cx = v.imgParam.width  / 2;
      var cy = v.imgParam.height / 2;
      var r  = v.state.ratio;

      var ret = new Object();
      ret.left   = cx - (x + w) / r;
      ret.top    = cy - (y + h) / r;
      ret.right  = cx - x / r;
      ret.bottom = cy - y / r;
      ret.x      = cx - (x + w / 2) / r;
      ret.y      = cy - (y + h / 2) / r;
      ret.width  = w / r;
      ret.height = h / r;
      WUI.ImageView.logger.debug(ret);

      this.callback.call(v, ret);
      
      this.removeToolObj(v);

    } else {
      //１回目のクリック
      var x = WUI.Event.layerX(e, v.divObj.id);
      var y = WUI.Event.layerY(e, v.divObj.id);
      
      WUI.ImageView.logger.debug("[rect]first point clicked. x=" + x + " y=" + y);
      this.createToolObj(v, x, y);
      this.running = true;
    }
  },
   
  move: function(e) {
    var obj = this.view.toolObj;
    if (!obj || !this.running) return;

    var x2 = WUI.Event.layerX(e, this.view.divObj.id);
    var y2 = WUI.Event.layerY(e, this.view.divObj.id);
    //TODO たぶんここは不要
    if (Event.element(e) != this.view.imgObj) {
      x2 = this.eventVars.lastLayerX + Event.pointerX(e) - this.eventVars.lastPointerX;
      y2 = this.eventVars.lastLayerY + Event.pointerY(e) - this.eventVars.lastPointerY;
    }
//  WUI.ImageView.logger.debug(Event.element(e).id + " x:" + x2 + " y:" + y2);
    var x  = this.eventVars.lastLayerX;
    var y  = this.eventVars.lastLayerY;
    var w = x2 - x;
    var h = y2 - y;

    if (w < 0) {
      w = w * -1;
      x = x - w;
    }
    if (h < 0) {
      h = h * -1;
      y = y - h;
    }

    WUI.Util.setPosition(obj, x, y);
    WUI.Util.setSize(obj, w, h);
  },
  
  createToolObj : function(view, x, y) {
    var options = {
      cursor   : 'crosshair',
      overflow : 'hidden',
      position : 'absolute', /* relative absolute */
      border   : '1px solid #FF0000',

      backgroundColor: "#ffcccc",
      filter   : 'alpha(opacity=50)',
      opacity  : '0.5',

      left     : x + 'px',
      top      : y + 'px',
      width    : '1px',
      height   : '1px'
    };

    var obj = document.createElement('div');

    view.toolObj = obj;
    Element.setStyle(obj, options);
    this.parent.appendChild(obj);
  },
  
  removeToolObj : function(view) {
    var obj = view.toolObj;
    if (!obj) return;
 
    this.parent.removeChild(obj);
    view.toolObj = null;
  }
});

//------------------------------------------------------------------------------
// 矩形ズーム
WUI.ImageView.Tools.LocalRectZoom = Class.create();
WUI.ImageView.Tools.LocalRectZoom.prototype = Object.extend(new WUI.ImageView.Tools.Rect(), {
  callback: function(param) {
//a    this.zoomRect(param, this.animation.used);
    this.zoomRect(param, 1);
  }
});


















//------------------------------------------------------------------------------
// イメージビューのユーザーモデル。これをnewしてください。
WUI.ImageView.Area = Class.create();
Object.extend(WUI.ImageView.Area.prototype, {
  initialize: function(divObj, id, viewParam, imgParam) {
    WUI.ImageView.logger.debug("WUI.ImageView.Area#initialize");

    this.divObj  = null;
    this.imgObj  = null;
    this.toolObj = null;

    // イベントハンドラ用変数
    this.eventVars = {
      mode        : "",
      dragging    : false,
      press       : false,
      lastPointerX: 0,  //前回mouseDown位置x(ドキュメント内)
      lastPointerY: 0,  //前回mouseDown位置y(ドキュメント内)
      lastLayerX  : 0,  //前回mouseDown位置x(オブジェクト内)
      lastLayerY  : 0,  //前回mouseDown位置y(オブジェクト内)
      imgX        : 0,  //クリック時画像位置x
      imgY        : 0,  //クリック時画像位置y
      width       : 0,  //
      height      : 0   //
    };

    this.state = {
      tool   : null,
      ratio  : 1.0,
      x      : 0,
      y      : 0
    };

    this.parent    = divObj;
    this.id        = id;
    this.viewParam = viewParam;
    this.imgParam  = imgParam;

    //for animation
    this.animation = new Object();
    this.animation.tick = 0.05;		//0.025
    this.animation.used = 0.2;		//0.5
/*  this.animation.used = null; アニメさせない場合*/
    this.animation.cue  = new WUI.Cue();
    new PeriodicalExecuter(this._timerCallback.bind(this), this.animation.tick);

    //check parameters
    if (!viewParam.width) {
      WUI.ImageView.logger.warn("viewParam.widthが設定されていません。");
      return;
    }
    if (!viewParam.height) {
      WUI.ImageView.logger.warn("viewParam.heightが設定されていません。");
      return;
    }
    if (!imgParam.width) {
      WUI.ImageView.logger.warn("imgParam.widthが設定されていません。");
      return;
    }
    if (!imgParam.height) {
      WUI.ImageView.logger.warn("imgParam.heightが設定されていません。");
      return;
    }

    this._createElement(this.viewParam, this.imgParam);
    this._setEventHandler();
    this.show();
  },

  moveTo: function(x, y, usedTime) {
    WUI.ImageView.logger.debug("moveTo x:" + x + " y:" + y);
    if (isNaN(x)) {
      x = this.state.x;
    }
    if (isNaN(y)) {
      y = this.state.y;
    }  
  
    if (usedTime) {
      var src = new WUI.ImageView.Angle(this.state);
      var dst = new WUI.ImageView.Angle();
      dst.x     = x;
      dst.y     = y;
      dst.ratio = this.state.ratio;
      this._animate(src, dst, usedTime);
    } else {
      WUI.Util.setPosition(this.divObj,
          this._mapToPixelX(x),
          this._mapToPixelY(y));
      this.state.x = x;
      this.state.y = y;
    }
  },

  moveCenter: function(usedTime) {
    this.moveTo(0, 0, usedTime);
  },



  zoomTo: function(ratio, usedTime) {
    WUI.ImageView.logger.debug("zoomTo ratio:" + ratio);
    if (usedTime) {
      var src = new WUI.ImageView.Angle(this.state);
      var dst = new WUI.ImageView.Angle();
      dst.x     = this.state.x;
      dst.y     = this.state.y;
      dst.ratio = ratio;
      this._animate(src, dst, usedTime);
    } else {
      WUI.Util.setSize(this.divObj,
          this.imgParam.width  * ratio,
          this.imgParam.height * ratio);
      this.state.ratio = ratio;
      this.moveTo();
    }
  },

  zoom: function(ratio, usedTime) {
    this.zoomTo(this.state.ratio * ratio, usedTime);
  },
  
  zoomRect: function(param, usedTime) {
    var rx = this.viewParam.width  / param.width;
    var ry = this.viewParam.height / param.height;
    var r  = (rx < ry) ? rx : ry;
    var x = param.x;
    var y = param.y;

    if (usedTime) {
      var src = new WUI.ImageView.Angle(this.state);
      var dst = new WUI.ImageView.Angle();
      dst.x     = x;
      dst.y     = y;
      dst.ratio = r;
      this._animate(src, dst, usedTime);

    } else {
      this.zoomTo(r);
      this.moveTo(x, y);
    }
  },

  zoomAll: function(usedTime) {
    var w = this.imgParam.width;
    var h = this.imgParam.height;

    var ret = new Object();
    ret.left   = 0;
    ret.top    = 0;
    ret.right  = w;
    ret.bottom = h;
    ret.x      = 0;
    ret.y      = 0;
    ret.width  = w;
    ret.height = h;
    
    this.zoomRect(ret, usedTime);
  },
  
  setByPixel: function(x, y) {
    this.state.x = this._pixelToMapX(x);
    this.state.y = this._pixelToMapY(y);
  },

  _animate: function(src, dist, usedTime) {
    WUI.ImageView.logger.debug("_animate src[" + src.inspect() + "]dst[" + dist.inspect() + "]");

    var tick  = this.animation.tick;
    var count = parseInt(usedTime / tick); 
    var cue   = this.animation.cue;
    for (var i = 0; i <= count; i++) {
      var st = new WUI.ImageView.Angle();
      st.ratio  = src.ratio + (dist.ratio - src.ratio) * (i / count);
      st.x      = src.x + (dist.x - src.x) * (i / count);
      st.y      = src.y + (dist.y - src.y) * (i / count);

      cue.addTail(new WUI.Cue(st));
      cue = cue.next;
    }
  },
  
  _timerCallback: function() {
//    if (!this.animation) return;
    
    var cue = this.animation.cue;
    var st = cue.obj;
    if (!st) {
      if (cue.next) {
        this.animation.cue = cue.removeHead();
        this._timerCallback();
      }
      return;
    }
//  WUI.ImageView.logger.debug("_timerCallback-->" + st.inspect());
    
    var r = st.ratio;
    WUI.Util.setSize(this.divObj,
        this.imgParam.width * r,   this.imgParam.height * r);
    WUI.Util.setPosition(this.divObj,
        this._mapToPixelX(st.x, r), this._mapToPixelY(st.y, r));
    this.state.x     = st.x;
    this.state.y     = st.y;
    this.state.ratio = st.ratio;

    if (cue.next) {
      this.animation.cue = cue.removeHead();
    } else {
      this.animation.cue = new WUI.Cue();
    }
  },





  
  show: function() {
    this.zoomAll();
  },

  setTool: function(toolName, callbackFunction) {
    var oldTool = this.state.tool;
    var newTool = this._createTool(toolName);
    if (oldTool && newTool && oldTool == newTool) {
      this.state.tool.restart(this);
    } else {
      if (oldTool) {
        oldTool.end(this);
      }    
      if (newTool) {
        newTool.start(this);
      }
    }
    
    if (callbackFunction) {
      newTool.callback = callbackFunction;
    }
    
    this.state.tool = newTool;
  },
  
  _createTool: function(toolName) {
    if (toolName == "move") return new WUI.ImageView.Tools.Move(this);
    if (toolName == "rect") return new WUI.ImageView.Tools.Rect(this);
    if (toolName == "zoom") return new WUI.ImageView.Tools.LocalRectZoom(this);
  },



  _mouseDown: function(e) {
    var vars = this.eventVars;
    var tool = this.state.tool;
    if (!tool) return;

    vars.lastPointerX = Event.pointerX(e);
    vars.lastPointerY = Event.pointerY(e);
    vars.lastLayerX   = WUI.Event.layerX(e, this.divObj.id);
    vars.lastLayerY   = WUI.Event.layerY(e, this.divObj.id);
    vars.press        = true;
    vars.dragging     = tool.down(e, vars, this);
  },

  _mouseMove: function(e) {
    var vars = this.eventVars;
    var tool = this.state.tool;
    if (!tool) return;

    if (vars.dragging) {
      tool.drag(e, vars, this);
    } else {
      tool.move(e, vars, this);
    }
  },

  _mouseUp: function(e) {
    var vars = this.eventVars;
    var tool = this.state.tool;
    if (tool) {
      tool.up(e, vars, this);

      var x = Event.pointerX(e);
      var y = Event.pointerY(e);
      if (vars.press && (vars.lastPointerX - x) == 0 && (vars.lastPointerY - y) == 0) {
	    tool.click(e, vars, this);
	    vars.press = false;
      }
    }
    vars.dragging = false;
  },
  
  _mouseOut: function(e) {
    var vars = this.eventVars;
    var tool = this.state.tool;
    if (tool) {
      tool.out(e, vars, this);
    }
    vars.dragging = false;
  },

  

  _createElement: function(viewParam, imgParam) {
    var divId = this.id + "_div";
    var imgId = this.id + "_img";
    
    //親
    WUI.Util.setSize(this.parent, viewParam.width, viewParam.height);
    Element.setStyle(this.parent, {overflow: 'hidden'});

    //imgを入れるdiv
    var options = {
      style : {
        backgroundColor: '#dddddd',
        top     : '0px',
        left    : '0px',
        width   : imgParam.width  + 'px',
        height  : imgParam.height + 'px',
        position: 'relative' /* relative absolute */
      }
    };
    var div = new Html.Data.Div(divId, options);
    this.divObj = Html.create(div);
    
    //img
    var img = {
      tag		: 'img',
      id		: imgId,
      attribute	: {
        src       : imgParam.src
      },
      style		: {
        border    : '0px',
        left      : '0px',
        top       : '0px',
        width     : '100%',
        height    : '100%'
//        width     : imgParam.width  + 'px',
//        height    : imgParam.height + 'px'
      }
    };
    this.imgObj = Html.create(img);

    //内包させる
    this.divObj.appendChild(this.imgObj);
    this.parent.appendChild(this.divObj);
  },
  
  _setEventHandler: function() {
    Event.observe(this.divObj, 'mousedown', this._mouseDown.bind(this), true);
    Event.observe(this.divObj, 'mousemove', this._mouseMove.bind(this), true);
    Event.observe(this.parent, 'mouseup',   this._mouseUp.bind(this),   true);
    Event.observe(this.parent, 'mouseout',  this._mouseOut.bind(this),  true);
  },
  
  
  
  _mapToPixelX: function(x, r) {
    if (!r) r = this.state.ratio;
    return x * r + this.viewParam.width  / 2 - this.imgParam.width  * r / 2;
  },
  _mapToPixelY: function(y, r) {
    if (!r) r = this.state.ratio;
    return y * r + this.viewParam.height / 2 - this.imgParam.height * r / 2;
  },

  _pixelToMapX: function(x, r) {
    if (!r) r = this.state.ratio;
    return x / r - this.viewParam.width  / (2 * r) + this.imgParam.width  / 2;
  },
  _pixelToMapY: function(y, r) {
    if (!r) r = this.state.ratio;
    return y / r - this.viewParam.height / (2 * r) + this.imgParam.height / 2;
  }
});

