/*
 *  Live2DModelD3D.h
 *
 * 
 *  Copyright(c) Live2D Inc. All rights reserved.
 *  [[ CONFIDENTIAL ]]
 */
#ifndef __LIVE2D_L2DMODEL_D3D_H__
#define __LIVE2D_L2DMODEL_D3D_H__

#include "Live2D.h"

#ifdef L2D_TARGET_D3D

#include "ALive2DModel.h"
#include "model/ModelImpl.h"
#include "graphics/DrawParam_D3D.h"

//--------- LIVE2D NAMESPACE ------------
namespace live2d 
{
	class ModelContext ;

	
	class Live2DModelD3D : public live2d::ALive2DModel
	{
	public:
		// foCXZbg
		static void setDevice( LPDIRECT3DDEVICE9 device );

		// NbsO}XNp̃eNX`ݒ肷
		static void setMaskTexture(LPDIRECT3DTEXTURE9 maskTexture);

		// NbsO}XNp̃T[tF[Xݒ肷
		static void setMaskSurface(LPDIRECT3DSURFACE9 maskSurface);

		// foCXXgɋʂČĂяo
		static void deviceLostCommon();

		// foCXZbgɋʂČĂяo
		static void deviceResetCommon();

	public:
		Live2DModelD3D(void) ;
		virtual ~Live2DModelD3D(void) ;

	public:
		// o^ꂽeNX`j
		// eNX`OŋLĂꍇ邽
		// o^ꂽeNX`͎Iɂ͔jȂB
		// jɂDestructoȓOɖIɌĂԕKvB
		void deleteTextures() ;
		
		virtual void draw() ;

		void setTexture( int textureNo , LPDIRECT3DTEXTURE9 openGLTextureNo ) ;
		
		static Live2DModelD3D * loadModel( const live2d::LDString & filepath ) ;
		static Live2DModelD3D * loadModel( const void * buf , int bufSize ) ;

		// VpłModel̃eNX`ԍm(Avatarp)
		virtual int generateModelTextureNo() ;
		
		// Model̃eNX`ԍ𐶐(Avatarp)
		virtual void releaseModelTextureNo(int no) ;
		
		int getErrorD3D_tmp()
		{
			return drawParamD3D->getErrorD3D_tmp() ;
		}


		// Direct3D̃foCXXg̏
		void deviceLostD3D( ) ;

		virtual live2d::DrawParam* getDrawParam(){ return drawParamD3D ; }

		void setTextureColor(int textureNo,float r,float g,float b);
		void setTextureBlendMode(int textureNo,int mode);
		void setTextureInterpolate(int textureNo, float interpolate);

	private:
		// Prevention of copy Constructor
		Live2DModelD3D( const Live2DModelD3D & ) ;				
		Live2DModelD3D& operator=( const Live2DModelD3D & ) ; 	
		 
	private:
		live2d::DrawParam_D3D * 		drawParamD3D ;		// Direct3D̕`p[^i[p

	};
}
//--------- LIVE2D NAMESPACE ------------


#endif		//L2D_TARGET_D3D
#endif		//__LIVE2D_L2DMODEL_D3D_H__