/**
 *  ModelContext.h
 * 
 *  Copyright(c) Live2D Inc. All rights reserved.
 *  [[ CONFIDENTIAL ]]
 */
#ifndef __LIVE2D_MODEL_CONTEXT_H__
#define __LIVE2D_MODEL_CONTEXT_H__


#include "Live2D.h"
#include "memory/LDObject.h"
#include "type/LDVector.h"
#include "DEF.h"

#if L2D_VERBOSE
#include "util/UtDebug.h"
#endif

//------------ LIVE2D NAMESPACE ------------
namespace live2d
{ 
	
	class ParamID ;
	class BaseDataID ;
	class PartsDataID ;
	class DrawDataID ;
	class IBaseData ;
	class IDrawData ;
	class PartsData ;
	class ALive2DModel ;
	class DrawParam ;
	class IBaseContext ;
	class IDrawContext ;
	class PartsDataContext ;
		
	#define _PARAM_FLOAT_MIN_ (-1000000) 
	#define _PARAM_FLOAT_MAX_ ( 1000000) 
	
	
	class ModelContext : public live2d::LDObject 
	{
	public:
		static const unsigned short NOT_USED_ORDER ; 
		static const unsigned short NO_NEXT ; 
	
	
	public:
		ModelContext(ALive2DModel *model) ;
		virtual ~ModelContext(void) ;
	
	public:
		// 
		void release() ;
		
		// Bsetup()̑OɈxĂԁB\ςꍇĂԁB
		void init() ;
	
		// ꊇǗ邽߂MemoryParamԂ
		MemoryParam*  getMemoryParam(){ return memoryManagement ; }
	
		// ̃o[W擾iďƃLbVɂȂ邽߁j
		inline int getInitVersion() const { return initVersion ; }
	
		inline bool requireSetup() const { return needSetup ; }
		
		// ݂̃p[^lŕ`p̃f[^𐶐
		bool update() ;
	
		// `
		void draw(DrawParam &dp) ;
	
	
				
		inline bool isParamUpdated( int paramIndex ) const { 
# if L2D_FORCE_UPDATE
			return true ;
# else
			return (*updatedFloatParamFlagsPtr)[ paramIndex ] == PARAM_UPDATED ; 
# endif
		}

		// paramIDANZXpparamIndex擾
		int getParamIndex( ParamID * paramID )   ;

		// BaseDataIDANZXp baseIndex 擾
		int getBaseDataIndex( BaseDataID * baseID ) ;

		// PartsDataIDANZXp partsIndex 擾
		int getPartsDataIndex( PartsDataID * partsID ) ;

		// drawDataIDANZXp drawDataIndex 擾
		int getDrawDataIndex( DrawDataID * drawDataID ) ;
	
		inline unsigned short * getTmpPivotTableIndicesRef(){ return tmpPivotTableIndices_short ; }
		inline float * getTmpT_ArrayRef(){ return tmpT_array ; }
		
	
		// floatp[^ǉ
		int addFloatParam( ParamID * id , l2d_paramf value , l2d_paramf min , l2d_paramf max ) ;
	
	
		void setBaseData( unsigned int baseDataIndex , IBaseData * baseData ) ;
	
	
		void setParamFloat( unsigned int paramIndex , l2d_paramf value ) ;
	
		float getParamMax( unsigned int paramIndex ){ return (*floatParamMaxListPtr)[paramIndex] ; }
		float getParamMin( unsigned int paramIndex ){ return (*floatParamMinListPtr)[paramIndex] ; }
		
		// OsaveParamp[^l𕜌isaveParamĂȂΉȂj
		void loadParam() ;

		// ݂̃p[^lۑ
		void saveParam() ;
	
		// p[c̕sxZbg
		void setPartsOpacity( int partIndex , float opacity ) ;
	
		// p[c̕sx擾
		float getPartsOpacity( int partIndex ) ;
		
	
		
		inline IBaseData* getBaseData( unsigned int baseDataIndex )
		{

	# if L2D_RANGE_CHECK		
			if( baseDataIndex >= baseDataListPtr->size() )
			{
	
				L2D_THROW( "out of range ModelDrawContext@getBaseData()" ) ;
			}
	# endif
			return (*baseDataListPtr)[ baseDataIndex ] ;// ͈͊O͖`iOŃ`FbNj
		}

		
		inline IDrawData* getDrawData( unsigned int drawDataIndex )
		{
	# if L2D_RANGE_CHECK		
			if( drawDataIndex >= (*drawDataListPtr).size() )
			{
	
				L2D_THROW( "out of range ModelDrawContext@getBaseData()" ) ;
			}
	# endif
			return (*drawDataListPtr)[ drawDataIndex ] ;// ͈͊O͖`iOŃ`FbNj
		}
	
		
		inline IBaseContext* getBaseContext( unsigned int baseDataIndex )
		{
			return (*baseContextListPtr)[ baseDataIndex ] ;// ͈͊O͖`iOŃ`FbNj
		}

		
		inline IDrawContext* getDrawContext( unsigned int drawDataIndex )
		{
			return (*drawContextListPtr)[ drawDataIndex ] ;// ͈͊O͖`iOŃ`FbNj
		}

		
		inline PartsDataContext* getPartsContext( unsigned int partsDataIndex )
		{
			return (*partsContextListPtr)[ partsDataIndex ] ;// ͈͊O͖`iOŃ`FbNj
		}

		
		inline int getBaseDataCount(){	return (int)baseDataListPtr->size() ; }

		
		inline int getDrawDataCount(){	return (int)drawDataListPtr->size() ; }

		
		inline int getPartsDataCount(){	return (int)partsDataListPtr->size() ; }
		
		// partsf[^擾܂
		inline l2d_paramf getParamFloat( unsigned int paramIndex )
		{

	# if L2D_RANGE_CHECK
			if( paramIndex >= floatParamListPtr->size() )
			{
	
				L2D_THROW( "out of range ModelDrawContext@getParamFloat()" ) ;
			}
	# endif
			return (*floatParamListPtr)[ paramIndex ] ;
		}
		
		// DirectXfoCXXgɌĂяo
		void deviceLost( ) ;
		
		/*
		 * ZBufferݒ肷
		 *
		 * ʏ`ɂ͕KvȂ̂Zl͐ݒ肳ȂA
		 * tF[hCEAEgȂǂ̓x`悷ꍇɎg܂B
		 * update()draw()̊ԂŌĂяoĉB
		 * 
		 * startZ	Ԕwʂɂ|SZl
		 * stepZ	ZlXVXebv
		 * 
		 */
		void updateZBuffer_TestImpl( float startZ , float stepZ ) ;
	
	#if L2D_SAMPLE
		void DUMP_PARAMS() ;
	#endif
	
	
	private:
		enum { PARAM_NOT_UPDATED = 0,	PARAM_UPDATED	};
		
		//Prevention of copy Constructor
		ModelContext( const ModelContext & ) ;				
		ModelContext& operator=( const ModelContext & ) ; 	

		void initValue();
		
	private:	
		bool 							needSetup ;						// ŏsetupłȂꍇ true
		ALive2DModel * 					model ;							// 
	
	
		int 							initVersion ;					// initso[WB̃o[WقȂꍇ́ALbVꂽindexlȂǂƂ݂Ȃ
		// ------------ p[^lifloatj ------------
		LDVector<ParamID *>*			floatParamIDListPtr ;			// Ȃ
		LDVector<l2d_paramf>*			floatParamListPtr ;				// float ^̃p[^le[uiparamIndexŃANZXj
		LDVector<l2d_paramf>*			lastFloatParamListPtr ;			// Oupatẽp[^le[uiparamIndexŃANZXj0.9.00b19 2011/10/27
		
		//-- 
		LDVector<l2d_paramf>*			floatParamMinListPtr ;			// float ^̃p[^Aŏle[uiparamIndexŃANZXj
		LDVector<l2d_paramf>*			floatParamMaxListPtr ;			// float ^̃p[^Aőle[uiparamIndexŃANZXj
		
		LDVector<l2d_paramf>*			savedFloatParamListPtr ;		// saveParam() ɂۑꂽԂfloat ^̃p[^le[uiparamIndexŃANZXj
	
		// XVꂽp[^̃tO𗧂Ă  updatedFloatParamFlags[paramIndex] = 0 or 1(updated)
		LDVector<char>*					updatedFloatParamFlagsPtr ;		// booltO͗ǂȂ̂unsigned char
		
		// ------------ setup̂߂ ------------
		// Wϊ 
		// 	\߈ˑ֌W̖ŕׂĂƂŁAsetupOnDemandBuildersvɂ
		// 	indexŃANZX邽init()ȊOŏύX͂Ȃ
		LDVector<IBaseData*>*			baseDataListPtr ;				// Ȃ(Modelȉɏj
		
		// 	visible drawDatâ݂XgBsetup̃I[_[Ȃǂ̐ł͂ index p
		LDVector<IDrawData*>*			drawDataListPtr ;				// Ȃ(Modelȉɏj
	
		LDVector<PartsData*>*			partsDataListPtr ;				// Ȃ(Modelȉɏj
		
		// --- context data (`p̉Zʂ̃Xg)---
		LDVector<IBaseContext*>*		baseContextListPtr ;			// 
		LDVector<IDrawContext*>*		drawContextListPtr ;			// 
		LDVector<PartsDataContext*>*	partsContextListPtr ;			// 
	
		// I[_[ǗpiɃj
		// Y͓ , 0͔ԕ
		LDVector<unsigned short>*		orderList_firstDrawIndexPtr ;	// order 1000 I[_[̍ŏ sub listindex
		LDVector<unsigned short>*		orderList_lastDrawIndexPtr  ;	// order 1000 I[_[̍Ō sub listindex
		
		// Y drawDataList Ɠ
		LDVector<unsigned short>*		nextList_drawIndexPtr ;			// drawDataindexƈvBlNO_NEXT
		
		// ----------- Ԃ̕⏕pꎟf[^i}`XbhΉj -----------
		unsigned short 					tmpPivotTableIndices_short [DEF::PIVOT_TABLE_SIZE] ;	// ݕԂ悤ƂĂvf̊es{bgԍL^(Ō-1Fԕ)
		float 							tmpT_array[DEF::MAX_INTERPOLATION*2] ;					// 傫ڂɊm
	
		MemoryParam*					memoryManagement ;
		AMemoryHolder*					memoryHolderFixedMain ;
		AMemoryHolder*					memoryHolderFixedGPU ;
		
	};
}
//------------ LIVE2D NAMESPACE ------------

#endif		// __LIVE2D_MODEL_CONTEXT_H__