/**
 *  IDrawData.h
 *
 *  Copyright(c) Live2D Inc. All rights reserved.
 *  [[ CONFIDENTIAL ]]
 */

#ifndef __LIVE2D_IDRAWDATA_H__
#define __LIVE2D_IDRAWDATA_H__


#ifndef __SKIP_DOC__

#include "../Live2D.h"
#include "../io/ISerializableV2.h"
#include "../id/BaseDataID.h"
#include "IDrawContext.h"
#include <stdio.h>


//------------ LIVE2D NAMESPACE ------------
namespace live2d
{
	class DrawDataID ;
	class ModelContext ;
	class PivotManager ;
	class DrawParam ;

	
	class IDrawData : public ISerializableV2
	{
	public:
		static const int BASE_INDEX_NOT_INIT 	= -2 ;
		static const int DEFAULT_ORDER 			= 500 ;
		static const int TYPE_DD_TEXTURE 		= 2 ;
	public:	
		IDrawData();
		virtual ~IDrawData();
	
		virtual void readV2(BReader & br , MemoryParam* memParam ) ;
		
		// I[o[Chsv
		inline BaseDataID * getTargetBaseDataID(){ return targetBaseDataID ; } 
		inline void setTargetBaseDataID(BaseDataID *id){ targetBaseDataID = id ; } 
	
		bool needTransform()
		{ 
			return ( targetBaseDataID 
					&& (targetBaseDataID != BaseDataID::DST_BASE_ID() ) ) ;
		}
	
		//  `ID擾		
		inline DrawDataID * getDrawDataID(){ return drawDataID ; } 

		//  `IDZbg
		inline void setDrawDataID( DrawDataID *id ){ drawDataID = id ; } 
	
		//  sx擾	
		inline float getOpacity( ModelContext &mdc , IDrawContext* cdata ){ return cdata->interpolatedOpacity ; }
	
		//  `I[_[擾	
		inline int getDrawOrder(ModelContext &mdc , IDrawContext* cdata ){ return cdata->interpolatedDrawOrder ; }
		
		inline void setDrawOrder(LDVector<int>* orders )
		{
			for( int i = (int)orders->size()-1 ; i >= 0  ; --i )
			{
				int order = (*orders)[i] ;

				if( order < totalMinOrder ) 		totalMinOrder = order ;
				else if( order > totalMaxOrder ) 	totalMaxOrder = order ;// l Ăꍇ else ifł悢
			}
		} 
	
		
		inline static int getTotalMinOrder(){ return totalMinOrder ; } 
		inline static int getTotalMaxOrder(){ return totalMaxOrder ; } 
		
		// eisetupInterpolation/drawjŖKv̂Ȃŏɍs
		// ep[^ݒ肳ꂽɌĂяo
		virtual IDrawContext* init(ModelContext &mdc) = 0;
		
		// draw̑OiKƂāAԂs
		virtual void setupInterpolate(ModelContext &mdc , IDrawContext* cdata ) ;
		
		// draw̑OiKƂāAό`s
		virtual void setupTransform(ModelContext &mdc , IDrawContext* cdata ) ;
	
		// NbsOȂǂ̑O`
		virtual void preDraw(DrawParam& dp, ModelContext& mdc, IDrawContext* cdata) = 0;

		// `s
		virtual void draw( DrawParam & dp , ModelContext &mdc , IDrawContext* cdata ) = 0 ;
	
		// IDrawDatǎ^ԂBTYPE_DD_TEXTUREȂ
		virtual int getType() ;
		
		// foCXXgɃf[^j
		virtual void deviceLost( IDrawContext* drawContext ) {}
	
		virtual void setZ_TestImpl( ModelContext &mdc , IDrawContext* _cdata , float z ){}
	
#ifdef L2D_DEBUG
		virtual void dump() = 0 ;
#endif
	
	private:
		//Prevention of copy Constructor
		IDrawData( const IDrawData & ) ;
		IDrawData& operator=( const IDrawData & ) ; 	
	
	private:
		static int			totalMinOrder ;		//  s̃f[^mۗp(transient)
		static int			totalMaxOrder ;		//  s̃f[^mۗp(transient)
	
	protected:
		PivotManager *		pivotManager ;
		int 				averageDrawOrder ;	//  `揇ύXȂŕ`ꍇi__L2D_VERSION_STR__ 801ȍ~͎gȂj
		LDVector<DrawDataID*>*	clipIDList;				//  SDK2.1 NbsO`IuWFNgID

	private:
		DrawDataID *		drawDataID ;		//  Ȃ
		BaseDataID *		targetBaseDataID ;	//  Ȃ
		LDVector<int>*		pivotDrawOrder ;	//  ԗppivotSĎ_z [numPivots]
		LDVector<float>*	pivotOpacity ;		//  ԗppivotSĎ_z [numPivots]
	
		bool				dirty ;				//  XVinit()ĂяoKvꍇiԂj
	};
}
//------------ LIVE2D NAMESPACE ------------

#endif // __SKIP_DOC__

#endif	// __LIVE2D_IDRAWDATA_H__