/**
 *  FileFormat2.h
 *
 *  Copyright(c) Live2D Inc. All rights reserved.
 *  [[ CONFIDENTIAL ]]
 */
#include "../io/BReader.h"

#ifndef __LIVE2D_FILE_FORMAT2_H__
#define __LIVE2D_FILE_FORMAT2_H__


#ifndef __SKIP_DOC__

#include "../memory/LDObject.h"

//--------- LIVE2D NAMESPACE ------------
namespace live2d
{ 
	class ClassDef ;
	
	
	class FileFormat2 : public live2d::LDObject 
	{
	public:
		//  Vo[Wꍇ́AKŐVłɂݒ肷
		static const int LIVE2D_FORMAT_VERSION_V2_6_INTIAL 		= 6;	// ŏ̃o[W
		static const int LIVE2D_FORMAT_VERSION_V2_7_OPACITY 	= 7;	// ɑΉ
		static const int LIVE2D_FORMAT_VERSION_V2_8_TEX_OPTION 	= 8;	// eNX`ɃIvVt
		static const int LIVE2D_FORMAT_VERSION_V2_9_AVATAR_PARTS= 9;	// Ao^[̃p[c
		static const int LIVE2D_FORMAT_VERSION_V2_10_SDK2       = 10;	//SDK2.0
		static const int LIVE2D_FORMAT_VERSION_V2_11_SDK2_1 	= 11;	//SDK2.1

		// ---- Ή\ȍŐVł̃t@C ---- Live2D#BUILD_NO 1000
#if defined( L2D_TARGET_PS4 ) || defined( L2D_TARGET_D3D )
		static const int LIVE2D_FORMAT_VERSION_AVAILABLE	 	= LIVE2D_FORMAT_VERSION_V2_11_SDK2_1 ;
#else
		static const int LIVE2D_FORMAT_VERSION_AVAILABLE	 	= LIVE2D_FORMAT_VERSION_V2_10_SDK2 ;
#endif
	
		// --- EOF ̃tO
		static const int LIVE2D_FORMAT_EOF_VALUE = 0x88888888;			// ŏ̃o[W
	
		// ̃o[WŁANX̃[h@g(Live2DFormat.LIVE2D_FORMAT_VERSION)
	//	static const int FILE_FORMAT_VERSION = 0 ;
		static const int NULL_NO	= 0;		// 
		static const int ARRAY_NO	= 23;		// 
		static const int OBJECT_REF = 33;		// ǂݍݍς݃IuWFNg̎Q
	
	public:
		FileFormat2();
		virtual ~FileFormat2();
		
	public:
		//  w肵NX擾
		static ClassDef * getClass( int classNo ) ;
		
		static void * newInstance(MemoryParam* memParam , int classNo) ;

		static bool isSerializable(int classNo) ;

		//  w̃NXԍv~eBu^Ȃtrue
		static bool isPrimitive(int classNo){ return ( 2 <= classNo && classNo <= 9 ) ; }
	
		
		static bool isPrimitiveDouble(int classNo){ return classNo == 30 ; } // ߑł(ύXs)

		
		static bool isPrimitiveFloat(int classNo){ return classNo == 31 ; }// ߑł(ύXs)

		
		static bool isPrimitiveInt(int classNo){ return classNo == 29 ; }// ߑł(ύXs)
	
	};
} 
//------------------------- LIVE2D NAMESPACE ------------

#endif // __SKIP_DOC__

#endif		// __LIVE2D_FILE_FORMAT2_H__